/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.aop.TargetSource;
import org.springframework.jndi.JndiLookupFailureException;
import org.springframework.jndi.JndiObjectLocator;

public class JndiObjectTargetSource
extends JndiObjectLocator
implements TargetSource {
    private boolean lookupOnStartup = true;
    private boolean cache = true;
    private Object cachedObject;
    private Class targetClass;

    public void setLookupOnStartup(boolean bl) {
        this.lookupOnStartup = bl;
    }

    public void setCache(boolean bl) {
        this.cache = bl;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.lookupOnStartup) {
            Object object = this.lookup();
            if (this.cache) {
                this.cachedObject = object;
            } else {
                this.targetClass = object.getClass();
            }
        }
    }

    public Class getTargetClass() {
        if (this.cachedObject != null) {
            return this.cachedObject.getClass();
        }
        if (this.targetClass != null) {
            return this.targetClass;
        }
        return this.getExpectedType();
    }

    public boolean isStatic() {
        return this.cachedObject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTarget() {
        try {
            if (this.lookupOnStartup || !this.cache) {
                return this.cachedObject != null ? this.cachedObject : this.lookup();
            }
            JndiObjectTargetSource jndiObjectTargetSource = this;
            synchronized (jndiObjectTargetSource) {
                if (this.cachedObject == null) {
                    this.cachedObject = this.lookup();
                }
                return this.cachedObject;
            }
        }
        catch (NamingException namingException) {
            throw new JndiLookupFailureException("JndiObjectTargetSource failed to obtain new target object", namingException);
        }
    }

    public void releaseTarget(Object object) {
    }
}

