/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jndi.JndiObjectLocator;
import org.springframework.jndi.JndiObjectTargetSource;
import org.springframework.jndi.TypeMismatchNamingException;
import org.springframework.util.ClassUtils;

public class JndiObjectFactoryBean
extends JndiObjectLocator
implements FactoryBean,
BeanClassLoaderAware {
    private Class[] proxyInterfaces;
    private boolean lookupOnStartup = true;
    private boolean cache = true;
    private Object defaultObject;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Object jndiObject;

    public void setProxyInterface(Class clazz) {
        this.proxyInterfaces = new Class[]{clazz};
    }

    public void setProxyInterfaces(Class[] classArray) {
        this.proxyInterfaces = classArray;
    }

    public void setLookupOnStartup(boolean bl) {
        this.lookupOnStartup = bl;
    }

    public void setCache(boolean bl) {
        this.cache = bl;
    }

    public void setDefaultObject(Object object) {
        this.defaultObject = object;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, NamingException {
        super.afterPropertiesSet();
        if (!this.lookupOnStartup || !this.cache) {
            Class clazz;
            if (this.proxyInterfaces == null && (clazz = this.getExpectedType()) != null) {
                this.proxyInterfaces = clazz.isInterface() ? new Class[]{clazz} : ClassUtils.getAllInterfacesForClass((Class)clazz);
            }
            if (this.proxyInterfaces == null) {
                throw new IllegalArgumentException("Cannot deactivate 'lookupOnStartup' or 'cache' without specifying a 'proxyInterface'");
            }
        }
        if (this.proxyInterfaces != null) {
            if (this.defaultObject != null) {
                throw new IllegalArgumentException("'defaultObject' is not supported in combination with 'proxyInterface'");
            }
            this.jndiObject = JndiObjectProxyFactory.createJndiObjectProxy(this);
        } else {
            if (this.defaultObject != null && this.getExpectedType() != null && !this.getExpectedType().isInstance(this.defaultObject)) {
                throw new IllegalArgumentException("Default object [" + this.defaultObject + "] of type [" + this.defaultObject.getClass().getName() + "] is not of expected type [" + this.getExpectedType().getName() + "]");
            }
            this.jndiObject = this.lookupWithFallback();
        }
    }

    protected Object lookupWithFallback() throws NamingException {
        try {
            return this.lookup();
        }
        catch (TypeMismatchNamingException typeMismatchNamingException) {
            throw typeMismatchNamingException;
        }
        catch (NamingException namingException) {
            if (this.defaultObject != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"JNDI lookup failed - returning specified default object instead", (Throwable)namingException);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("JNDI lookup failed - returning specified default object instead: " + namingException));
                }
                return this.defaultObject;
            }
            throw namingException;
        }
    }

    public Object getObject() {
        return this.jndiObject;
    }

    public Class getObjectType() {
        if (this.proxyInterfaces != null) {
            if (this.proxyInterfaces.length == 1) {
                return this.proxyInterfaces[0];
            }
            if (this.proxyInterfaces.length > 1) {
                return this.createCompositeInterface(this.proxyInterfaces);
            }
        }
        if (this.jndiObject != null) {
            return this.jndiObject.getClass();
        }
        return this.getExpectedType();
    }

    public boolean isSingleton() {
        return true;
    }

    protected Class createCompositeInterface(Class[] classArray) {
        return ClassUtils.createCompositeInterface((Class[])classArray, (ClassLoader)this.beanClassLoader);
    }

    private static class JndiObjectProxyFactory {
        private JndiObjectProxyFactory() {
        }

        private static Object createJndiObjectProxy(JndiObjectFactoryBean jndiObjectFactoryBean) throws NamingException {
            JndiObjectTargetSource jndiObjectTargetSource = new JndiObjectTargetSource();
            jndiObjectTargetSource.setJndiTemplate(jndiObjectFactoryBean.getJndiTemplate());
            jndiObjectTargetSource.setJndiName(jndiObjectFactoryBean.getJndiName());
            jndiObjectTargetSource.setExpectedType(jndiObjectFactoryBean.getExpectedType());
            jndiObjectTargetSource.setResourceRef(jndiObjectFactoryBean.isResourceRef());
            jndiObjectTargetSource.setLookupOnStartup(jndiObjectFactoryBean.lookupOnStartup);
            jndiObjectTargetSource.setCache(jndiObjectFactoryBean.cache);
            jndiObjectTargetSource.afterPropertiesSet();
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setInterfaces(jndiObjectFactoryBean.proxyInterfaces);
            proxyFactory.setTargetSource((TargetSource)jndiObjectTargetSource);
            return proxyFactory.getProxy(jndiObjectFactoryBean.beanClassLoader);
        }
    }
}

