/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import javax.naming.NamingException;
import org.springframework.jndi.JndiAccessor;
import org.springframework.util.Assert;

public abstract class JndiLocatorSupport
extends JndiAccessor {
    public static final String CONTAINER_PREFIX = "java:comp/env/";
    private boolean resourceRef = false;

    public void setResourceRef(boolean bl) {
        this.resourceRef = bl;
    }

    public boolean isResourceRef() {
        return this.resourceRef;
    }

    protected Object lookup(String string) throws NamingException {
        return this.lookup(string, null);
    }

    protected Object lookup(String string, Class clazz) throws NamingException {
        Assert.notNull((Object)string, (String)"'jndiName' must not be null");
        String string2 = this.convertJndiName(string);
        Object object = this.getJndiTemplate().lookup(string2, clazz);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Located object with JNDI name [" + string2 + "]"));
        }
        return object;
    }

    protected String convertJndiName(String string) {
        if (this.isResourceRef() && !string.startsWith(CONTAINER_PREFIX) && string.indexOf(58) == -1) {
            string = CONTAINER_PREFIX + string;
        }
        return string;
    }
}

