/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.glassfish;

import com.sun.enterprise.loader.InstrumentableClassLoader;
import java.lang.instrument.ClassFileTransformer;
import javax.persistence.spi.ClassTransformer;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.glassfish.ClassTransformerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GlassFishLoadTimeWeaver
implements LoadTimeWeaver {
    private final InstrumentableClassLoader classLoader;

    public GlassFishLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public GlassFishLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null");
        InstrumentableClassLoader instrumentableClassLoader = this.determineClassLoader(classLoader);
        if (instrumentableClassLoader == null) {
            throw new IllegalArgumentException(classLoader + " and its parents are not suitable ClassLoaders: " + "An [" + InstrumentableClassLoader.class.getName() + "] implementation is required.");
        }
        this.classLoader = instrumentableClassLoader;
    }

    protected InstrumentableClassLoader determineClassLoader(ClassLoader classLoader) {
        for (ClassLoader classLoader2 = classLoader; classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            if (!(classLoader2 instanceof InstrumentableClassLoader)) continue;
            return (InstrumentableClassLoader)classLoader2;
        }
        return null;
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        this.classLoader.addTransformer((ClassTransformer)new ClassTransformerAdapter(classFileTransformer));
    }

    public ClassLoader getInstrumentableClassLoader() {
        return (ClassLoader)this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.classLoader.copy();
    }
}

