/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowingClassLoader
extends ClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "com.sun.", "org.w3c.", "org.xml.", "org.dom4j.", "org.aspectj.", "org.apache.xerces.", "org.apache.commons.logging."};
    private final ClassLoader enclosingClassLoader;
    private final List<ClassFileTransformer> classFileTransformers = new LinkedList<ClassFileTransformer>();
    private final Map<String, Class> classCache = new HashMap<String, Class>();

    public ShadowingClassLoader(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"Enclosing ClassLoader must not be null");
        this.enclosingClassLoader = classLoader;
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        Assert.notNull((Object)classFileTransformer, (String)"Transformer must not be null");
        this.classFileTransformers.add(classFileTransformer);
    }

    public void copyTransformers(ShadowingClassLoader shadowingClassLoader) {
        Assert.notNull((Object)shadowingClassLoader, (String)"Other ClassLoader must not be null");
        this.classFileTransformers.addAll(shadowingClassLoader.classFileTransformers);
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        if (this.shouldShadow(string)) {
            Class clazz = this.classCache.get(string);
            if (clazz != null) {
                return clazz;
            }
            return this.doLoadClass(string);
        }
        return this.enclosingClassLoader.loadClass(string);
    }

    private boolean shouldShadow(String string) {
        return !string.equals(this.getClass().getName()) && !string.endsWith("ShadowingClassLoader") && !this.isExcludedPackage(string) && !this.isClassNameExcludedFromShadowing(string);
    }

    private boolean isExcludedPackage(String string) {
        for (int i = 0; i < DEFAULT_EXCLUDED_PACKAGES.length; ++i) {
            if (!string.startsWith(DEFAULT_EXCLUDED_PACKAGES[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassNameExcludedFromShadowing(String string) {
        return false;
    }

    private Class doLoadClass(String string) throws ClassNotFoundException {
        String string2 = StringUtils.replace((String)string, (String)".", (String)"/") + ".class";
        InputStream inputStream = this.enclosingClassLoader.getResourceAsStream(string2);
        if (inputStream == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            byte[] byArray = FileCopyUtils.copyToByteArray((InputStream)inputStream);
            byArray = this.applyTransformers(string, byArray);
            Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (clazz.getPackage() == null) {
                String string3 = string.substring(0, string.lastIndexOf(46));
                this.definePackage(string3, null, null, null, null, null, null, null);
            }
            this.classCache.put(string, clazz);
            return clazz;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Cannot load resource for class [" + string + "]", iOException);
        }
    }

    private byte[] applyTransformers(String string, byte[] byArray) {
        String string2 = StringUtils.replace((String)string, (String)".", (String)"/");
        try {
            for (ClassFileTransformer classFileTransformer : this.classFileTransformers) {
                byte[] byArray2 = classFileTransformer.transform(this, string2, null, null, byArray);
                byArray = byArray2 != null ? byArray2 : byArray;
            }
            return byArray;
        }
        catch (IllegalClassFormatException illegalClassFormatException) {
            throw new IllegalStateException(illegalClassFormatException);
        }
    }

    @Override
    public URL getResource(String string) {
        return this.enclosingClassLoader.getResource(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        return this.enclosingClassLoader.getResourceAsStream(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        return this.enclosingClassLoader.getResources(string);
    }
}

