/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.instrument.classloading.ShadowingClassLoader;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceOverridingShadowingClassLoader
extends ShadowingClassLoader {
    private static final Enumeration<URL> EMPTY_URL_ENUMERATION = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new UnsupportedOperationException("Should not be called. I am empty.");
        }
    };
    private Map<String, String> overrides = new HashMap<String, String>();

    public ResourceOverridingShadowingClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void override(String string, String string2) {
        this.overrides.put(string, string2);
    }

    public void suppress(String string) {
        this.overrides.put(string, null);
    }

    public void copyOverrides(ResourceOverridingShadowingClassLoader resourceOverridingShadowingClassLoader) {
        Assert.notNull((Object)resourceOverridingShadowingClassLoader, (String)"Other ClassLoader must not be null");
        this.overrides.putAll(resourceOverridingShadowingClassLoader.overrides);
    }

    @Override
    public URL getResource(String string) {
        if (this.overrides.containsKey(string)) {
            String string2 = this.overrides.get(string);
            return string2 != null ? super.getResource(string2) : null;
        }
        return super.getResource(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (this.overrides.containsKey(string)) {
            String string2 = this.overrides.get(string);
            return string2 != null ? super.getResourceAsStream(string2) : null;
        }
        return super.getResourceAsStream(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        if (this.overrides.containsKey(string)) {
            String string2 = this.overrides.get(string);
            return string2 != null ? super.getResources(string2) : EMPTY_URL_ENUMERATION;
        }
        return super.getResources(string);
    }
}

