/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.StaticMessageSource;

public class StaticApplicationContext
extends GenericApplicationContext {
    private final StaticMessageSource staticMessageSource = new StaticMessageSource();

    public StaticApplicationContext() throws BeansException {
        this((ApplicationContext)null);
    }

    public StaticApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super(applicationContext);
        this.getBeanFactory().registerSingleton("messageSource", (Object)this.staticMessageSource);
    }

    public StaticMessageSource getStaticMessageSource() {
        return this.staticMessageSource;
    }

    public void registerSingleton(String string, Class clazz) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(string, (BeanDefinition)new RootBeanDefinition(clazz));
    }

    public void registerSingleton(String string, Class clazz, MutablePropertyValues mutablePropertyValues) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(string, (BeanDefinition)new RootBeanDefinition(clazz, mutablePropertyValues));
    }

    public void registerPrototype(String string, Class clazz) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(string, (BeanDefinition)new RootBeanDefinition(clazz, false));
    }

    public void registerPrototype(String string, Class clazz, MutablePropertyValues mutablePropertyValues) throws BeansException {
        this.getDefaultListableBeanFactory().registerBeanDefinition(string, (BeanDefinition)new RootBeanDefinition(clazz, mutablePropertyValues, false));
    }

    public void addMessage(String string, Locale locale, String string2) {
        this.getStaticMessageSource().addMessage(string, locale, string2);
    }
}

