/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ResourceBundleMessageSource
extends AbstractMessageSource
implements BeanClassLoaderAware {
    private String[] basenames = new String[0];
    private ClassLoader bundleClassLoader;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final Map cachedResourceBundles = new HashMap();
    private final Map cachedBundleMessageFormats = new HashMap();

    public void setBasename(String string) {
        this.setBasenames(new String[]{string});
    }

    public void setBasenames(String[] stringArray) {
        if (stringArray != null) {
            this.basenames = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Assert.hasText((String)string, (String)"Basename must not be empty");
                this.basenames[i] = string.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader != null ? this.bundleClassLoader : this.beanClassLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    protected String resolveCodeWithoutArguments(String string, Locale locale) {
        String string2 = null;
        for (int i = 0; string2 == null && i < this.basenames.length; ++i) {
            ResourceBundle resourceBundle = this.getResourceBundle(this.basenames[i], locale);
            if (resourceBundle == null) continue;
            string2 = this.getStringOrNull(resourceBundle, string);
        }
        return string2;
    }

    protected MessageFormat resolveCode(String string, Locale locale) {
        MessageFormat messageFormat = null;
        for (int i = 0; messageFormat == null && i < this.basenames.length; ++i) {
            ResourceBundle resourceBundle = this.getResourceBundle(this.basenames[i], locale);
            if (resourceBundle == null) continue;
            messageFormat = this.getMessageFormat(resourceBundle, string, locale);
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getResourceBundle(String string, Locale locale) {
        Map map = this.cachedResourceBundles;
        synchronized (map) {
            ResourceBundle resourceBundle;
            HashMap<Locale, ResourceBundle> hashMap = (HashMap<Locale, ResourceBundle>)this.cachedResourceBundles.get(string);
            if (hashMap != null && (resourceBundle = (ResourceBundle)hashMap.get(locale)) != null) {
                return resourceBundle;
            }
            try {
                resourceBundle = this.doGetBundle(string, locale);
                if (hashMap == null) {
                    hashMap = new HashMap<Locale, ResourceBundle>();
                    this.cachedResourceBundles.put(string, hashMap);
                }
                hashMap.put(locale, resourceBundle);
                return resourceBundle;
            }
            catch (MissingResourceException missingResourceException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("ResourceBundle [" + string + "] not found for MessageSource: " + missingResourceException.getMessage()));
                }
                return null;
            }
        }
    }

    protected ResourceBundle doGetBundle(String string, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(string, locale, this.getBundleClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageFormat getMessageFormat(ResourceBundle resourceBundle, String string, Locale locale) throws MissingResourceException {
        Map map = this.cachedBundleMessageFormats;
        synchronized (map) {
            Object object;
            HashMap hashMap = (HashMap)this.cachedBundleMessageFormats.get(resourceBundle);
            HashMap<Locale, MessageFormat> hashMap2 = null;
            if (hashMap != null && (hashMap2 = (HashMap<Locale, MessageFormat>)hashMap.get(string)) != null && (object = (MessageFormat)hashMap2.get(locale)) != null) {
                return object;
            }
            object = this.getStringOrNull(resourceBundle, string);
            if (object != null) {
                if (hashMap == null) {
                    hashMap = new HashMap();
                    this.cachedBundleMessageFormats.put(resourceBundle, hashMap);
                }
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<Locale, MessageFormat>();
                    hashMap.put(string, hashMap2);
                }
                MessageFormat messageFormat = this.createMessageFormat((String)object, locale);
                hashMap2.put(locale, messageFormat);
                return messageFormat;
            }
            return null;
        }
    }

    private String getStringOrNull(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString((Object[])this.basenames) + "]";
    }
}

