/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class ReloadableResourceBundleMessageSource
extends AbstractMessageSource
implements ResourceLoaderAware {
    private static final String PROPERTIES_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    private String[] basenames = new String[0];
    private String defaultEncoding;
    private Properties fileEncodings;
    private boolean fallbackToSystemLocale = true;
    private long cacheMillis = -1L;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final Map cachedFilenames = new HashMap();
    private final Map cachedProperties = new HashMap();
    private final Map cachedMergedProperties = new HashMap();

    public void setBasename(String string) {
        this.setBasenames(new String[]{string});
    }

    public void setBasenames(String[] stringArray) {
        if (stringArray != null) {
            this.basenames = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                Assert.hasText((String)string, (String)"Basename must not be empty");
                this.basenames[i] = string.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setDefaultEncoding(String string) {
        this.defaultEncoding = string;
    }

    public void setFileEncodings(Properties properties) {
        this.fileEncodings = properties;
    }

    public void setFallbackToSystemLocale(boolean bl) {
        this.fallbackToSystemLocale = bl;
    }

    public void setCacheSeconds(int n) {
        this.cacheMillis = n * 1000;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    protected String resolveCodeWithoutArguments(String string, Locale locale) {
        if (this.cacheMillis < 0L) {
            PropertiesHolder propertiesHolder = this.getMergedProperties(locale);
            String string2 = propertiesHolder.getProperty(string);
            if (string2 != null) {
                return string2;
            }
        } else {
            for (int i = 0; i < this.basenames.length; ++i) {
                List list = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = 0; j < list.size(); ++j) {
                    String string3 = (String)list.get(j);
                    PropertiesHolder propertiesHolder = this.getProperties(string3);
                    String string4 = propertiesHolder.getProperty(string);
                    if (string4 == null) continue;
                    return string4;
                }
            }
        }
        return null;
    }

    protected MessageFormat resolveCode(String string, Locale locale) {
        if (this.cacheMillis < 0L) {
            PropertiesHolder propertiesHolder = this.getMergedProperties(locale);
            MessageFormat messageFormat = propertiesHolder.getMessageFormat(string, locale);
            if (messageFormat != null) {
                return messageFormat;
            }
        } else {
            for (int i = 0; i < this.basenames.length; ++i) {
                List list = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = 0; j < list.size(); ++j) {
                    String string2 = (String)list.get(j);
                    PropertiesHolder propertiesHolder = this.getProperties(string2);
                    MessageFormat messageFormat = propertiesHolder.getMessageFormat(string, locale);
                    if (messageFormat == null) continue;
                    return messageFormat;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getMergedProperties(Locale locale) {
        Map map = this.cachedMergedProperties;
        synchronized (map) {
            PropertiesHolder propertiesHolder = (PropertiesHolder)this.cachedMergedProperties.get(locale);
            if (propertiesHolder != null) {
                return propertiesHolder;
            }
            Properties properties = new Properties();
            propertiesHolder = new PropertiesHolder(properties, -1L);
            for (int i = this.basenames.length - 1; i >= 0; --i) {
                List list = this.calculateAllFilenames(this.basenames[i], locale);
                for (int j = list.size() - 1; j >= 0; --j) {
                    String string = (String)list.get(j);
                    PropertiesHolder propertiesHolder2 = this.getProperties(string);
                    if (propertiesHolder2.getProperties() == null) continue;
                    properties.putAll((Map<?, ?>)propertiesHolder2.getProperties());
                }
            }
            this.cachedMergedProperties.put(locale, propertiesHolder);
            return propertiesHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List calculateAllFilenames(String string, Locale locale) {
        Map map = this.cachedFilenames;
        synchronized (map) {
            ArrayList<String> arrayList;
            HashMap hashMap = (HashMap)this.cachedFilenames.get(string);
            if (hashMap != null && (arrayList = (ArrayList<String>)hashMap.get(locale)) != null) {
                return arrayList;
            }
            arrayList = new ArrayList<String>(7);
            arrayList.addAll(this.calculateFilenamesForLocale(string, locale));
            if (this.fallbackToSystemLocale && !locale.equals(Locale.getDefault())) {
                List list = this.calculateFilenamesForLocale(string, Locale.getDefault());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
            }
            arrayList.add(string);
            if (hashMap != null) {
                hashMap.put(locale, arrayList);
            } else {
                hashMap = new HashMap();
                hashMap.put(locale, arrayList);
                this.cachedFilenames.put(string, hashMap);
            }
            return arrayList;
        }
    }

    protected List calculateFilenamesForLocale(String string, Locale locale) {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2.length() > 0) {
            stringBuffer.append('_').append(string2);
            arrayList.add(0, stringBuffer.toString());
        }
        if (string3.length() > 0) {
            stringBuffer.append('_').append(string3);
            arrayList.add(0, stringBuffer.toString());
        }
        if (string4.length() > 0) {
            stringBuffer.append('_').append(string4);
            arrayList.add(0, stringBuffer.toString());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getProperties(String string) {
        Map map = this.cachedProperties;
        synchronized (map) {
            PropertiesHolder propertiesHolder = (PropertiesHolder)this.cachedProperties.get(string);
            if (propertiesHolder != null && (propertiesHolder.getRefreshTimestamp() < 0L || propertiesHolder.getRefreshTimestamp() > System.currentTimeMillis() - this.cacheMillis)) {
                return propertiesHolder;
            }
            return this.refreshProperties(string, propertiesHolder);
        }
    }

    protected PropertiesHolder refreshProperties(String string, PropertiesHolder propertiesHolder) {
        long l = this.cacheMillis < 0L ? -1L : System.currentTimeMillis();
        Resource resource = this.resourceLoader.getResource(string + PROPERTIES_SUFFIX);
        if (!resource.exists()) {
            resource = this.resourceLoader.getResource(string + XML_SUFFIX);
        }
        if (resource.exists()) {
            try {
                Serializable serializable;
                long l2 = -1L;
                if (this.cacheMillis >= 0L) {
                    serializable = null;
                    try {
                        serializable = resource.getFile();
                    }
                    catch (IOException iOException) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)(resource + " could not be resolved in the file system - assuming that is hasn't changed"), (Throwable)iOException);
                        }
                        serializable = null;
                    }
                    if (serializable != null) {
                        l2 = ((File)serializable).lastModified();
                        if (l2 == 0L) {
                            throw new IOException("File [" + ((File)serializable).getAbsolutePath() + "] does not exist");
                        }
                        if (propertiesHolder != null && propertiesHolder.getFileTimestamp() == l2) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Re-caching properties for filename [" + string + "] - file hasn't been modified"));
                            }
                            propertiesHolder.setRefreshTimestamp(l);
                            return propertiesHolder;
                        }
                    }
                }
                serializable = this.loadProperties(resource, string);
                propertiesHolder = new PropertiesHolder((Properties)serializable, l2);
            }
            catch (IOException iOException) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Could not parse properties file [" + resource.getFilename() + "]: " + iOException.getMessage()), (Throwable)iOException);
                }
                propertiesHolder = new PropertiesHolder();
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No properties file found for [" + string + "] - neither plain properties nor XML"));
            }
            propertiesHolder = new PropertiesHolder();
        }
        propertiesHolder.setRefreshTimestamp(l);
        this.cachedProperties.put(string, propertiesHolder);
        return propertiesHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(Resource resource, String string) throws IOException {
        InputStream inputStream = resource.getInputStream();
        Properties properties = new Properties();
        try {
            Object object;
            if (resource.getFilename().endsWith(XML_SUFFIX)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loading properties [" + resource.getFilename() + "]"));
                }
                this.propertiesPersister.loadFromXml(properties, inputStream);
            } else {
                object = null;
                if (this.fileEncodings != null) {
                    object = this.fileEncodings.getProperty(string);
                }
                if (object == null) {
                    object = this.defaultEncoding;
                }
                if (object != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Loading properties [" + resource.getFilename() + "] with encoding '" + (String)object + "'"));
                    }
                    this.propertiesPersister.load(properties, (Reader)new InputStreamReader(inputStream, (String)object));
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Loading properties [" + resource.getFilename() + "]"));
                    }
                    this.propertiesPersister.load(properties, inputStream);
                }
            }
            object = properties;
            return object;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.debug((Object)"Clearing entire resource bundle cache");
        Map map = this.cachedProperties;
        synchronized (map) {
            this.cachedProperties.clear();
        }
        map = this.cachedMergedProperties;
        synchronized (map) {
            this.cachedMergedProperties.clear();
        }
    }

    public void clearCacheIncludingAncestors() {
        this.clearCache();
        if (this.getParentMessageSource() instanceof ReloadableResourceBundleMessageSource) {
            ((ReloadableResourceBundleMessageSource)this.getParentMessageSource()).clearCacheIncludingAncestors();
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString((Object[])this.basenames) + "]";
    }

    protected class PropertiesHolder {
        private Properties properties;
        private long fileTimestamp = -1L;
        private long refreshTimestamp = -1L;
        private final Map cachedMessageFormats = new HashMap();

        public PropertiesHolder(Properties properties, long l) {
            this.properties = properties;
            this.fileTimestamp = l;
        }

        public PropertiesHolder() {
        }

        public Properties getProperties() {
            return this.properties;
        }

        public long getFileTimestamp() {
            return this.fileTimestamp;
        }

        public void setRefreshTimestamp(long l) {
            this.refreshTimestamp = l;
        }

        public long getRefreshTimestamp() {
            return this.refreshTimestamp;
        }

        public String getProperty(String string) {
            if (this.properties == null) {
                return null;
            }
            return this.properties.getProperty(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageFormat getMessageFormat(String string, Locale locale) {
            if (this.properties == null) {
                return null;
            }
            Map map = this.cachedMessageFormats;
            synchronized (map) {
                Object object;
                HashMap<Locale, MessageFormat> hashMap = (HashMap<Locale, MessageFormat>)this.cachedMessageFormats.get(string);
                if (hashMap != null && (object = (MessageFormat)hashMap.get(locale)) != null) {
                    return object;
                }
                object = this.properties.getProperty(string);
                if (object != null) {
                    if (hashMap == null) {
                        hashMap = new HashMap<Locale, MessageFormat>();
                        this.cachedMessageFormats.put(string, hashMap);
                    }
                    MessageFormat messageFormat = ReloadableResourceBundleMessageSource.this.createMessageFormat((String)object, locale);
                    hashMap.put(locale, messageFormat);
                    return messageFormat;
                }
                return null;
            }
        }
    }
}

