/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageSourceAccessor {
    private final MessageSource messageSource;
    private final Locale defaultLocale;

    public MessageSourceAccessor(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.defaultLocale = null;
    }

    public MessageSourceAccessor(MessageSource messageSource, Locale locale) {
        this.messageSource = messageSource;
        this.defaultLocale = locale;
    }

    protected Locale getDefaultLocale() {
        return this.defaultLocale != null ? this.defaultLocale : LocaleContextHolder.getLocale();
    }

    public String getMessage(String string, String string2) {
        return this.messageSource.getMessage(string, null, string2, this.getDefaultLocale());
    }

    public String getMessage(String string, String string2, Locale locale) {
        return this.messageSource.getMessage(string, null, string2, locale);
    }

    public String getMessage(String string, Object[] objectArray, String string2) {
        return this.messageSource.getMessage(string, objectArray, string2, this.getDefaultLocale());
    }

    public String getMessage(String string, Object[] objectArray, String string2, Locale locale) {
        return this.messageSource.getMessage(string, objectArray, string2, locale);
    }

    public String getMessage(String string) throws NoSuchMessageException {
        return this.messageSource.getMessage(string, null, this.getDefaultLocale());
    }

    public String getMessage(String string, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(string, null, locale);
    }

    public String getMessage(String string, Object[] objectArray) throws NoSuchMessageException {
        return this.messageSource.getMessage(string, objectArray, this.getDefaultLocale());
    }

    public String getMessage(String string, Object[] objectArray, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(string, objectArray, locale);
    }

    public String getMessage(MessageSourceResolvable messageSourceResolvable) throws NoSuchMessageException {
        return this.messageSource.getMessage(messageSourceResolvable, this.getDefaultLocale());
    }

    public String getMessage(MessageSourceResolvable messageSourceResolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(messageSourceResolvable, locale);
    }
}

