/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

public class GenericApplicationContext
extends AbstractApplicationContext
implements BeanDefinitionRegistry {
    private final DefaultListableBeanFactory beanFactory;
    private ResourceLoader resourceLoader;
    private boolean refreshed = false;

    public GenericApplicationContext() {
        this.beanFactory = new DefaultListableBeanFactory();
    }

    public GenericApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory) {
        Assert.notNull((Object)defaultListableBeanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = defaultListableBeanFactory;
    }

    public GenericApplicationContext(ApplicationContext applicationContext) {
        this();
        this.setParent(applicationContext);
    }

    public GenericApplicationContext(DefaultListableBeanFactory defaultListableBeanFactory, ApplicationContext applicationContext) {
        this(defaultListableBeanFactory);
        this.setParent(applicationContext);
    }

    public void setParent(ApplicationContext applicationContext) {
        super.setParent(applicationContext);
        this.beanFactory.setParentBeanFactory(this.getInternalParentBeanFactory());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Resource getResource(String string) {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getResource(string);
        }
        return super.getResource(string);
    }

    public Resource[] getResources(String string) throws IOException {
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            return ((ResourcePatternResolver)this.resourceLoader).getResources(string);
        }
        return super.getResources(string);
    }

    protected final void refreshBeanFactory() throws IllegalStateException {
        if (this.refreshed) {
            throw new IllegalStateException("GenericApplicationContext does not support multiple refresh attempts: just call 'refresh' once");
        }
        this.refreshed = true;
    }

    protected final void closeBeanFactory() {
    }

    public final ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public final DefaultListableBeanFactory getDefaultListableBeanFactory() {
        return this.beanFactory;
    }

    public BeanDefinition getBeanDefinition(String string) throws BeansException {
        return this.beanFactory.getBeanDefinition(string);
    }

    public void registerBeanDefinition(String string, BeanDefinition beanDefinition) throws BeansException {
        this.beanFactory.registerBeanDefinition(string, beanDefinition);
    }

    public void registerAlias(String string, String string2) throws BeansException {
        this.beanFactory.registerAlias(string, string2);
    }
}

