/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class DelegatingMessageSource
implements HierarchicalMessageSource {
    private MessageSource parentMessageSource;

    public void setParentMessageSource(MessageSource messageSource) {
        this.parentMessageSource = messageSource;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public String getMessage(String string, Object[] objectArray, String string2, Locale locale) {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(string, objectArray, string2, locale);
        }
        return string2;
    }

    public String getMessage(String string, Object[] objectArray, Locale locale) throws NoSuchMessageException {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(string, objectArray, locale);
        }
        throw new NoSuchMessageException(string, locale);
    }

    public String getMessage(MessageSourceResolvable messageSourceResolvable, Locale locale) throws NoSuchMessageException {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(messageSourceResolvable, locale);
        }
        if (messageSourceResolvable.getDefaultMessage() != null) {
            return messageSourceResolvable.getDefaultMessage();
        }
        String[] stringArray = messageSourceResolvable.getCodes();
        String string = stringArray != null && stringArray.length > 0 ? stringArray[0] : null;
        throw new NoSuchMessageException(string, locale);
    }
}

