/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.Serializable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultMessageSourceResolvable
implements MessageSourceResolvable,
Serializable {
    private final String[] codes;
    private final Object[] arguments;
    private final String defaultMessage;

    public DefaultMessageSourceResolvable(String string) {
        this(new String[]{string}, null, null);
    }

    public DefaultMessageSourceResolvable(String[] stringArray) {
        this(stringArray, null, null);
    }

    public DefaultMessageSourceResolvable(String[] stringArray, String string) {
        this(stringArray, null, string);
    }

    public DefaultMessageSourceResolvable(String[] stringArray, Object[] objectArray) {
        this(stringArray, objectArray, null);
    }

    public DefaultMessageSourceResolvable(String[] stringArray, Object[] objectArray, String string) {
        this.codes = stringArray;
        this.arguments = objectArray;
        this.defaultMessage = string;
    }

    public DefaultMessageSourceResolvable(MessageSourceResolvable messageSourceResolvable) {
        this(messageSourceResolvable.getCodes(), messageSourceResolvable.getArguments(), messageSourceResolvable.getDefaultMessage());
    }

    public String[] getCodes() {
        return this.codes;
    }

    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    protected final String resolvableToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("codes [").append(StringUtils.arrayToDelimitedString((Object[])this.codes, (String)","));
        stringBuffer.append("]; arguments [" + StringUtils.arrayToDelimitedString((Object[])this.arguments, (String)","));
        stringBuffer.append("]; default message [").append(this.defaultMessage).append(']');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.resolvableToString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessageSourceResolvable)) {
            return false;
        }
        MessageSourceResolvable messageSourceResolvable = (MessageSourceResolvable)object;
        return ObjectUtils.nullSafeEquals((Object)this.getCodes(), (Object)messageSourceResolvable.getCodes());
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object[])this.getCodes());
    }
}

