/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ClassPathXmlApplicationContext
extends AbstractXmlApplicationContext {
    private Resource[] configResources;
    private String[] configLocations;

    public ClassPathXmlApplicationContext(String string) throws BeansException {
        this(new String[]{string});
    }

    public ClassPathXmlApplicationContext(String[] stringArray) throws BeansException {
        this(stringArray, (ApplicationContext)null);
    }

    public ClassPathXmlApplicationContext(String[] stringArray, ApplicationContext applicationContext) throws BeansException {
        super(applicationContext);
        this.configLocations = stringArray;
        this.refresh();
    }

    public ClassPathXmlApplicationContext(String[] stringArray, boolean bl) throws BeansException {
        this(stringArray, bl, null);
    }

    public ClassPathXmlApplicationContext(String[] stringArray, boolean bl, ApplicationContext applicationContext) throws BeansException {
        super(applicationContext);
        this.configLocations = stringArray;
        if (bl) {
            this.refresh();
        }
    }

    public ClassPathXmlApplicationContext(String string, Class clazz) throws BeansException {
        this(new String[]{string}, clazz);
    }

    public ClassPathXmlApplicationContext(String[] stringArray, Class clazz) throws BeansException {
        this(stringArray, clazz, null);
    }

    public ClassPathXmlApplicationContext(String[] stringArray, Class clazz, ApplicationContext applicationContext) throws BeansException {
        super(applicationContext);
        Assert.notNull((Object)stringArray, (String)"Path array must not be null");
        Assert.notNull((Object)clazz, (String)"Class argument must not be null");
        this.configResources = new Resource[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.configResources[i] = new ClassPathResource(stringArray[i], clazz);
        }
        this.refresh();
    }

    protected Resource[] getConfigResources() {
        return this.configResources;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }
}

