/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class ApplicationContextAwareProcessor
implements BeanPostProcessor {
    private final ApplicationContext applicationContext;

    public ApplicationContextAwareProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object object, String string) throws BeansException {
        if (object instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)object).setResourceLoader((ResourceLoader)this.applicationContext);
        }
        if (object instanceof ApplicationEventPublisherAware) {
            ((ApplicationEventPublisherAware)object).setApplicationEventPublisher(this.applicationContext);
        }
        if (object instanceof MessageSourceAware) {
            ((MessageSourceAware)object).setMessageSource(this.applicationContext);
        }
        if (object instanceof ApplicationContextAware) {
            ((ApplicationContextAware)object).setApplicationContext(this.applicationContext);
        }
        return object;
    }

    public Object postProcessAfterInitialization(Object object, String string) {
        return object;
    }
}

