/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.AbstractApplicationContext;

public abstract class AbstractRefreshableApplicationContext
extends AbstractApplicationContext {
    private DefaultListableBeanFactory beanFactory;
    private final Object beanFactoryMonitor = new Object();

    public AbstractRefreshableApplicationContext() {
    }

    public AbstractRefreshableApplicationContext(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshBeanFactory() throws BeansException {
        DefaultListableBeanFactory defaultListableBeanFactory = null;
        Object object = this.beanFactoryMonitor;
        synchronized (object) {
            defaultListableBeanFactory = this.beanFactory;
        }
        if (defaultListableBeanFactory != null) {
            defaultListableBeanFactory.destroySingletons();
            object = this.beanFactoryMonitor;
            synchronized (object) {
                this.beanFactory = null;
            }
        }
        try {
            object = this.createBeanFactory();
            this.customizeBeanFactory((DefaultListableBeanFactory)object);
            this.loadBeanDefinitions((DefaultListableBeanFactory)object);
            Object object2 = this.beanFactoryMonitor;
            synchronized (object2) {
                this.beanFactory = object;
            }
        }
        catch (IOException iOException) {
            throw new ApplicationContextException("I/O error parsing XML document for application context [" + this.getDisplayName() + "]", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeBeanFactory() {
        Object object = this.beanFactoryMonitor;
        synchronized (object) {
            this.beanFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConfigurableListableBeanFactory getBeanFactory() {
        Object object = this.beanFactoryMonitor;
        synchronized (object) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("BeanFactory not initialized or already closed - call 'refresh' before accessing beans via the ApplicationContext");
            }
            return this.beanFactory;
        }
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        return new DefaultListableBeanFactory(this.getInternalParentBeanFactory());
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory defaultListableBeanFactory) {
    }

    protected abstract void loadBeanDefinitions(DefaultListableBeanFactory var1) throws IOException, BeansException;
}

