/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.ObjectUtils;

public abstract class AbstractMessageSource
implements HierarchicalMessageSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MessageSource parentMessageSource;
    private boolean useCodeAsDefaultMessage = false;
    private boolean alwaysUseMessageFormat = false;
    private final Map cachedMessageFormats = new HashMap();

    public void setParentMessageSource(MessageSource messageSource) {
        this.parentMessageSource = messageSource;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public void setUseCodeAsDefaultMessage(boolean bl) {
        this.useCodeAsDefaultMessage = bl;
    }

    protected boolean isUseCodeAsDefaultMessage() {
        return this.useCodeAsDefaultMessage;
    }

    public void setAlwaysUseMessageFormat(boolean bl) {
        this.alwaysUseMessageFormat = bl;
    }

    protected boolean isAlwaysUseMessageFormat() {
        return this.alwaysUseMessageFormat;
    }

    public final String getMessage(String string, Object[] objectArray, String string2, Locale locale) {
        String string3;
        String string4 = this.getMessageInternal(string, objectArray, locale);
        if (string4 != null) {
            return string4;
        }
        if (string2 == null && (string3 = this.getDefaultMessage(string)) != null) {
            return string3;
        }
        return this.renderDefaultMessage(string2, objectArray, locale);
    }

    public final String getMessage(String string, Object[] objectArray, Locale locale) throws NoSuchMessageException {
        String string2 = this.getMessageInternal(string, objectArray, locale);
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getDefaultMessage(string);
        if (string3 != null) {
            return string3;
        }
        throw new NoSuchMessageException(string, locale);
    }

    public final String getMessage(MessageSourceResolvable messageSourceResolvable, Locale locale) throws NoSuchMessageException {
        String string;
        String[] stringArray = messageSourceResolvable.getCodes();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = this.getMessageInternal(stringArray[i], messageSourceResolvable.getArguments(), locale);
            if (string2 == null) continue;
            return string2;
        }
        if (messageSourceResolvable.getDefaultMessage() != null) {
            return this.renderDefaultMessage(messageSourceResolvable.getDefaultMessage(), messageSourceResolvable.getArguments(), locale);
        }
        if (stringArray.length > 0 && (string = this.getDefaultMessage(stringArray[0])) != null) {
            return string;
        }
        throw new NoSuchMessageException(stringArray.length > 0 ? stringArray[stringArray.length - 1] : null, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMessageInternal(String string, Object[] objectArray, Locale locale) {
        if (string == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Object[] objectArray2 = objectArray;
        if (!this.isAlwaysUseMessageFormat() && ObjectUtils.isEmpty((Object[])objectArray)) {
            String string2 = this.resolveCodeWithoutArguments(string, locale);
            if (string2 != null) {
                return string2;
            }
        } else {
            objectArray2 = this.resolveArguments(objectArray, locale);
            MessageFormat messageFormat = this.resolveCode(string, locale);
            if (messageFormat != null) {
                MessageFormat messageFormat2 = messageFormat;
                synchronized (messageFormat2) {
                    return messageFormat.format(objectArray2);
                }
            }
        }
        return this.getMessageFromParent(string, objectArray2, locale);
    }

    protected String getMessageFromParent(String string, Object[] objectArray, Locale locale) {
        MessageSource messageSource = this.getParentMessageSource();
        if (messageSource != null) {
            if (messageSource instanceof AbstractMessageSource) {
                return ((AbstractMessageSource)messageSource).getMessageInternal(string, objectArray, locale);
            }
            return messageSource.getMessage(string, objectArray, null, locale);
        }
        return null;
    }

    protected String getDefaultMessage(String string) {
        if (this.isUseCodeAsDefaultMessage()) {
            return string;
        }
        return null;
    }

    protected String renderDefaultMessage(String string, Object[] objectArray, Locale locale) {
        return this.formatMessage(string, objectArray, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatMessage(String string, Object[] objectArray, Locale locale) {
        if (string == null || !this.alwaysUseMessageFormat && (objectArray == null || objectArray.length == 0)) {
            return string;
        }
        MessageFormat messageFormat = null;
        Object object = this.cachedMessageFormats;
        synchronized (object) {
            messageFormat = (MessageFormat)this.cachedMessageFormats.get(string);
            if (messageFormat == null) {
                messageFormat = this.createMessageFormat(string, locale);
                this.cachedMessageFormats.put(string, messageFormat);
            }
        }
        object = messageFormat;
        synchronized (object) {
            return messageFormat.format(this.resolveArguments(objectArray, locale));
        }
    }

    protected MessageFormat createMessageFormat(String string, Locale locale) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating MessageFormat for pattern [" + string + "] and locale '" + locale + "'"));
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        if (string != null) {
            messageFormat.applyPattern(string);
        }
        return messageFormat;
    }

    protected Object[] resolveArguments(Object[] objectArray, Locale locale) {
        if (objectArray == null) {
            return new Object[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof MessageSourceResolvable) {
                arrayList.add(this.getMessage((MessageSourceResolvable)objectArray[i], locale));
                continue;
            }
            arrayList.add(objectArray[i]);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String resolveCodeWithoutArguments(String string, Locale locale) {
        MessageFormat messageFormat = this.resolveCode(string, locale);
        if (messageFormat != null) {
            MessageFormat messageFormat2 = messageFormat;
            synchronized (messageFormat2) {
                return messageFormat.format(new Object[0]);
            }
        }
        return null;
    }

    protected abstract MessageFormat resolveCode(String var1, Locale var2);
}

