/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.support.ResourceEditorRegistrar;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.Lifecycle;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.ApplicationContextAwareProcessor;
import org.springframework.context.support.DelegatingMessageSource;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractApplicationContext
extends DefaultResourceLoader
implements ConfigurableApplicationContext,
DisposableBean {
    public static final String MESSAGE_SOURCE_BEAN_NAME = "messageSource";
    public static final String APPLICATION_EVENT_MULTICASTER_BEAN_NAME = "applicationEventMulticaster";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext parent;
    private final List beanFactoryPostProcessors = new ArrayList();
    private String displayName = ObjectUtils.identityToString((Object)this);
    private long startupDate;
    private boolean active = false;
    private final Object activeMonitor = new Object();
    private final Object startupShutdownMonitor = new Object();
    private Thread shutdownHook;
    private ResourcePatternResolver resourcePatternResolver;
    private MessageSource messageSource;
    private ApplicationEventMulticaster applicationEventMulticaster;
    private List applicationListeners = new ArrayList();
    static /* synthetic */ Class class$org$springframework$context$event$ContextClosedEvent;
    static /* synthetic */ Class class$org$springframework$context$ResourceLoaderAware;
    static /* synthetic */ Class class$org$springframework$context$ApplicationEventPublisherAware;
    static /* synthetic */ Class class$org$springframework$context$MessageSourceAware;
    static /* synthetic */ Class class$org$springframework$context$ApplicationContextAware;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanFactoryPostProcessor;
    static /* synthetic */ Class class$org$springframework$core$Ordered;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$BeanPostProcessor;
    static /* synthetic */ Class class$org$springframework$context$MessageSource;
    static /* synthetic */ Class class$org$springframework$context$event$ApplicationEventMulticaster;
    static /* synthetic */ Class class$org$springframework$context$ApplicationListener;
    static /* synthetic */ Class class$org$springframework$context$Lifecycle;

    public AbstractApplicationContext() {
        this(null);
    }

    public AbstractApplicationContext(ApplicationContext applicationContext) {
        this.parent = applicationContext;
        this.resourcePatternResolver = this.getResourcePatternResolver();
    }

    public ApplicationContext getParent() {
        return this.parent;
    }

    public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
        return this.getBeanFactory();
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getStartupDate() {
        return this.startupDate;
    }

    public void publishEvent(ApplicationEvent applicationEvent) {
        Assert.notNull((Object)applicationEvent, (String)"Event must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing event in context [" + ObjectUtils.identityToString((Object)this) + "]: " + applicationEvent));
        }
        this.getApplicationEventMulticaster().multicastEvent(applicationEvent);
        if (this.parent != null) {
            this.parent.publishEvent(applicationEvent);
        }
    }

    private ApplicationEventMulticaster getApplicationEventMulticaster() throws IllegalStateException {
        if (this.applicationEventMulticaster == null) {
            throw new IllegalStateException("ApplicationEventMulticaster not initialized - call 'refresh' before multicasting events via the context: " + this);
        }
        return this.applicationEventMulticaster;
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new PathMatchingResourcePatternResolver((ResourceLoader)this);
    }

    public void setParent(ApplicationContext applicationContext) {
        this.parent = applicationContext;
    }

    public void addBeanFactoryPostProcessor(BeanFactoryPostProcessor beanFactoryPostProcessor) {
        this.beanFactoryPostProcessors.add(beanFactoryPostProcessor);
    }

    public List getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    public void addApplicationListener(ApplicationListener applicationListener) {
        this.applicationListeners.add(applicationListener);
    }

    public List getApplicationListeners() {
        return this.applicationListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws BeansException, IllegalStateException {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.prepareRefresh();
            ConfigurableListableBeanFactory configurableListableBeanFactory = this.obtainFreshBeanFactory();
            this.prepareBeanFactory(configurableListableBeanFactory);
            try {
                this.postProcessBeanFactory(configurableListableBeanFactory);
                this.invokeBeanFactoryPostProcessors(configurableListableBeanFactory);
                this.registerBeanPostProcessors(configurableListableBeanFactory);
                this.initMessageSource();
                this.initApplicationEventMulticaster();
                this.onRefresh();
                this.registerListeners();
                configurableListableBeanFactory.preInstantiateSingletons();
                this.publishEvent(new ContextRefreshedEvent(this));
            }
            catch (BeansException beansException) {
                configurableListableBeanFactory.destroySingletons();
                throw beansException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareRefresh() {
        this.startupDate = System.currentTimeMillis();
        Object object = this.activeMonitor;
        synchronized (object) {
            this.active = true;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Refreshing " + this));
        }
    }

    protected ConfigurableListableBeanFactory obtainFreshBeanFactory() {
        this.refreshBeanFactory();
        ConfigurableListableBeanFactory configurableListableBeanFactory = this.getBeanFactory();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Bean factory for application context [" + ObjectUtils.identityToString((Object)this) + "]: " + ObjectUtils.identityToString((Object)configurableListableBeanFactory)));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(configurableListableBeanFactory.getBeanDefinitionCount() + " beans defined in " + this));
        }
        return configurableListableBeanFactory;
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        configurableListableBeanFactory.setBeanClassLoader(this.getClassLoader());
        configurableListableBeanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new ResourceEditorRegistrar((ResourceLoader)this));
        configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)new ApplicationContextAwareProcessor(this));
        configurableListableBeanFactory.ignoreDependencyInterface(class$org$springframework$context$ResourceLoaderAware == null ? (class$org$springframework$context$ResourceLoaderAware = AbstractApplicationContext.class$("org.springframework.context.ResourceLoaderAware")) : class$org$springframework$context$ResourceLoaderAware);
        configurableListableBeanFactory.ignoreDependencyInterface(class$org$springframework$context$ApplicationEventPublisherAware == null ? (class$org$springframework$context$ApplicationEventPublisherAware = AbstractApplicationContext.class$("org.springframework.context.ApplicationEventPublisherAware")) : class$org$springframework$context$ApplicationEventPublisherAware);
        configurableListableBeanFactory.ignoreDependencyInterface(class$org$springframework$context$MessageSourceAware == null ? (class$org$springframework$context$MessageSourceAware = AbstractApplicationContext.class$("org.springframework.context.MessageSourceAware")) : class$org$springframework$context$MessageSourceAware);
        configurableListableBeanFactory.ignoreDependencyInterface(class$org$springframework$context$ApplicationContextAware == null ? (class$org$springframework$context$ApplicationContextAware = AbstractApplicationContext.class$("org.springframework.context.ApplicationContextAware")) : class$org$springframework$context$ApplicationContextAware);
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
    }

    protected void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        Object object;
        Object object2;
        String[] stringArray = this.getBeanFactoryPostProcessors().iterator();
        while (stringArray.hasNext()) {
            object2 = (BeanFactoryPostProcessor)stringArray.next();
            object2.postProcessBeanFactory(configurableListableBeanFactory);
        }
        stringArray = configurableListableBeanFactory.getBeanNamesForType(class$org$springframework$beans$factory$config$BeanFactoryPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanFactoryPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanFactoryPostProcessor")) : class$org$springframework$beans$factory$config$BeanFactoryPostProcessor, true, false);
        object2 = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isTypeMatch(stringArray[i], class$org$springframework$core$Ordered == null ? AbstractApplicationContext.class$("org.springframework.core.Ordered") : class$org$springframework$core$Ordered)) {
                object2.add(configurableListableBeanFactory.getBean(stringArray[i]));
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        Collections.sort(object2, new OrderComparator());
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (BeanFactoryPostProcessor)iterator.next();
            object.postProcessBeanFactory(configurableListableBeanFactory);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            ((BeanFactoryPostProcessor)this.getBean((String)object)).postProcessBeanFactory(configurableListableBeanFactory);
        }
    }

    protected void registerBeanPostProcessors(ConfigurableListableBeanFactory configurableListableBeanFactory) {
        String[] stringArray = configurableListableBeanFactory.getBeanNamesForType(class$org$springframework$beans$factory$config$BeanPostProcessor == null ? (class$org$springframework$beans$factory$config$BeanPostProcessor = AbstractApplicationContext.class$("org.springframework.beans.factory.config.BeanPostProcessor")) : class$org$springframework$beans$factory$config$BeanPostProcessor, true, false);
        int n = configurableListableBeanFactory.getBeanPostProcessorCount() + 1 + stringArray.length;
        configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)new BeanPostProcessorChecker(configurableListableBeanFactory, n));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isTypeMatch(stringArray[i], class$org$springframework$core$Ordered == null ? AbstractApplicationContext.class$("org.springframework.core.Ordered") : class$org$springframework$core$Ordered)) {
                arrayList.add(this.getBean(stringArray[i]));
                continue;
            }
            arrayList2.add(stringArray[i]);
        }
        Collections.sort(arrayList, new OrderComparator());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)iterator.next());
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            configurableListableBeanFactory.addBeanPostProcessor((BeanPostProcessor)this.getBean(string));
        }
    }

    protected void initMessageSource() {
        if (this.containsLocalBean(MESSAGE_SOURCE_BEAN_NAME)) {
            HierarchicalMessageSource hierarchicalMessageSource;
            this.messageSource = (MessageSource)this.getBean(MESSAGE_SOURCE_BEAN_NAME, class$org$springframework$context$MessageSource == null ? (class$org$springframework$context$MessageSource = AbstractApplicationContext.class$("org.springframework.context.MessageSource")) : class$org$springframework$context$MessageSource);
            if (this.parent != null && this.messageSource instanceof HierarchicalMessageSource && (hierarchicalMessageSource = (HierarchicalMessageSource)this.messageSource).getParentMessageSource() == null) {
                hierarchicalMessageSource.setParentMessageSource(this.getInternalParentMessageSource());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using MessageSource [" + this.messageSource + "]"));
            }
        } else {
            DelegatingMessageSource delegatingMessageSource = new DelegatingMessageSource();
            delegatingMessageSource.setParentMessageSource(this.getInternalParentMessageSource());
            this.messageSource = delegatingMessageSource;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to locate MessageSource with name 'messageSource': using default [" + this.messageSource + "]"));
            }
        }
    }

    protected void initApplicationEventMulticaster() {
        if (this.containsLocalBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME)) {
            this.applicationEventMulticaster = (ApplicationEventMulticaster)this.getBean(APPLICATION_EVENT_MULTICASTER_BEAN_NAME, class$org$springframework$context$event$ApplicationEventMulticaster == null ? (class$org$springframework$context$event$ApplicationEventMulticaster = AbstractApplicationContext.class$("org.springframework.context.event.ApplicationEventMulticaster")) : class$org$springframework$context$event$ApplicationEventMulticaster);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using ApplicationEventMulticaster [" + this.applicationEventMulticaster + "]"));
            }
        } else {
            this.applicationEventMulticaster = new SimpleApplicationEventMulticaster();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Unable to locate ApplicationEventMulticaster with name 'applicationEventMulticaster': using default [" + this.applicationEventMulticaster + "]"));
            }
        }
    }

    protected void onRefresh() throws BeansException {
    }

    protected void registerListeners() {
        Object object = this.getApplicationListeners().iterator();
        while (object.hasNext()) {
            this.addListener((ApplicationListener)object.next());
        }
        object = this.getBeansOfType(class$org$springframework$context$ApplicationListener == null ? (class$org$springframework$context$ApplicationListener = AbstractApplicationContext.class$("org.springframework.context.ApplicationListener")) : class$org$springframework$context$ApplicationListener, true, false).values();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            this.addListener((ApplicationListener)iterator.next());
        }
    }

    protected void addListener(ApplicationListener applicationListener) {
        this.getApplicationEventMulticaster().addApplicationListener(applicationListener);
    }

    public void registerShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                public void run() {
                    AbstractApplicationContext.this.doClose();
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    public void destroy() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.startupShutdownMonitor;
        synchronized (object) {
            this.doClose();
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        if (this.isActive()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Closing " + this));
            }
            try {
                this.publishEvent(new ContextClosedEvent(this));
            }
            catch (Throwable throwable) {
                this.logger.error((Object)"Exception thrown from ApplicationListener handling ContextClosedEvent", throwable);
            }
            this.stop();
            this.destroyBeans();
            this.closeBeanFactory();
            this.onClose();
            Object object = this.activeMonitor;
            synchronized (object) {
                this.active = false;
            }
        }
    }

    protected void destroyBeans() {
        this.getBeanFactory().destroySingletons();
    }

    protected void onClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.activeMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    public Object getBean(String string) throws BeansException {
        return this.getBeanFactory().getBean(string);
    }

    public Object getBean(String string, Class clazz) throws BeansException {
        return this.getBeanFactory().getBean(string, clazz);
    }

    public boolean containsBean(String string) {
        return this.getBeanFactory().containsBean(string);
    }

    public boolean isSingleton(String string) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isSingleton(string);
    }

    public boolean isPrototype(String string) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isPrototype(string);
    }

    public boolean isTypeMatch(String string, Class clazz) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().isTypeMatch(string, clazz);
    }

    public Class getType(String string) throws NoSuchBeanDefinitionException {
        return this.getBeanFactory().getType(string);
    }

    public String[] getAliases(String string) {
        return this.getBeanFactory().getAliases(string);
    }

    public boolean containsBeanDefinition(String string) {
        return this.getBeanFactory().containsBeanDefinition(string);
    }

    public int getBeanDefinitionCount() {
        return this.getBeanFactory().getBeanDefinitionCount();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanFactory().getBeanDefinitionNames();
    }

    public String[] getBeanNamesForType(Class clazz) {
        return this.getBeanFactory().getBeanNamesForType(clazz);
    }

    public String[] getBeanNamesForType(Class clazz, boolean bl, boolean bl2) {
        return this.getBeanFactory().getBeanNamesForType(clazz, bl, bl2);
    }

    public Map getBeansOfType(Class clazz) throws BeansException {
        return this.getBeanFactory().getBeansOfType(clazz);
    }

    public Map getBeansOfType(Class clazz, boolean bl, boolean bl2) throws BeansException {
        return this.getBeanFactory().getBeansOfType(clazz, bl, bl2);
    }

    public BeanFactory getParentBeanFactory() {
        return this.getParent();
    }

    public boolean containsLocalBean(String string) {
        return this.getBeanFactory().containsLocalBean(string);
    }

    protected BeanFactory getInternalParentBeanFactory() {
        return this.getParent() instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)this.getParent()).getBeanFactory() : this.getParent();
    }

    public String getMessage(String string, Object[] objectArray, String string2, Locale locale) {
        return this.getMessageSource().getMessage(string, objectArray, string2, locale);
    }

    public String getMessage(String string, Object[] objectArray, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(string, objectArray, locale);
    }

    public String getMessage(MessageSourceResolvable messageSourceResolvable, Locale locale) throws NoSuchMessageException {
        return this.getMessageSource().getMessage(messageSourceResolvable, locale);
    }

    private MessageSource getMessageSource() throws IllegalStateException {
        if (this.messageSource == null) {
            throw new IllegalStateException("MessageSource not initialized - call 'refresh' before accessing messages via the context: " + this);
        }
        return this.messageSource;
    }

    protected MessageSource getInternalParentMessageSource() {
        return this.getParent() instanceof AbstractApplicationContext ? ((AbstractApplicationContext)this.getParent()).messageSource : this.getParent();
    }

    public Resource[] getResources(String string) throws IOException {
        return this.resourcePatternResolver.getResources(string);
    }

    public void start() {
        Iterator iterator = this.getLifecycleBeans().iterator();
        while (iterator.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)iterator.next();
            if (lifecycle.isRunning()) continue;
            lifecycle.start();
        }
    }

    public void stop() {
        Iterator iterator = this.getLifecycleBeans().iterator();
        while (iterator.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)iterator.next();
            if (!lifecycle.isRunning()) continue;
            lifecycle.stop();
        }
    }

    public boolean isRunning() {
        Iterator iterator = this.getLifecycleBeans().iterator();
        while (iterator.hasNext()) {
            Lifecycle lifecycle = (Lifecycle)iterator.next();
            if (lifecycle.isRunning()) continue;
            return false;
        }
        return true;
    }

    protected Collection getLifecycleBeans() {
        ConfigurableListableBeanFactory configurableListableBeanFactory = this.getBeanFactory();
        String[] stringArray = configurableListableBeanFactory.getBeanNamesForType(class$org$springframework$context$Lifecycle == null ? (class$org$springframework$context$Lifecycle = AbstractApplicationContext.class$("org.springframework.context.Lifecycle")) : class$org$springframework$context$Lifecycle, false, false);
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = configurableListableBeanFactory.getSingleton(stringArray[i]);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    protected abstract void refreshBeanFactory() throws BeansException, IllegalStateException;

    protected abstract void closeBeanFactory();

    public abstract ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(ObjectUtils.identityToString((Object)this));
        stringBuffer.append(": display name [").append(this.getDisplayName());
        stringBuffer.append("]; startup date [").append(new Date(this.getStartupDate()));
        stringBuffer.append("]; ");
        ApplicationContext applicationContext = this.getParent();
        if (applicationContext == null) {
            stringBuffer.append("root of context hierarchy");
        } else {
            stringBuffer.append("parent: ").append(ObjectUtils.identityToString((Object)applicationContext));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        (class$org$springframework$context$event$ContextClosedEvent == null ? (class$org$springframework$context$event$ContextClosedEvent = AbstractApplicationContext.class$("org.springframework.context.event.ContextClosedEvent")) : class$org$springframework$context$event$ContextClosedEvent).getName();
    }

    private class BeanPostProcessorChecker
    implements BeanPostProcessor {
        private final ConfigurableListableBeanFactory beanFactory;
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(ConfigurableListableBeanFactory configurableListableBeanFactory, int n) {
            this.beanFactory = configurableListableBeanFactory;
            this.beanPostProcessorTargetCount = n;
        }

        public Object postProcessBeforeInitialization(Object object, String string) {
            return object;
        }

        public Object postProcessAfterInitialization(Object object, String string) {
            if (this.beanFactory.getBeanPostProcessorCount() < this.beanPostProcessorTargetCount && AbstractApplicationContext.this.logger.isInfoEnabled()) {
                AbstractApplicationContext.this.logger.info((Object)("Bean '" + string + "' is not eligible for getting processed by all " + "BeanPostProcessors (for example: not eligible for auto-proxying)"));
            }
            return object;
        }
    }
}

