/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class SourceFilteringListener
implements ApplicationListener {
    private final Object source;
    private ApplicationListener delegate;

    public SourceFilteringListener(Object object, ApplicationListener applicationListener) {
        this.source = object;
        this.delegate = applicationListener;
    }

    protected SourceFilteringListener(Object object) {
        this.source = object;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent.getSource() == this.source) {
            this.onApplicationEventInternal(applicationEvent);
        }
    }

    protected void onApplicationEventInternal(ApplicationEvent applicationEvent) {
        if (this.delegate == null) {
            throw new IllegalStateException("Must specify a delegate object or override the onApplicationEventInternal method");
        }
        this.delegate.onApplicationEvent(applicationEvent);
    }
}

