/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.access;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.SingletonBeanFactoryLocator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.support.ResourcePatternUtils;

public class ContextSingletonBeanFactoryLocator
extends SingletonBeanFactoryLocator {
    private static final String DEFAULT_RESOURCE_LOCATION = "classpath*:beanRefContext.xml";
    private static final Map instances = new HashMap();

    public static BeanFactoryLocator getInstance() throws BeansException {
        return ContextSingletonBeanFactoryLocator.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String string) throws BeansException {
        String string2 = string;
        if (string2 == null) {
            string2 = DEFAULT_RESOURCE_LOCATION;
        }
        if (!ResourcePatternUtils.isUrl((String)string2)) {
            string2 = "classpath*:" + string2;
        }
        Map map = instances;
        synchronized (map) {
            Object object;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ContextSingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + ((Object)instances).hashCode() + ", instances=" + instances));
            }
            if ((object = (BeanFactoryLocator)instances.get(string2)) == null) {
                object = new ContextSingletonBeanFactoryLocator(string2);
                instances.put(string2, object);
            }
            return object;
        }
    }

    protected ContextSingletonBeanFactoryLocator(String string) {
        super(string);
    }

    protected BeanFactory createDefinition(String string, String string2) {
        return new ClassPathXmlApplicationContext(new String[]{string}, false);
    }

    protected void initializeDefinition(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)beanFactory).refresh();
        }
    }

    protected void destroyDefinition(BeanFactory beanFactory, String string) {
        if (beanFactory instanceof ConfigurableApplicationContext) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Context group with selector '" + string + "' being released, as there are no more references to it"));
            }
            ((ConfigurableApplicationContext)beanFactory).close();
        }
    }
}

