/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.access;

import javax.naming.NamingException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextBeanFactoryReference;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.util.StringUtils;

public class ContextJndiBeanFactoryLocator
extends JndiLocatorSupport
implements BeanFactoryLocator {
    public static final String BEAN_FACTORY_PATH_DELIMITERS = ",; \t\n";
    static /* synthetic */ Class class$java$lang$String;

    public BeanFactoryReference useBeanFactory(String string) throws BeansException {
        try {
            String string2 = (String)this.lookup(string, class$java$lang$String == null ? (class$java$lang$String = ContextJndiBeanFactoryLocator.class$("java.lang.String")) : class$java$lang$String);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Bean factory path from JNDI environment variable [" + string + "] is: " + string2));
            }
            String[] stringArray = StringUtils.tokenizeToStringArray((String)string2, (String)BEAN_FACTORY_PATH_DELIMITERS);
            return this.createBeanFactory(stringArray);
        }
        catch (NamingException namingException) {
            throw new BootstrapException("Define an environment variable [" + string + "] containing " + "the class path locations of XML bean definition files", (Throwable)namingException);
        }
    }

    protected BeanFactoryReference createBeanFactory(String[] stringArray) throws BeansException {
        ApplicationContext applicationContext = this.createApplicationContext(stringArray);
        return new ContextBeanFactoryReference(applicationContext);
    }

    protected ApplicationContext createApplicationContext(String[] stringArray) throws BeansException {
        return new ClassPathXmlApplicationContext(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

