/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.access;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ContextBeanFactoryReference
implements BeanFactoryReference {
    private ApplicationContext applicationContext;

    public ContextBeanFactoryReference(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public BeanFactory getFactory() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("ApplicationContext owned by this BeanFactoryReference has been released");
        }
        return this.applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.applicationContext != null) {
            ApplicationContext applicationContext;
            ContextBeanFactoryReference contextBeanFactoryReference = this;
            synchronized (contextBeanFactoryReference) {
                applicationContext = this.applicationContext;
                this.applicationContext = null;
            }
            if (applicationContext != null && applicationContext instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)applicationContext).close();
            }
        }
    }
}

