/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.identity.SingleFieldIdentity;

public class ShortIdentity
extends SingleFieldIdentity {
    private short key;

    private void construct(short s) {
        this.key = s;
        this.hashCode = this.hashClassName() ^ s;
    }

    public ShortIdentity(Class clazz, short s) {
        super(clazz);
        this.construct(s);
    }

    public ShortIdentity(Class clazz, Short s) {
        super(clazz);
        this.setKeyAsObject(s);
        this.construct(s);
    }

    public ShortIdentity(Class clazz, String string) {
        super(clazz);
        this.assertKeyNotNull(string);
        this.construct(Short.parseShort(string));
    }

    public ShortIdentity() {
    }

    public short getKey() {
        return this.key;
    }

    public String toString() {
        return Short.toString(this.key);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ShortIdentity shortIdentity = (ShortIdentity)object;
        return this.key == shortIdentity.key;
    }

    protected Object createKeyAsObject() {
        return new Short(this.key);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeShort(this.key);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.key = objectInput.readShort();
    }
}

