/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.identity.SingleFieldIdentity;

public class IntIdentity
extends SingleFieldIdentity {
    private int key;

    private void construct(int n) {
        this.key = n;
        this.hashCode = this.hashClassName() ^ n;
    }

    public IntIdentity(Class clazz, int n) {
        super(clazz);
        this.construct(n);
    }

    public IntIdentity(Class clazz, Integer n) {
        super(clazz);
        this.setKeyAsObject(n);
        this.construct(n);
    }

    public IntIdentity(Class clazz, String string) {
        super(clazz);
        this.assertKeyNotNull(string);
        this.construct(Integer.parseInt(string));
    }

    public IntIdentity() {
    }

    public int getKey() {
        return this.key;
    }

    public String toString() {
        return Integer.toString(this.key);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        IntIdentity intIdentity = (IntIdentity)object;
        return this.key == intIdentity.key;
    }

    protected Object createKeyAsObject() {
        return new Integer(this.key);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.key);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.key = objectInput.readInt();
    }
}

