/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.I18NHelper;

public class CharIdentity
extends SingleFieldIdentity {
    private static I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private char key;

    private void construct(char c) {
        this.key = c;
        this.hashCode = this.hashClassName() ^ c;
    }

    public CharIdentity(Class clazz, char c) {
        super(clazz);
        this.construct(c);
    }

    public CharIdentity(Class clazz, Character c) {
        super(clazz);
        this.setKeyAsObject(c);
        this.construct(c.charValue());
    }

    public CharIdentity(Class clazz, String string) {
        super(clazz);
        this.assertKeyNotNull(string);
        if (string.length() != 1) {
            throw new IllegalArgumentException(msg.msg("EXC_StringWrongLength"));
        }
        this.construct(string.charAt(0));
    }

    public CharIdentity() {
    }

    public char getKey() {
        return this.key;
    }

    public String toString() {
        return String.valueOf(this.key);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CharIdentity charIdentity = (CharIdentity)object;
        return this.key == charIdentity.key;
    }

    protected Object createKeyAsObject() {
        return new Character(this.key);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeChar(this.key);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.key = objectInput.readChar();
    }

    private void computeHashCode() {
        this.hashCode = this.hashClassName() ^ this.key;
    }
}

