/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.spi.I18NHelper;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateInterrogation;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class JDOHelper {
    private static final I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private static JDOImplHelper implHelper = (JDOImplHelper)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JDOImplHelper.getInstance();
        }
    });
    static JDOImplHelper.StateInterrogationObjectReturn getPersistenceManager = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.getPersistenceManager(object);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getObjectId = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.getObjectId(object);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getTransactionalObjectId = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.getTransactionalObjectId(object);
        }
    };
    static JDOImplHelper.StateInterrogationObjectReturn getVersion = new JDOImplHelper.StateInterrogationObjectReturn(){

        public Object get(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.getVersion(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isPersistent = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isPersistent(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isTransactional = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isTransactional(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDirty = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isDirty(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isNew = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isNew(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDeleted = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isDeleted(object);
        }
    };
    static JDOImplHelper.StateInterrogationBooleanReturn isDetached = new JDOImplHelper.StateInterrogationBooleanReturn(){

        public Boolean is(Object object, StateInterrogation stateInterrogation) {
            return stateInterrogation.isDetached(object);
        }
    };
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$javax$jdo$PersistenceManagerFactory;

    public static PersistenceManager getPersistenceManager(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetPersistenceManager();
        }
        return (PersistenceManager)implHelper.nonBinaryCompatibleGet(object, getPersistenceManager);
    }

    public static void makeDirty(Object object, String string) {
        if (object instanceof PersistenceCapable) {
            ((PersistenceCapable)object).jdoMakeDirty(string);
        } else {
            implHelper.nonBinaryCompatibleMakeDirty(object, string);
        }
    }

    public static Object getObjectId(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetObjectId();
        }
        return implHelper.nonBinaryCompatibleGet(object, getObjectId);
    }

    public static Collection getObjectIds(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(JDOHelper.getObjectId(iterator.next()));
        }
        return arrayList;
    }

    public static Object[] getObjectIds(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = JDOHelper.getObjectId(objectArray[i]);
        }
        return objectArray2;
    }

    public static Object getTransactionalObjectId(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetTransactionalObjectId();
        }
        return implHelper.nonBinaryCompatibleGet(object, getTransactionalObjectId);
    }

    public static Object getVersion(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoGetVersion();
        }
        return implHelper.nonBinaryCompatibleGet(object, getVersion);
    }

    public static boolean isDirty(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsDirty();
        }
        return implHelper.nonBinaryCompatibleIs(object, isDirty);
    }

    public static boolean isTransactional(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsTransactional();
        }
        return implHelper.nonBinaryCompatibleIs(object, isTransactional);
    }

    public static boolean isPersistent(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsPersistent();
        }
        return implHelper.nonBinaryCompatibleIs(object, isPersistent);
    }

    public static boolean isNew(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsNew();
        }
        return implHelper.nonBinaryCompatibleIs(object, isNew);
    }

    public static boolean isDeleted(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsDeleted();
        }
        return implHelper.nonBinaryCompatibleIs(object, isDeleted);
    }

    public static boolean isDetached(Object object) {
        if (object instanceof PersistenceCapable) {
            return ((PersistenceCapable)object).jdoIsDetached();
        }
        return implHelper.nonBinaryCompatibleIs(object, isDetached);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map map) {
        ClassLoader classLoader = JDOHelper.getContextClassLoader();
        return JDOHelper.getPersistenceManagerFactory(map, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(Map map, ClassLoader classLoader) {
        String string = (String)map.get("javax.jdo.PersistenceManagerFactoryClass");
        if (string == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoClassNameProperty"));
        }
        try {
            Class<?> clazz = classLoader.loadClass(string);
            Method method = clazz.getMethod("getPersistenceManagerFactory", class$java$util$Map == null ? (class$java$util$Map = JDOHelper.class$("java.util.Map")) : class$java$util$Map);
            return (PersistenceManagerFactory)method.invoke(null, map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFClassNotFound", string), classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIllegalAccess", string), illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNoSuchMethod"), noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof JDOException) {
                throw (JDOException)throwable;
            }
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), invocationTargetException);
        }
        catch (NullPointerException nullPointerException) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFNullPointerException", string), nullPointerException);
        }
        catch (ClassCastException classCastException) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFClassCastException", string), classCastException);
        }
        catch (Exception exception) {
            throw new JDOFatalInternalException(msg.msg("EXC_GetPMFUnexpectedException"), exception);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string) {
        return JDOHelper.getPersistenceManagerFactory(string, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string, ClassLoader classLoader) {
        return JDOHelper.getPersistenceManagerFactory(string, classLoader, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string, ClassLoader classLoader, ClassLoader classLoader2) {
        if (string == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullResource"));
        }
        if (classLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPropsLoader"));
        }
        if (classLoader2 == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullPMFLoader"));
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoResource", string, classLoader));
            }
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionRsrc", string), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return JDOHelper.getPersistenceManagerFactory(properties, classLoader2);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(File file) {
        return JDOHelper.getPersistenceManagerFactory(file, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(File file, ClassLoader classLoader) {
        if (file == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullFile"));
        }
        if (classLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNoFile", file, classLoader), fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionFile", file), iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return JDOHelper.getPersistenceManagerFactory(properties, classLoader);
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string, Context context) {
        return JDOHelper.getPersistenceManagerFactory(string, context, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(String string, Context context, ClassLoader classLoader) {
        if (string == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullJndiLoc"));
        }
        if (classLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        try {
            if (context == null) {
                context = new InitialContext();
            }
            Object object = context.lookup(string);
            return (PersistenceManagerFactory)PortableRemoteObject.narrow((Object)object, (Class)(class$javax$jdo$PersistenceManagerFactory == null ? (class$javax$jdo$PersistenceManagerFactory = JDOHelper.class$("javax.jdo.PersistenceManagerFactory")) : class$javax$jdo$PersistenceManagerFactory));
        }
        catch (NamingException namingException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNamingException", string, classLoader), namingException);
        }
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream inputStream) {
        return JDOHelper.getPersistenceManagerFactory(inputStream, JDOHelper.getContextClassLoader());
    }

    public static PersistenceManagerFactory getPersistenceManagerFactory(InputStream inputStream, ClassLoader classLoader) {
        if (inputStream == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullStream"));
        }
        if (classLoader == null) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFNullLoader"));
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new JDOFatalUserException(msg.msg("EXC_GetPMFIOExceptionStream"), iOException);
        }
        return JDOHelper.getPersistenceManagerFactory(properties, classLoader);
    }

    private static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

