/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.JDOHelper;
import javax.jdo.spi.I18NHelper;

public class JDOException
extends RuntimeException {
    Throwable[] nested;
    Object failed;
    private static I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    private boolean inPrintStackTrace = false;

    public JDOException() {
    }

    public JDOException(String string) {
        super(string);
    }

    public JDOException(String string, Throwable[] throwableArray) {
        super(string);
        this.nested = throwableArray;
    }

    public JDOException(String string, Throwable throwable) {
        super(string);
        this.nested = new Throwable[]{throwable};
    }

    public JDOException(String string, Object object) {
        super(string);
        this.failed = object;
    }

    public JDOException(String string, Throwable[] throwableArray, Object object) {
        super(string);
        this.nested = throwableArray;
        this.failed = object;
    }

    public JDOException(String string, Throwable throwable, Object object) {
        super(string);
        this.nested = new Throwable[]{throwable};
        this.failed = object;
    }

    public Object getFailedObject() {
        return this.failed;
    }

    public Throwable[] getNestedExceptions() {
        return this.nested;
    }

    public synchronized Throwable getCause() {
        if (this.nested == null || this.nested.length == 0 || this.inPrintStackTrace) {
            return null;
        }
        return this.nested[0];
    }

    public Throwable initCause(Throwable throwable) {
        throw new JDOFatalInternalException(msg.msg("ERR_CannotInitCause"));
    }

    public synchronized String toString() {
        Object object;
        int n = this.nested == null ? 0 : this.nested.length;
        StringBuffer stringBuffer = new StringBuffer(10 + 100 * n);
        stringBuffer.append(super.toString());
        if (this.failed != null) {
            stringBuffer.append("\n").append(msg.msg("MSG_FailedObject"));
            object = null;
            try {
                object = this.failed.toString();
            }
            catch (Exception exception) {
                Object object2 = JDOHelper.getObjectId(this.failed);
                if (object2 == null) {
                    object = msg.msg("MSG_ExceptionGettingFailedToString", JDOException.exceptionToString(exception));
                }
                String string = null;
                try {
                    string = object2.toString();
                }
                catch (Exception exception2) {
                    string = JDOException.exceptionToString(exception2);
                }
                object = msg.msg("MSG_ExceptionGettingFailedToStringObjectId", JDOException.exceptionToString(exception), string);
            }
            stringBuffer.append((String)object);
        }
        if (n > 0 && !this.inPrintStackTrace) {
            stringBuffer.append("\n").append(msg.msg("MSG_NestedThrowables")).append("\n");
            object = this.nested[0];
            stringBuffer.append(object == null ? "null" : ((Throwable)object).toString());
            for (int i = 1; i < n; ++i) {
                stringBuffer.append("\n");
                object = this.nested[i];
                stringBuffer.append(object == null ? "null" : ((Throwable)object).toString());
            }
        }
        return stringBuffer.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printStackTrace(PrintStream printStream) {
        int n = this.nested == null ? 0 : this.nested.length;
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            this.inPrintStackTrace = true;
            super.printStackTrace(printStream);
            if (n > 0) {
                printStream.println(msg.msg("MSG_NestedThrowablesStackTrace"));
                for (int i = 0; i < n; ++i) {
                    Throwable throwable = this.nested[i];
                    if (throwable == null) continue;
                    throwable.printStackTrace(printStream);
                }
            }
            this.inPrintStackTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void printStackTrace(PrintWriter printWriter) {
        int n = this.nested == null ? 0 : this.nested.length;
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            this.inPrintStackTrace = true;
            super.printStackTrace(printWriter);
            if (n > 0) {
                printWriter.println(msg.msg("MSG_NestedThrowablesStackTrace"));
                for (int i = 0; i < n; ++i) {
                    Throwable throwable = this.nested[i];
                    if (throwable == null) continue;
                    throwable.printStackTrace(printWriter);
                }
            }
            this.inPrintStackTrace = false;
        }
    }

    private static String exceptionToString(Exception exception) {
        if (exception == null) {
            return null;
        }
        String string = exception.getClass().getName();
        String string2 = exception.getMessage();
        return string2 != null ? string + ": " + string2 : string;
    }
}

