/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.holders.SynchronizedIntHolder;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolEventSupport;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolListener;
import com.mchange.v2.resourcepool.ResourcePoolUtils;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.util.ResourceClosedException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class BasicResourcePool
implements ResourcePool {
    private static final MLogger logger = MLog.getLogger(class$com$mchange$v2$resourcepool$BasicResourcePool == null ? (class$com$mchange$v2$resourcepool$BasicResourcePool = BasicResourcePool.class$("com.mchange.v2.resourcepool.BasicResourcePool")) : class$com$mchange$v2$resourcepool$BasicResourcePool);
    static final int CULL_FREQUENCY_DIVISOR = 8;
    static final int MAX_CULL_FREQUENCY = 900000;
    ResourcePool.Manager mgr;
    BasicResourcePoolFactory factory;
    AsynchronousRunner taskRunner;
    RunnableQueue asyncEventQueue;
    Timer cullAndIdleRefurbishTimer;
    TimerTask cullTask;
    TimerTask idleRefurbishTask;
    HashSet acquireWaiters = new HashSet();
    HashSet otherWaiters = new HashSet();
    HashMap managed = new HashMap();
    LinkedList unused = new LinkedList();
    HashSet excluded = new HashSet();
    Set idleCheckResources = new HashSet();
    ResourcePoolEventSupport rpes = new ResourcePoolEventSupport(this);
    boolean force_kill_acquires = false;
    boolean broken = false;
    Object exampleResource;
    int start;
    int min;
    int max;
    int inc;
    int num_acq_attempts;
    int acq_attempt_delay;
    long check_idle_resources_delay;
    long max_resource_age;
    boolean age_is_absolute;
    boolean break_on_acquisition_failure;
    SynchronizedIntHolder pendingAcquiresCounter = new SynchronizedIntHolder();
    static /* synthetic */ Class class$com$mchange$v2$resourcepool$BasicResourcePool;

    public BasicResourcePool(ResourcePool.Manager manager, int n, int n2, int n3, int n4, int n5, int n6, long l, long l2, boolean bl, boolean bl2, AsynchronousRunner asynchronousRunner, RunnableQueue runnableQueue, Timer timer, BasicResourcePoolFactory basicResourcePoolFactory) throws ResourcePoolException {
        try {
            this.mgr = manager;
            this.start = n;
            this.min = n2;
            this.max = n3;
            this.inc = n4;
            this.num_acq_attempts = n5;
            this.acq_attempt_delay = n6;
            this.check_idle_resources_delay = l;
            this.max_resource_age = l2;
            this.age_is_absolute = bl;
            this.factory = basicResourcePoolFactory;
            this.taskRunner = asynchronousRunner;
            this.asyncEventQueue = runnableQueue;
            this.cullAndIdleRefurbishTimer = timer;
            this.pendingAcquiresCounter.setValue(0);
            this.ensureStartResources();
            if (l2 > 0L) {
                long l3 = Math.min(l2 / 8L, 900000L);
                this.cullTask = new CullTask();
                timer.schedule(this.cullTask, l2, l3);
            } else {
                bl = false;
            }
            if (l > 0L) {
                this.idleRefurbishTask = new CheckIdleResourcesTask();
                timer.schedule(this.idleRefurbishTask, l, l);
            }
        }
        catch (Exception exception) {
            throw ResourcePoolUtils.convertThrowable(exception);
        }
    }

    public Object checkoutResource() throws ResourcePoolException, InterruptedException {
        try {
            return this.checkoutResource(0L);
        }
        catch (TimeoutException timeoutException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Huh??? TimeoutException with no timeout set!!!", timeoutException);
            }
            throw new ResourcePoolException("Huh??? TimeoutException with no timeout set!!!", timeoutException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object checkoutResource(long l) throws TimeoutException, ResourcePoolException, InterruptedException {
        try {
            this.ensureNotBroken();
            int n = this.unused.size();
            if (n == 0) {
                int n2 = this.managed.size();
                if (n2 < this.max) {
                    this.postAcquireMore();
                }
                this.awaitAcquire(l);
            }
            Object e = this.unused.get(0);
            this.unused.remove(0);
            if (this.idleCheckResources.contains(e)) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Resource we want to check out is in idleCheck! (waiting until idle-check completes.) [" + this + "]");
                }
                this.unused.add(e);
                Thread thread = Thread.currentThread();
                try {
                    this.otherWaiters.add(thread);
                    this.wait(l);
                    this.ensureNotBroken();
                }
                finally {
                    this.otherWaiters.remove(thread);
                }
                return this.checkoutResource(l);
            }
            if (this.isExpired(e) || !this.attemptRefurbishResourceOnCheckout(e)) {
                this.removeResource(e);
                this.ensureMinResources();
                return this.checkoutResource(l);
            }
            this.asyncFireResourceCheckedOut(e, this.managed.size(), this.unused.size(), this.excluded.size());
            this.trace();
            return e;
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " -- the pool was found to be closed or broken during an attempt to check out a resource.", resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
        catch (InterruptedException interruptedException) {
            if (this.broken) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, this + " -- an attempt to checkout a resource was interrupted, because the pool is now closed. " + "[Thread: " + Thread.currentThread().getName() + ']', interruptedException);
                } else if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, this + " -- an attempt to checkout a resource was interrupted, because the pool is now closed. " + "[Thread: " + Thread.currentThread().getName() + ']');
                }
            } else if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, this + " -- an attempt to checkout a resource was interrupted, and the pool is still live: some other thread " + "must have either interrupted the Thread attempting checkout!", interruptedException);
            }
            throw interruptedException;
        }
    }

    public synchronized void checkinResource(Object object) throws ResourcePoolException {
        try {
            if (this.managed.keySet().contains(object)) {
                this.doCheckinManaged(object);
            } else if (this.excluded.contains(object)) {
                this.doCheckinExcluded(object);
            } else {
                throw new ResourcePoolException("ResourcePool" + (this.broken ? " [BROKEN!]" : "") + ": Tried to check-in a foreign resource!");
            }
            this.trace();
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " - checkinResource( ... ) -- even broken pools should allow checkins without exception. probable resource pool bug.", resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
    }

    public synchronized void checkinAll() throws ResourcePoolException {
        try {
            HashSet hashSet = new HashSet(this.managed.keySet());
            hashSet.removeAll(this.unused);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.doCheckinManaged(iterator.next());
            }
            iterator = this.excluded.iterator();
            while (iterator.hasNext()) {
                this.doCheckinExcluded(iterator.next());
            }
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " - checkinAll() -- even broken pools should allow checkins without exception. probable resource pool bug.", resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
    }

    public synchronized int statusInPool(Object object) throws ResourcePoolException {
        try {
            if (this.unused.contains(object)) {
                return 0;
            }
            if (this.managed.keySet().contains(object) || this.excluded.contains(object)) {
                return 1;
            }
            return -1;
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
    }

    public synchronized void markBroken(Object object) {
        try {
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Resource " + object + " marked broken by pool (" + this + ").");
            }
            this._markBroken(object);
            this.ensureMinResources();
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", resourceClosedException);
            }
            this.unexpectedBreak();
        }
    }

    public int getMinPoolSize() {
        return this.min;
    }

    public int getMaxPoolSize() {
        return this.max;
    }

    public synchronized int getPoolSize() throws ResourcePoolException {
        return this.managed.size();
    }

    public void setPoolSize(int n) throws ResourcePoolException {
        try {
            Exception exception = this.doSetPoolSize(n);
            if (exception != null) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw ResourcePoolUtils.convertThrowable(exception);
            }
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", resourceClosedException);
            }
            this.unexpectedBreak();
        }
    }

    public synchronized int getAvailableCount() {
        return this.unused.size();
    }

    public synchronized int getExcludedCount() {
        return this.excluded.size();
    }

    public synchronized int getAwaitingCheckinCount() {
        return this.managed.size() - this.unused.size() + this.excluded.size();
    }

    public synchronized void resetPool() {
        try {
            Iterator iterator = this.cloneOfManaged().keySet().iterator();
            while (iterator.hasNext()) {
                this.markBrokenNoEnsureMinResources(iterator.next());
            }
            this.ensureMinResources();
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", resourceClosedException);
            }
            this.unexpectedBreak();
        }
    }

    public synchronized void close() throws ResourcePoolException {
        this.close(true);
    }

    public void finalize() throws Throwable {
        if (!this.broken) {
            this.close();
        }
    }

    public void addResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        if (this.asyncEventQueue == null) {
            throw new RuntimeException(this + " does not support ResourcePoolEvents. " + "Probably it was constructed by a BasicResourceFactory configured not to support such events.");
        }
        this.rpes.addResourcePoolListener(resourcePoolListener);
    }

    public void removeResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        if (this.asyncEventQueue == null) {
            throw new RuntimeException(this + " does not support ResourcePoolEvents. " + "Probably it was constructed by a BasicResourceFactory configured not to support such events.");
        }
        this.rpes.removeResourcePoolListener(resourcePoolListener);
    }

    private synchronized boolean isForceKillAcquiresPending() {
        return this.force_kill_acquires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void forceKillAcquires() throws InterruptedException {
        Thread thread = Thread.currentThread();
        try {
            this.force_kill_acquires = true;
            this.notifyAll();
            while (this.acquireWaiters.size() > 0) {
                this.otherWaiters.add(thread);
                this.wait();
            }
            this.force_kill_acquires = false;
        }
        finally {
            this.otherWaiters.remove(thread);
        }
    }

    private synchronized void unexpectedBreak() {
        if (logger.isLoggable(MLevel.SEVERE)) {
            logger.log(MLevel.SEVERE, this + " -- Unexpectedly broken!!!", new ResourcePoolException("Unexpected Break Stack Trace!"));
        }
        this.close(false);
    }

    private void postAcquireUntil(int n) {
        this.taskRunner.postRunnable(new AcquireTask(n));
    }

    private void postRemoveTowards(int n) {
        this.taskRunner.postRunnable(new RemoveTask(n));
    }

    private boolean canFireEvents() {
        return !this.broken && this.asyncEventQueue != null;
    }

    private void asyncFireResourceAcquired(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    BasicResourcePool.this.rpes.fireResourceAcquired(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceCheckedIn(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    BasicResourcePool.this.rpes.fireResourceCheckedIn(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceCheckedOut(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    BasicResourcePool.this.rpes.fireResourceCheckedOut(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceRemoved(final Object object, final boolean bl, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    BasicResourcePool.this.rpes.fireResourceRemoved(object, bl, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void destroyResource(Object object) {
        this.destroyResource(object, false);
    }

    private void destroyResource(final Object object, boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                block2: {
                    try {
                        BasicResourcePool.this.mgr.destroyResource(object);
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block2;
                        logger.log(MLevel.WARNING, "Failed to destroy resource: " + object, exception);
                    }
                }
            }
        };
        if (bl) {
            runnable.run();
        } else {
            this.taskRunner.postRunnable(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireUntil(int n) throws Exception {
        int n2;
        do {
            Object object = this;
            synchronized (object) {
                n2 = this.managed.size();
            }
            if (n2 < n) {
                object = this.mgr.acquireResource();
                boolean bl = false;
                BasicResourcePool basicResourcePool = this;
                synchronized (basicResourcePool) {
                    n2 = this.managed.size();
                    if (n2 < n) {
                        this.assimilateResource(object);
                        ++n2;
                    } else {
                        bl = true;
                    }
                }
                if (bl) {
                    this.mgr.destroyResource(object);
                }
            }
            Thread.currentThread();
            Thread.yield();
        } while (n2 < n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception doSetPoolSize(int n) {
        try {
            int n2;
            if (n > this.max) {
                throw new IllegalArgumentException("Requested size [" + n + "] is greater than max [" + this.max + "].");
            }
            if (n < this.min) {
                throw new IllegalArgumentException("Requested size [" + n + "] is less than min [" + this.min + "].");
            }
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                n2 = this.managed.size();
            }
            if (n > n2) {
                this.acquireUntil(n);
            } else if (n < n2) {
                basicResourcePool = this;
                synchronized (basicResourcePool) {
                    int n3;
                    int n4 = n2 - n;
                    int n5 = this.unused.size();
                    int n6 = Math.min(n4, n5);
                    for (n3 = 0; n3 < n6; ++n3) {
                        this.removeResource(this.unused.get(0));
                    }
                    n3 = n4 - n6;
                    Iterator iterator = this.cloneOfManaged().keySet().iterator();
                    for (int i = 0; i < n3; ++i) {
                        this.excludeResource(iterator.next());
                    }
                    this.notifyAll();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return exception;
        }
    }

    private void markBrokenNoEnsureMinResources(Object object) {
        try {
            this._markBroken(object);
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", resourceClosedException);
            }
            this.unexpectedBreak();
        }
    }

    private void _markBroken(Object object) {
        if (this.unused.contains(object)) {
            this.removeResource(object);
        } else {
            this.excludeResource(object);
        }
    }

    private void close(boolean bl) {
        if (!this.broken) {
            Collection<Object> collection;
            this.broken = true;
            Collection<Object> collection2 = collection = bl ? this.cloneOfManaged().keySet() : this.cloneOfUnused();
            if (this.cullTask != null) {
                this.cullTask.cancel();
            }
            if (this.idleRefurbishTask != null) {
                this.idleRefurbishTask.cancel();
            }
            Iterator<Object> iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    Object object = iterator.next();
                    if (this.unused.contains(object)) {
                        this.removeResource(object, true);
                        continue;
                    }
                    this.excludeResource(object);
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(MLevel.FINE)) continue;
                    logger.log(MLevel.FINE, "BasicResourcePool -- A resource couldn't be cleaned up on close()", exception);
                }
            }
            iterator = this.acquireWaiters.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
            iterator = this.otherWaiters.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
            if (this.factory != null) {
                this.factory.markBroken(this);
            }
        } else if (logger.isLoggable(MLevel.WARNING)) {
            logger.warning(this + " -- close() called multiple times.");
        }
    }

    private void doCheckinManaged(final Object object) throws ResourcePoolException {
        if (this.unused.contains(object)) {
            throw new ResourcePoolException("Tried to check-in an already checked-in resource: " + object);
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    boolean bl = BasicResourcePool.this.attemptRefurbishResourceOnCheckin(object);
                    if (bl) {
                        BasicResourcePool.this.unused.add(object);
                        if (!BasicResourcePool.this.age_is_absolute) {
                            BasicResourcePool.this.managed.put(object, new Date());
                        }
                    } else {
                        BasicResourcePool.this.removeResource(object);
                        BasicResourcePool.this.ensureMinResources();
                    }
                    BasicResourcePool.this.asyncFireResourceCheckedIn(object, BasicResourcePool.this.managed.size(), BasicResourcePool.this.unused.size(), BasicResourcePool.this.excluded.size());
                    BasicResourcePool.this.notifyAll();
                }
            }
        };
        this.taskRunner.postRunnable(runnable);
    }

    private void doCheckinExcluded(Object object) {
        this.excluded.remove(object);
        this.destroyResource(object);
    }

    private void postAcquireMore() {
        int n = this.managed.size();
        int n2 = this.pendingAcquiresCounter.getValue();
        int n3 = n + Math.max(this.inc, n2 + 1);
        this.postAcquireUntil(Math.min(n3, this.max));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAcquire(long l) throws InterruptedException, TimeoutException, ResourcePoolException {
        if (this.force_kill_acquires) {
            throw new ResourcePoolException("A ResourcePool cannot acquire a new resource -- the factory or source appears to be down.");
        }
        Thread thread = Thread.currentThread();
        try {
            int n;
            long l2;
            this.acquireWaiters.add(thread);
            long l3 = l2 = l > 0L ? System.currentTimeMillis() : -1L;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("awaitAvailable(): " + (this.exampleResource != null ? this.exampleResource : "[unknown]"));
            }
            this.trace();
            while ((n = this.unused.size()) == 0) {
                if (this.pendingAcquiresCounter.getValue() == 0) {
                    this.postAcquireMore();
                }
                this.wait(l);
                if (l > 0L && System.currentTimeMillis() - l2 > l) {
                    throw new TimeoutException("internal -- timeout at awaitAcquire()");
                }
                if (this.force_kill_acquires) {
                    throw new CannotAcquireResourceException("A ResourcePool could not acquire a resource from its primary factory or source.");
                }
                this.ensureNotBroken();
            }
            Object var8_5 = null;
            this.acquireWaiters.remove(thread);
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.acquireWaiters.remove(thread);
            if (this.acquireWaiters.size() == 0) {
                this.notifyAll();
            }
            throw throwable;
        }
        if (this.acquireWaiters.size() == 0) {
            this.notifyAll();
        }
    }

    private void assimilateResource(Object object) throws Exception {
        this.managed.put(object, new Date());
        this.unused.add(object);
        this.asyncFireResourceAcquired(object, this.managed.size(), this.unused.size(), this.excluded.size());
        this.notifyAll();
        this.trace();
        if (this.exampleResource == null) {
            this.exampleResource = object;
        }
    }

    private void removeResource(Object object) {
        this.removeResource(object, false);
    }

    private void removeResource(Object object, boolean bl) {
        this.managed.remove(object);
        this.unused.remove(object);
        this.destroyResource(object, bl);
        this.asyncFireResourceRemoved(object, false, this.managed.size(), this.unused.size(), this.excluded.size());
        this.trace();
    }

    private void excludeResource(Object object) {
        this.managed.remove(object);
        this.excluded.add(object);
        if (this.unused.contains(object)) {
            throw new InternalError("We should only \"exclude\" checked-out resources!");
        }
        this.asyncFireResourceRemoved(object, true, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void removeTowards(int n) {
        int n2 = this.managed.size() - n;
        Iterator iterator = this.cloneOfUnused().iterator();
        for (int i = 0; iterator.hasNext() && i < n2; ++i) {
            Object e = iterator.next();
            this.removeResource(e);
        }
    }

    private void cullExpiredAndUnused() {
        Iterator iterator = this.cloneOfUnused().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.isExpired(e)) continue;
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Removing expired resource: " + e + " [" + this + "]");
            }
            this.removeResource(e);
        }
        this.ensureMinResources();
    }

    private void checkIdleResources() {
        LinkedList linkedList = this.cloneOfUnused();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.idleCheckResources.add(e)) continue;
            this.taskRunner.postRunnable(new AsyncTestIdleResourceTask(e));
        }
        this.trace();
    }

    private boolean isExpired(Object object) {
        if (this.max_resource_age > 0L) {
            boolean bl;
            Date date = (Date)this.managed.get(object);
            long l = System.currentTimeMillis();
            long l2 = l - date.getTime();
            boolean bl2 = bl = l2 > this.max_resource_age;
            if (logger.isLoggable(MLevel.FINEST)) {
                if (bl) {
                    logger.log(MLevel.FINEST, "EXPIRED resource: " + object + " ---> age: " + l2 + "   max: " + this.max_resource_age + " [" + this + "]");
                } else {
                    logger.log(MLevel.FINEST, "resource age is okay: " + object + " ---> age: " + l2 + "   max: " + this.max_resource_age + " [" + this + "]");
                }
            }
            return bl;
        }
        return false;
    }

    private void ensureStartResources() {
        this.postAcquireUntil(Math.max(this.start, this.min));
    }

    private void ensureMinResources() {
        if (this.managed.size() < this.min) {
            this.postAcquireUntil(this.min);
        }
    }

    private boolean attemptRefurbishResourceOnCheckout(Object object) {
        try {
            this.mgr.refurbishResourceOnCheckout(object);
            return true;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "A resource could not be refurbished on checkout.", exception);
            }
            return false;
        }
    }

    private boolean attemptRefurbishResourceOnCheckin(Object object) {
        try {
            this.mgr.refurbishResourceOnCheckin(object);
            return true;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "A resource could not be refurbished on checkin.", exception);
            }
            return false;
        }
    }

    private void ensureNotBroken() throws ResourcePoolException {
        if (this.broken) {
            throw new ResourcePoolException("Attempted to use a closed or broken resource pool");
        }
    }

    private void trace() {
        if (logger.isLoggable(MLevel.FINEST)) {
            String string = this.exampleResource == null ? "" : " (e.g. " + this.exampleResource + ")";
            logger.finest("trace " + this + " [managed: " + this.managed.size() + ", " + "unused: " + this.unused.size() + ", excluded: " + this.excluded.size() + ']' + string);
        }
    }

    private final HashMap cloneOfManaged() {
        return (HashMap)this.managed.clone();
    }

    private final LinkedList cloneOfUnused() {
        return (LinkedList)this.unused.clone();
    }

    private final HashSet cloneOfExcluded() {
        return (HashSet)this.excluded.clone();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AcquireTask
    implements Runnable {
        boolean success = false;
        int num;

        public AcquireTask(int n) {
            this.num = n;
            BasicResourcePool.this.pendingAcquiresCounter.increment();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int n = 0;
                while (this.shouldTry(n)) {
                    block18: {
                        try {
                            if (n > 0) {
                                Thread.sleep(BasicResourcePool.this.acq_attempt_delay);
                            }
                            BasicResourcePool.this.acquireUntil(this.num);
                            this.success = true;
                        }
                        catch (Exception exception) {
                            if (!logger.isLoggable(MLevel.FINE)) break block18;
                            logger.log(MLevel.FINE, "An exception occurred while acquiring a resource.", exception);
                        }
                    }
                    ++n;
                }
                if (!this.success) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, this + " -- Acquisition Attempt Failed!!! Clearing pending acquires. " + "While trying to acquire a needed new resource, we failed " + "to succeed more than the maximum number of allowed " + "acquisition attempts (" + BasicResourcePool.this.num_acq_attempts + ").");
                    }
                    if (BasicResourcePool.this.break_on_acquisition_failure) {
                        if (logger.isLoggable(MLevel.SEVERE)) {
                            logger.severe("THE RESOURCE POOL IS PERMANENTLY BROKEN! [" + this + "]");
                        }
                        BasicResourcePool.this.unexpectedBreak();
                    } else {
                        BasicResourcePool.this.forceKillAcquires();
                    }
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
            catch (InterruptedException interruptedException) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, BasicResourcePool.this + " -- Thread unexpectedly interrupted while waiting for stale acquisition attempts to die.", interruptedException);
                }
            }
            finally {
                BasicResourcePool.this.pendingAcquiresCounter.decrement();
            }
        }

        private boolean shouldTry(int n) {
            return !this.success && !BasicResourcePool.this.isForceKillAcquiresPending() && (BasicResourcePool.this.num_acq_attempts <= 0 || n < BasicResourcePool.this.num_acq_attempts);
        }
    }

    class AsyncTestIdleResourceTask
    implements Runnable {
        Object resc;
        boolean pending = true;
        boolean failed;

        AsyncTestIdleResourceTask(Object object) {
            this.resc = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BasicResourcePool basicResourcePool;
            try {
                boolean bl;
                try {
                    BasicResourcePool.this.mgr.refurbishIdleResource(this.resc);
                    bl = false;
                }
                catch (Exception exception) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "BasicResourcePool: An idle resource is broken and will be purged.", exception);
                    }
                    bl = true;
                }
                BasicResourcePool basicResourcePool2 = BasicResourcePool.this;
                synchronized (basicResourcePool2) {
                    if (bl && BasicResourcePool.this.managed.keySet().contains(this.resc)) {
                        BasicResourcePool.this.removeResource(this.resc);
                        BasicResourcePool.this.ensureMinResources();
                    }
                }
                Object var5_5 = null;
                basicResourcePool = BasicResourcePool.this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                BasicResourcePool basicResourcePool3 = BasicResourcePool.this;
                synchronized (basicResourcePool3) {
                    BasicResourcePool.this.idleCheckResources.remove(this.resc);
                    BasicResourcePool.this.notifyAll();
                }
                throw throwable;
            }
            synchronized (basicResourcePool) {
                BasicResourcePool.this.idleCheckResources.remove(this.resc);
                BasicResourcePool.this.notifyAll();
            }
        }
    }

    class CheckIdleResourcesTask
    extends TimerTask {
        CheckIdleResourcesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Refurbishing idle resources - " + new Date() + " [" + BasicResourcePool.this + "]");
                }
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.checkIdleResources();
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class CullTask
    extends TimerTask {
        CullTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Checking for expired resources - " + new Date() + " [" + BasicResourcePool.this + "]");
                }
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.cullExpiredAndUnused();
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class RemoveTask
    implements Runnable {
        int num;

        public RemoveTask(int n) {
            this.num = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.removeTowards(this.num);
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }
}

