/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.FallbackMLog;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogClasses;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.NameTransformer;
import java.util.ArrayList;

public abstract class MLog {
    static final NameTransformer transformer;
    static final MLog mlog;
    static final MultiPropertiesConfig CONFIG;
    static final MLogger logger;
    static /* synthetic */ Class class$com$mchange$v2$log$MLog;

    public static MLog findByClassnames(String[] stringArray) {
        int n;
        ArrayList<String> arrayList = null;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            try {
                return (MLog)Class.forName(stringArray[n]).newInstance();
            }
            catch (Exception exception) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(stringArray[n]);
                continue;
            }
        }
        System.err.println("Tried without success to load the following MLog classes:");
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            System.err.println("\t" + arrayList.get(n));
        }
        return null;
    }

    public static MLog instance() {
        return mlog;
    }

    public static MLogger getLogger(String string) {
        String string2;
        MLogger mLogger = transformer == null ? MLog.instance().getMLogger(string) : ((string2 = transformer.transformName(string)) != null ? MLog.instance().getMLogger(string2) : MLog.instance().getMLogger(string));
        return mLogger;
    }

    public static MLogger getLogger(Class clazz) {
        String string;
        MLogger mLogger = transformer == null ? MLog.instance().getMLogger(clazz) : ((string = transformer.transformName(clazz)) != null ? MLog.instance().getMLogger(string) : MLog.instance().getMLogger(clazz));
        return mLogger;
    }

    public static MLogger getLogger() {
        String string;
        MLogger mLogger = transformer == null ? MLog.instance().getMLogger() : ((string = transformer.transformName()) != null ? MLog.instance().getMLogger(string) : MLog.instance().getMLogger());
        return mLogger;
    }

    public static void log(MLevel mLevel, String string) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string);
    }

    public static void log(MLevel mLevel, String string, Object object) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, object);
    }

    public static void log(MLevel mLevel, String string, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, objectArray);
    }

    public static void log(MLevel mLevel, String string, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().log(mLevel, string, throwable);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Object object) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, object);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, objectArray);
    }

    public static void logp(MLevel mLevel, String string, String string2, String string3, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, throwable);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4) {
        MLog.instance();
        MLog.getLogger().logp(mLevel, string, string2, string3, string4);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object object) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, object);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, objectArray);
    }

    public static void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().logrb(mLevel, string, string2, string3, string4, throwable);
    }

    public static void entering(String string, String string2) {
        MLog.instance();
        MLog.getLogger().entering(string, string2);
    }

    public static void entering(String string, String string2, Object object) {
        MLog.instance();
        MLog.getLogger().entering(string, string2, object);
    }

    public static void entering(String string, String string2, Object[] objectArray) {
        MLog.instance();
        MLog.getLogger().entering(string, string2, objectArray);
    }

    public static void exiting(String string, String string2) {
        MLog.instance();
        MLog.getLogger().exiting(string, string2);
    }

    public static void exiting(String string, String string2, Object object) {
        MLog.instance();
        MLog.getLogger().exiting(string, string2, object);
    }

    public static void throwing(String string, String string2, Throwable throwable) {
        MLog.instance();
        MLog.getLogger().throwing(string, string2, throwable);
    }

    public static void severe(String string) {
        MLog.instance();
        MLog.getLogger().severe(string);
    }

    public static void warning(String string) {
        MLog.instance();
        MLog.getLogger().warning(string);
    }

    public static void info(String string) {
        MLog.instance();
        MLog.getLogger().info(string);
    }

    public static void config(String string) {
        MLog.instance();
        MLog.getLogger().config(string);
    }

    public static void fine(String string) {
        MLog.instance();
        MLog.getLogger().fine(string);
    }

    public static void finer(String string) {
        MLog.instance();
        MLog.getLogger().finer(string);
    }

    public static void finest(String string) {
        MLog.instance();
        MLog.getLogger().finest(string);
    }

    public abstract MLogger getMLogger(String var1);

    public abstract MLogger getMLogger(Class var1);

    public abstract MLogger getMLogger();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[] stringArray = new String[]{"/com/mchange/v2/log/default-mchange-log.properties", "/mchange-log.properties", "/"};
        CONFIG = MultiPropertiesConfig.readVmConfig(stringArray, null);
        String string = CONFIG.getProperty("com.mchange.v2.log.MLog");
        String[] stringArray2 = null;
        if (string == null) {
            string = CONFIG.getProperty("com.mchange.v2.log.mlog");
        }
        if (string != null) {
            stringArray2 = StringTokenizerUtils.tokenizeToArray(string, ", \t\r\n");
        }
        boolean bl = false;
        MLog mLog = null;
        if (stringArray2 != null) {
            mLog = MLog.findByClassnames(stringArray2);
        }
        if (mLog == null) {
            mLog = MLog.findByClassnames(MLogClasses.CLASSNAMES);
        }
        if (mLog == null) {
            bl = true;
            mLog = new FallbackMLog();
        }
        mlog = mLog;
        if (bl) {
            MLog.info("Using " + mlog.getClass().getName() + " -- Named logger's not supported, everything goes to System.err.");
        }
        logger = MLog.getLogger(class$com$mchange$v2$log$MLog == null ? (class$com$mchange$v2$log$MLog = MLog.class$("com.mchange.v2.log.MLog")) : class$com$mchange$v2$log$MLog);
        String string2 = mlog.getClass().getName();
        if ("com.mchange.v2.log.jdk14logging.Jdk14MLog".equals(string2)) {
            string2 = "java 1.4+ standard";
        } else if ("com.mchange.v2.log.log4j.Log4jMLog".equals(string2)) {
            string2 = "log4j";
        }
        if (logger.isLoggable(MLevel.INFO)) {
            logger.log(MLevel.INFO, "MLog clients using " + string2 + " logging.");
        }
        NameTransformer nameTransformer = null;
        String string3 = CONFIG.getProperty("com.mchange.v2.log.NameTransformer");
        if (string3 == null) {
            string3 = CONFIG.getProperty("com.mchange.v2.log.nametransformer");
        }
        try {
            if (string3 != null) {
                nameTransformer = (NameTransformer)Class.forName(string3).newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to instantiate com.mchange.v2.log.NameTransformer '" + string3 + "'!");
            exception.printStackTrace();
        }
        transformer = nameTransformer;
    }
}

