/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class FallbackMLog
extends MLog {
    static final MLevel DEFAULT_CUTOFF_LEVEL;
    MLogger logger = new FallbackMLogger();

    public synchronized MLogger getMLogger(String string) {
        return this.logger;
    }

    public MLogger getMLogger(Class clazz) {
        return FallbackMLog.getLogger(clazz.getName());
    }

    public MLogger getMLogger() {
        return this.logger;
    }

    static {
        MLevel mLevel = null;
        String string = MLog.CONFIG.getProperty("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL");
        if (string != null) {
            mLevel = MLevel.fromSeverity(string);
        }
        if (mLevel == null) {
            mLevel = MLevel.INFO;
        }
        DEFAULT_CUTOFF_LEVEL = mLevel;
    }

    private static final class FallbackMLogger
    implements MLogger {
        MLevel cutoffLevel = DEFAULT_CUTOFF_LEVEL;

        private FallbackMLogger() {
        }

        private void formatrb(MLevel mLevel, String string, String string2, String string3, String string4, Object[] objectArray, Throwable throwable) {
            String string5;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string3);
            if (string4 != null && resourceBundle != null && (string5 = resourceBundle.getString(string4)) != null) {
                string4 = string5;
            }
            this.format(mLevel, string, string2, string4, objectArray, throwable);
        }

        private void format(MLevel mLevel, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
            System.err.println(this.formatString(mLevel, string, string2, string3, objectArray, throwable));
        }

        private String formatString(MLevel mLevel, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
            boolean bl = string2 != null && !string2.endsWith(")");
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append(mLevel.getLineHeader());
            stringBuffer.append(' ');
            if (string != null && string2 != null) {
                stringBuffer.append('[');
                stringBuffer.append(string);
                stringBuffer.append('.');
                stringBuffer.append(string2);
                if (bl) {
                    stringBuffer.append("()");
                }
                stringBuffer.append(']');
            } else if (string != null) {
                stringBuffer.append('[');
                stringBuffer.append(string);
                stringBuffer.append(']');
            } else if (string2 != null) {
                stringBuffer.append('[');
                stringBuffer.append(string2);
                if (bl) {
                    stringBuffer.append("()");
                }
                stringBuffer.append(']');
            }
            if (string3 == null) {
                if (objectArray != null) {
                    stringBuffer.append("params: ");
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        if (i != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(objectArray[i]);
                    }
                }
            } else if (objectArray == null) {
                stringBuffer.append(string3);
            } else {
                MessageFormat messageFormat = new MessageFormat(string3);
                stringBuffer.append(messageFormat.format(objectArray));
            }
            if (throwable != null) {
                stringBuffer.append(ThrowableUtils.extractStackTrace(throwable));
            }
            return stringBuffer.toString();
        }

        public ResourceBundle getResourceBundle() {
            return null;
        }

        public String getResourceBundleName() {
            return null;
        }

        public void setFilter(Object object) throws SecurityException {
            this.warning("Using FallbackMLog -- Filters not supported!");
        }

        public Object getFilter() {
            return null;
        }

        public void log(MLevel mLevel, String string) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, null, null, string, null, null);
            }
        }

        public void log(MLevel mLevel, String string, Object object) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, null, null, string, new Object[]{object}, null);
            }
        }

        public void log(MLevel mLevel, String string, Object[] objectArray) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, null, null, string, objectArray, null);
            }
        }

        public void log(MLevel mLevel, String string, Throwable throwable) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, null, null, string, null, throwable);
            }
        }

        public void logp(MLevel mLevel, String string, String string2, String string3) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, string, string2, string3, null, null);
            }
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Object object) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, string, string2, string3, new Object[]{object}, null);
            }
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Object[] objectArray) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, string, string2, string3, objectArray, null);
            }
        }

        public void logp(MLevel mLevel, String string, String string2, String string3, Throwable throwable) {
            if (this.isLoggable(mLevel)) {
                this.format(mLevel, string, string2, string3, null, throwable);
            }
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4) {
            if (this.isLoggable(mLevel)) {
                this.formatrb(mLevel, string, string2, string3, string4, null, null);
            }
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object object) {
            if (this.isLoggable(mLevel)) {
                this.formatrb(mLevel, string, string2, string3, string4, new Object[]{object}, null);
            }
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Object[] objectArray) {
            if (this.isLoggable(mLevel)) {
                this.formatrb(mLevel, string, string2, string3, string4, objectArray, null);
            }
        }

        public void logrb(MLevel mLevel, String string, String string2, String string3, String string4, Throwable throwable) {
            if (this.isLoggable(mLevel)) {
                this.formatrb(mLevel, string, string2, string3, string4, null, throwable);
            }
        }

        public void entering(String string, String string2) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, string, string2, "Entering method.", null, null);
            }
        }

        public void entering(String string, String string2, Object object) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, string, string2, "Entering method with argument " + object, null, null);
            }
        }

        public void entering(String string, String string2, Object[] objectArray) {
            if (this.isLoggable(MLevel.FINER)) {
                if (objectArray == null) {
                    this.entering(string, string2);
                } else {
                    StringBuffer stringBuffer = new StringBuffer(128);
                    stringBuffer.append("( ");
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        if (i != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(objectArray[i]);
                    }
                    stringBuffer.append(" )");
                    this.format(MLevel.FINER, string, string2, "Entering method with arguments " + stringBuffer.toString(), null, null);
                }
            }
        }

        public void exiting(String string, String string2) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, string, string2, "Exiting method.", null, null);
            }
        }

        public void exiting(String string, String string2, Object object) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, string, string2, "Exiting method with result " + object, null, null);
            }
        }

        public void throwing(String string, String string2, Throwable throwable) {
            if (this.isLoggable(MLevel.FINE)) {
                this.format(MLevel.FINE, string, string2, "Throwing exception.", null, throwable);
            }
        }

        public void severe(String string) {
            if (this.isLoggable(MLevel.SEVERE)) {
                this.format(MLevel.SEVERE, null, null, string, null, null);
            }
        }

        public void warning(String string) {
            if (this.isLoggable(MLevel.WARNING)) {
                this.format(MLevel.WARNING, null, null, string, null, null);
            }
        }

        public void info(String string) {
            if (this.isLoggable(MLevel.INFO)) {
                this.format(MLevel.INFO, null, null, string, null, null);
            }
        }

        public void config(String string) {
            if (this.isLoggable(MLevel.CONFIG)) {
                this.format(MLevel.CONFIG, null, null, string, null, null);
            }
        }

        public void fine(String string) {
            if (this.isLoggable(MLevel.FINE)) {
                this.format(MLevel.FINE, null, null, string, null, null);
            }
        }

        public void finer(String string) {
            if (this.isLoggable(MLevel.FINER)) {
                this.format(MLevel.FINER, null, null, string, null, null);
            }
        }

        public void finest(String string) {
            if (this.isLoggable(MLevel.FINEST)) {
                this.format(MLevel.FINEST, null, null, string, null, null);
            }
        }

        public void setLevel(MLevel mLevel) throws SecurityException {
            this.cutoffLevel = mLevel;
        }

        public synchronized MLevel getLevel() {
            return this.cutoffLevel;
        }

        public synchronized boolean isLoggable(MLevel mLevel) {
            return mLevel.intValue() >= this.cutoffLevel.intValue();
        }

        public String getName() {
            return "global";
        }

        public void addHandler(Object object) throws SecurityException {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        public void removeHandler(Object object) throws SecurityException {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        public Object[] getHandlers() {
            this.warning("Using FallbackMLog -- Handlers not supported.");
            return new Object[0];
        }

        public void setUseParentHandlers(boolean bl) {
            this.warning("Using FallbackMLog -- Handlers not supported.");
        }

        public boolean getUseParentHandlers() {
            return false;
        }
    }
}

