/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.stmt;

import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.c3p0.stmt.StatementCacheKey;
import com.mchange.v2.holders.ChangeNotifyingSynchronizedIntHolder;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class GooGooStatementCache {
    private static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$stmt$GooGooStatementCache == null ? (class$com$mchange$v2$c3p0$stmt$GooGooStatementCache = GooGooStatementCache.class$("com.mchange.v2.c3p0.stmt.GooGooStatementCache")) : class$com$mchange$v2$c3p0$stmt$GooGooStatementCache);
    ConnectionStatementManager cxnStmtMgr;
    HashMap stmtToKey = new HashMap();
    HashMap keyToKeyRec = new HashMap();
    HashSet checkedOut = new HashSet();
    int stmt_count;
    AsynchronousRunner blockingTaskAsyncRunner;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$stmt$GooGooStatementCache;

    public GooGooStatementCache(AsynchronousRunner asynchronousRunner) {
        this.blockingTaskAsyncRunner = asynchronousRunner;
        this.cxnStmtMgr = this.createConnectionStatementManager();
    }

    abstract ConnectionStatementManager createConnectionStatementManager();

    public synchronized Object checkoutStatement(Connection connection, Method method, Object[] objectArray) throws SQLException {
        Object object = null;
        StatementCacheKey statementCacheKey = StatementCacheKey.find(connection, method, objectArray);
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        if (linkedList == null || linkedList.isEmpty()) {
            object = this.acquireStatement(connection, method, objectArray);
            if (this.prepareAssimilateNewStatement(connection)) {
                this.assimilateNewCheckedOutStatement(statementCacheKey, connection, object);
            }
        } else {
            logger.finest(this.getClass().getName() + " ----> CACHE HIT");
            object = linkedList.get(0);
            linkedList.remove(0);
            if (!this.checkedOut.add(object)) {
                throw new RuntimeException("Internal inconsistency: Checking out a statement marked as already checked out!");
            }
            this.removeStatementFromDeathmarches(object, connection);
        }
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("checkoutStatement: " + this.statsString());
        }
        return object;
    }

    public synchronized void checkinStatement(Object object) throws SQLException {
        if (!this.checkedOut.remove(object)) {
            if (!this.ourResource(object)) {
                this.destroyStatement(object);
            }
            return;
        }
        try {
            this.refreshStatement((PreparedStatement)object);
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.log(MLevel.INFO, "Problem with checked-in Statement, discarding.", exception);
            }
            this.checkedOut.add(object);
            this.removeStatement(object, true);
            return;
        }
        StatementCacheKey statementCacheKey = (StatementCacheKey)this.stmtToKey.get(object);
        if (statementCacheKey == null) {
            throw new RuntimeException("Internal inconsistency: A checked-out statement has no key associated with it!");
        }
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        linkedList.add(object);
        this.addStatementToDeathmarches(object, statementCacheKey.physicalConnection);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("checkinStatement(): " + this.statsString());
        }
    }

    public synchronized void checkinAll(Connection connection) throws SQLException {
        Set set = this.cxnStmtMgr.statementSet(connection);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!this.checkedOut.contains(e)) continue;
                this.checkinStatement(e);
            }
        }
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, "checkinAll(): " + this.statsString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll(Connection connection) throws SQLException {
        Set set = null;
        Object object = this;
        synchronized (object) {
            set = this.cxnStmtMgr.statementSet(connection);
        }
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, "ENTER METHOD: closeAll( " + connection + " )! -- num_connections: " + this.cxnStmtMgr.getNumConnectionsWithCachedStatements());
            logger.log(MLevel.FINEST, "Set of statements for connection: " + set + (set != null ? "; size: " + set.size() : ""));
        }
        Object object2 = object = new ChangeNotifyingSynchronizedIntHolder(0, true);
        synchronized (object2) {
            block16: {
                if (set != null) {
                    HashSet hashSet = new HashSet(set);
                    int n = hashSet.size();
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        GooGooStatementCache gooGooStatementCache = this;
                        synchronized (gooGooStatementCache) {
                            this.removeStatement(e, true, (ChangeNotifyingSynchronizedIntHolder)object);
                        }
                    }
                    try {
                        while (((ChangeNotifyingSynchronizedIntHolder)object).getValue() < n) {
                            object.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block16;
                        logger.warning("Unexpected interupt(). [A thread closing all Statements for a Connection in a Statement cache will no longer wait for all Statements to close, but will move on and let them close() asynchronously. This is harmless in general, but may lead to a transient deadlock (which the thread pool will notice  and resolve) under Oracle, due to an Oracle bug.");
                    }
                }
            }
        }
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("closeAll(): " + this.statsString());
        }
    }

    public synchronized void close() throws SQLException {
        Iterator iterator = this.stmtToKey.keySet().iterator();
        while (iterator.hasNext()) {
            this.synchronousDestroyStatement(iterator.next());
        }
        this.cxnStmtMgr = null;
        this.stmtToKey = null;
        this.keyToKeyRec = null;
        this.checkedOut = null;
        this.stmt_count = -1;
    }

    private void destroyStatement(Object object) {
        this.destroyStatement(object, null);
    }

    private void destroyStatement(final Object object, final ChangeNotifyingSynchronizedIntHolder changeNotifyingSynchronizedIntHolder) {
        Runnable runnable = changeNotifyingSynchronizedIntHolder == null ? new Runnable(){

            public void run() {
                StatementUtils.attemptClose((PreparedStatement)object);
            }
        } : new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ChangeNotifyingSynchronizedIntHolder changeNotifyingSynchronizedIntHolder2 = changeNotifyingSynchronizedIntHolder;
                synchronized (changeNotifyingSynchronizedIntHolder2) {
                    StatementUtils.attemptClose((PreparedStatement)object);
                    changeNotifyingSynchronizedIntHolder.increment();
                }
            }
        };
        this.blockingTaskAsyncRunner.postRunnable(runnable);
    }

    private void synchronousDestroyStatement(Object object) {
        StatementUtils.attemptClose((PreparedStatement)object);
    }

    abstract boolean prepareAssimilateNewStatement(Connection var1);

    abstract void addStatementToDeathmarches(Object var1, Connection var2);

    abstract void removeStatementFromDeathmarches(Object var1, Connection var2);

    final int countCachedStatements() {
        return this.stmtToKey.size();
    }

    private void assimilateNewCheckedOutStatement(StatementCacheKey statementCacheKey, Connection connection, Object object) {
        this.stmtToKey.put(object, statementCacheKey);
        HashSet hashSet = this.keySet(statementCacheKey);
        if (hashSet == null) {
            this.keyToKeyRec.put(statementCacheKey, new KeyRec());
        } else {
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Multiply prepared statement! " + statementCacheKey.stmtText);
            }
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("(The same statement has already been prepared by this Connection, and that other instance has not yet been closed, so the statement pool has to prepare a second PreparedStatement object rather than reusing the previously-cached Statement. The new Statement will be cached, in case you frequently need multiple copies of this Statement.)");
            }
        }
        this.keySet(statementCacheKey).add(object);
        this.cxnStmtMgr.addStatementForConnection(object, connection);
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("cxnStmtMgr.statementSet( " + connection + " ).size(): " + this.cxnStmtMgr.statementSet(connection).size());
        }
        ++this.stmt_count;
        this.checkedOut.add(object);
    }

    private void removeStatement(Object object, boolean bl) {
        this.removeStatement(object, bl, null);
    }

    private void removeStatement(Object object, boolean bl, ChangeNotifyingSynchronizedIntHolder changeNotifyingSynchronizedIntHolder) {
        StatementCacheKey statementCacheKey = (StatementCacheKey)this.stmtToKey.remove(object);
        this.removeFromKeySet(statementCacheKey, object);
        Connection connection = statementCacheKey.physicalConnection;
        if (!this.checkedOut.contains(object)) {
            this.removeStatementFromDeathmarches(object, connection);
            this.removeFromCheckoutQueue(statementCacheKey, object);
            this.destroyStatement(object, changeNotifyingSynchronizedIntHolder);
        } else {
            this.checkedOut.remove(object);
            if (bl) {
                this.destroyStatement(object, changeNotifyingSynchronizedIntHolder);
            }
        }
        boolean bl2 = this.cxnStmtMgr.removeStatementForConnection(object, connection);
        if (!bl2 && logger.isLoggable(MLevel.WARNING)) {
            logger.log(MLevel.WARNING, this + " removed a statement that apparently wasn't in a statement set!!!", new Exception("LOG STACK TRACE"));
        }
        --this.stmt_count;
    }

    private Object acquireStatement(final Connection connection, final Method method, final Object[] objectArray) throws SQLException {
        try {
            final Object[] objectArray2 = new Object[1];
            final SQLException[] sQLExceptionArray = new SQLException[1];
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    GooGooStatementCache gooGooStatementCache;
                    try {
                        try {
                            objectArray2[0] = method.invoke((Object)connection, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getTargetException();
                            sQLExceptionArray[0] = throwable instanceof SQLException ? (SQLException)throwable : SqlUtils.toSQLException(throwable);
                            Object var4_2 = null;
                            GooGooStatementCache gooGooStatementCache3 = GooGooStatementCache.this;
                            synchronized (gooGooStatementCache3) {
                                GooGooStatementCache.this.notifyAll();
                                return;
                            }
                        }
                        catch (Exception exception) {
                            sQLExceptionArray[0] = SqlUtils.toSQLException(exception);
                            Object var4_3 = null;
                            GooGooStatementCache gooGooStatementCache4 = GooGooStatementCache.this;
                            synchronized (gooGooStatementCache4) {
                                GooGooStatementCache.this.notifyAll();
                                return;
                            }
                        }
                        Object var4_1 = null;
                        gooGooStatementCache = GooGooStatementCache.this;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        GooGooStatementCache gooGooStatementCache2 = GooGooStatementCache.this;
                        synchronized (gooGooStatementCache2) {
                            GooGooStatementCache.this.notifyAll();
                            throw throwable;
                        }
                    }
                    synchronized (gooGooStatementCache) {
                        GooGooStatementCache.this.notifyAll();
                        return;
                    }
                }
            };
            this.blockingTaskAsyncRunner.postRunnable(runnable);
            while (objectArray2[0] == null && sQLExceptionArray[0] == null) {
                this.wait();
            }
            if (sQLExceptionArray[0] != null) {
                throw sQLExceptionArray[0];
            }
            Object object = objectArray2[0];
            return object;
        }
        catch (InterruptedException interruptedException) {
            throw SqlUtils.toSQLException(interruptedException);
        }
    }

    private KeyRec keyRec(StatementCacheKey statementCacheKey) {
        return (KeyRec)this.keyToKeyRec.get(statementCacheKey);
    }

    private HashSet keySet(StatementCacheKey statementCacheKey) {
        KeyRec keyRec = this.keyRec(statementCacheKey);
        return keyRec == null ? null : keyRec.allStmts;
    }

    private boolean removeFromKeySet(StatementCacheKey statementCacheKey, Object object) {
        HashSet hashSet = this.keySet(statementCacheKey);
        boolean bl = hashSet.remove(object);
        if (hashSet.isEmpty() && this.checkoutQueue(statementCacheKey).isEmpty()) {
            this.keyToKeyRec.remove(statementCacheKey);
        }
        return bl;
    }

    private LinkedList checkoutQueue(StatementCacheKey statementCacheKey) {
        KeyRec keyRec = this.keyRec(statementCacheKey);
        return keyRec == null ? null : keyRec.checkoutQueue;
    }

    private boolean removeFromCheckoutQueue(StatementCacheKey statementCacheKey, Object object) {
        LinkedList linkedList = this.checkoutQueue(statementCacheKey);
        boolean bl = linkedList.remove(object);
        if (linkedList.isEmpty() && this.keySet(statementCacheKey).isEmpty()) {
            this.keyToKeyRec.remove(statementCacheKey);
        }
        return bl;
    }

    private boolean ourResource(Object object) {
        return this.stmtToKey.keySet().contains(object);
    }

    private void refreshStatement(PreparedStatement preparedStatement) throws Exception {
        preparedStatement.clearParameters();
    }

    private void printStats() {
        int n = this.countCachedStatements();
        int n2 = this.checkedOut.size();
        int n3 = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int n4 = this.keyToKeyRec.size();
        System.err.print(this.getClass().getName() + " stats -- ");
        System.err.print("total size: " + n);
        System.err.print("; checked out: " + n2);
        System.err.print("; num connections: " + n3);
        System.err.println("; num keys: " + n4);
    }

    private String statsString() {
        int n = this.countCachedStatements();
        int n2 = this.checkedOut.size();
        int n3 = this.cxnStmtMgr.getNumConnectionsWithCachedStatements();
        int n4 = this.keyToKeyRec.size();
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" stats -- ");
        stringBuffer.append("total size: ");
        stringBuffer.append(n);
        stringBuffer.append("; checked out: ");
        stringBuffer.append(n2);
        stringBuffer.append("; num connections: ");
        stringBuffer.append(n3);
        stringBuffer.append("; num keys: ");
        stringBuffer.append(n4);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static abstract class ConnectionStatementManager {
        Map cxnToStmtSets = new HashMap();

        protected ConnectionStatementManager() {
        }

        public int getNumConnectionsWithCachedStatements() {
            return this.cxnToStmtSets.size();
        }

        public Set statementSet(Connection connection) {
            return (Set)this.cxnToStmtSets.get(connection);
        }

        public int getNumStatementsForConnection(Connection connection) {
            Set set = this.statementSet(connection);
            return set == null ? 0 : set.size();
        }

        public void addStatementForConnection(Object object, Connection connection) {
            HashSet<Object> hashSet = this.statementSet(connection);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                this.cxnToStmtSets.put(connection, hashSet);
            }
            hashSet.add(object);
        }

        public boolean removeStatementForConnection(Object object, Connection connection) {
            boolean bl;
            Set set = this.statementSet(connection);
            if (set != null) {
                bl = set.remove(object);
                if (set.isEmpty()) {
                    this.cxnToStmtSets.remove(connection);
                }
            } else {
                bl = false;
            }
            return bl;
        }
    }

    protected class Deathmarch {
        TreeMap longsToStmts = new TreeMap();
        HashMap stmtsToLongs = new HashMap();
        long last_long = -1L;

        protected Deathmarch() {
        }

        public void deathmarchStatement(Object object) {
            Long l = (Long)this.stmtsToLongs.get(object);
            if (l != null) {
                throw new RuntimeException("Internal inconsistency: A statement is being double-deathmatched. no checked-out statements should be in a deathmarch already; no already checked-in statement should be deathmarched!");
            }
            l = this.getNextLong();
            this.stmtsToLongs.put(object, l);
            this.longsToStmts.put(l, object);
        }

        public void undeathmarchStatement(Object object) {
            Long l = (Long)this.stmtsToLongs.remove(object);
            if (l == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
            Object v = this.longsToStmts.remove(l);
            if (l == null) {
                throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
            }
        }

        public boolean cullNext() {
            if (this.longsToStmts.isEmpty()) {
                return false;
            }
            Long l = (Long)this.longsToStmts.firstKey();
            Object v = this.longsToStmts.get(l);
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("CULLING: " + ((StatementCacheKey)GooGooStatementCache.this.stmtToKey.get(v)).stmtText);
            }
            GooGooStatementCache.this.removeStatement(v, true);
            if (this.contains(v)) {
                throw new RuntimeException("Inconsistency!!! Statement culled from deathmarch failed to be removed by removeStatement( ... )!");
            }
            return true;
        }

        public boolean contains(Object object) {
            return this.stmtsToLongs.keySet().contains(object);
        }

        public int size() {
            return this.longsToStmts.size();
        }

        private Long getNextLong() {
            return new Long(++this.last_long);
        }
    }

    protected final class DeathmarchConnectionStatementManager
    extends ConnectionStatementManager {
        Map cxnsToDms = new HashMap();

        protected DeathmarchConnectionStatementManager() {
        }

        public void addStatementForConnection(Object object, Connection connection) {
            super.addStatementForConnection(object, connection);
            Deathmarch deathmarch = (Deathmarch)this.cxnsToDms.get(connection);
            if (deathmarch == null) {
                deathmarch = new Deathmarch();
                this.cxnsToDms.put(connection, deathmarch);
            }
        }

        public boolean removeStatementForConnection(Object object, Connection connection) {
            boolean bl = super.removeStatementForConnection(object, connection);
            if (bl && this.statementSet(connection) == null) {
                this.cxnsToDms.remove(connection);
            }
            return bl;
        }

        public Deathmarch getDeathmarch(Connection connection) {
            return (Deathmarch)this.cxnsToDms.get(connection);
        }
    }

    private static class KeyRec {
        HashSet allStmts = new HashSet();
        LinkedList checkoutQueue = new LinkedList();

        private KeyRec() {
        }
    }

    protected static final class SimpleConnectionStatementManager
    extends ConnectionStatementManager {
        protected SimpleConnectionStatementManager() {
        }
    }
}

