/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.NewProxyConnection;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.util.ConnectionEventSupport;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class NewPooledConnection
implements PooledConnection {
    private static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$impl$NewPooledConnection == null ? (class$com$mchange$v2$c3p0$impl$NewPooledConnection = NewPooledConnection.class$("com.mchange.v2.c3p0.impl.NewPooledConnection")) : class$com$mchange$v2$c3p0$impl$NewPooledConnection);
    final Connection physicalConnection;
    final ConnectionTester connectionTester;
    final boolean autoCommitOnClose;
    final boolean forceIgnoreUnresolvedTransactions;
    final boolean supports_setTypeMap;
    final boolean supports_setHoldability;
    final int dflt_txn_isolation;
    final String dflt_catalog;
    final int dflt_holdability;
    final ConnectionEventSupport ces;
    GooGooStatementCache scache = null;
    Throwable invalidatingException = null;
    int connection_status = 0;
    Set uncachedActiveStatements = new HashSet();
    Map resultSetsForStatements = new HashMap();
    Set metaDataResultSets = new HashSet();
    Set rawConnectionResultSets = null;
    boolean connection_error_signaled = false;
    volatile NewProxyConnection exposedProxy = null;
    volatile boolean isolation_lvl_nondefault = false;
    volatile boolean catalog_nondefault = false;
    volatile boolean holdability_nondefault = false;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$NewPooledConnection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    public NewPooledConnection(Connection connection, ConnectionTester connectionTester, boolean bl, boolean bl2) throws SQLException {
        this.physicalConnection = connection;
        this.connectionTester = connectionTester;
        this.autoCommitOnClose = bl;
        this.forceIgnoreUnresolvedTransactions = bl2;
        this.supports_setTypeMap = C3P0ImplUtils.supportsMethod(connection, "setTypeMap", new Class[]{class$java$util$Map == null ? (class$java$util$Map = NewPooledConnection.class$("java.util.Map")) : class$java$util$Map});
        this.supports_setHoldability = C3P0ImplUtils.supportsMethod(connection, "setHoldability", new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = NewPooledConnection.class$("java.lang.Integer")) : class$java$lang$Integer});
        this.dflt_txn_isolation = connection.getTransactionIsolation();
        this.dflt_catalog = connection.getCatalog();
        this.dflt_holdability = this.supports_setHoldability ? connection.getHoldability() : 2;
        this.ces = new ConnectionEventSupport(this);
    }

    public synchronized Connection getConnection() throws SQLException {
        try {
            if (this.exposedProxy == null) {
                this.exposedProxy = new NewProxyConnection(this.physicalConnection, this);
            } else if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("c3p0 -- Uh oh... getConnection() was called on a PooledConnection when it had already provided a client with a Connection that has not yet been closed. This probably indicates a bug in the connection pool!!!");
            }
            return this.exposedProxy;
        }
        catch (Exception exception) {
            SQLException sQLException = this.handleThrowable(exception);
            throw sQLException;
        }
    }

    public synchronized int getConnectionStatus() {
        return this.connection_status;
    }

    public synchronized void closeAll() throws SQLException {
        try {
            this.closeAllCachedStatements();
        }
        catch (Exception exception) {
            SQLException sQLException = this.handleThrowable(exception);
            throw sQLException;
        }
    }

    public synchronized void close() throws SQLException {
        this.close(null);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.ces.addConnectionEventListener(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.ces.removeConnectionEventListener(connectionEventListener);
    }

    public synchronized void initStatementCache(GooGooStatementCache gooGooStatementCache) {
        this.scache = gooGooStatementCache;
    }

    public synchronized GooGooStatementCache getStatementCache() {
        return this.scache;
    }

    void markNewTxnIsolation(int n) {
        this.isolation_lvl_nondefault = n != this.dflt_txn_isolation;
    }

    void markNewCatalog(String string) {
        this.catalog_nondefault = ObjectUtils.eqOrBothNull(string, this.dflt_catalog);
    }

    void markNewHoldability(int n) {
        this.holdability_nondefault = n != this.dflt_holdability;
    }

    synchronized Object checkoutStatement(Method method, Object[] objectArray) throws SQLException {
        return this.scache.checkoutStatement(this.physicalConnection, method, objectArray);
    }

    synchronized void checkinStatement(Statement statement) throws SQLException {
        this.cleanupStatementResultSets(statement);
        this.scache.checkinStatement(statement);
    }

    synchronized void markActiveUncachedStatement(Statement statement) {
        this.uncachedActiveStatements.add(statement);
    }

    synchronized void markInactiveUncachedStatement(Statement statement) {
        this.cleanupStatementResultSets(statement);
        this.uncachedActiveStatements.remove(statement);
    }

    synchronized void markActiveResultSetForStatement(Statement statement, ResultSet resultSet) {
        Set set = this.resultSets(statement, true);
        set.add(resultSet);
    }

    synchronized void markInactiveResultSetForStatement(Statement statement, ResultSet resultSet) {
        Set set = this.resultSets(statement, false);
        if (set == null) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("ResultSet " + resultSet + " was apparently closed after the Statement that created it had already been closed.");
            }
        } else if (!set.remove(resultSet)) {
            throw new InternalError("Marking a ResultSet inactive that we did not know was opened!");
        }
    }

    synchronized void markActiveRawConnectionResultSet(ResultSet resultSet) {
        if (this.rawConnectionResultSets == null) {
            this.rawConnectionResultSets = new HashSet();
        }
        this.rawConnectionResultSets.add(resultSet);
    }

    synchronized void markInactiveRawConnectionResultSet(ResultSet resultSet) {
        if (!this.rawConnectionResultSets.remove(resultSet)) {
            throw new InternalError("Marking a raw Connection ResultSet inactive that we did not know was opened!");
        }
    }

    synchronized void markActiveMetaDataResultSet(ResultSet resultSet) {
        this.metaDataResultSets.add(resultSet);
    }

    synchronized void markInactiveMetaDataResultSet(ResultSet resultSet) {
        this.metaDataResultSets.remove(resultSet);
    }

    synchronized void markClosedProxyConnection(NewProxyConnection newProxyConnection, boolean bl) {
        try {
            if (newProxyConnection != this.exposedProxy) {
                throw new InternalError("C3P0 Error: An exposed proxy asked a PooledConnection that was not its parents to clean up its resources!");
            }
            LinkedList linkedList = new LinkedList();
            this.cleanupResultSets(linkedList);
            this.cleanupUncachedStatements(linkedList);
            this.checkinAllCachedStatements(linkedList);
            if (linkedList.size() > 0) {
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.info("[c3p0] The following Exceptions occurred while trying to clean up a Connection's stranded resources:");
                }
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    Throwable throwable = (Throwable)iterator.next();
                    if (!logger.isLoggable(MLevel.INFO)) continue;
                    logger.log(MLevel.INFO, "[c3p0 -- conection resource close Exception]", throwable);
                }
            }
            this.reset(bl);
            this.fireConnectionClosed();
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "An exception occurred while reseting a closed Connection. Invalidating Connection.", sQLException);
            }
            this.updateConnectionStatus(-1);
            this.fireConnectionErrorOccurred(sQLException);
        }
    }

    private void reset(boolean bl) throws SQLException {
        block9: {
            block8: {
                C3P0ImplUtils.resetTxnState(this.physicalConnection, this.forceIgnoreUnresolvedTransactions, this.autoCommitOnClose, bl);
                if (this.isolation_lvl_nondefault) {
                    this.physicalConnection.setTransactionIsolation(this.dflt_txn_isolation);
                    this.isolation_lvl_nondefault = false;
                }
                if (this.catalog_nondefault) {
                    this.physicalConnection.setCatalog(this.dflt_catalog);
                    this.catalog_nondefault = false;
                }
                if (this.holdability_nondefault) {
                    this.physicalConnection.setHoldability(this.dflt_holdability);
                    this.holdability_nondefault = false;
                }
                try {
                    this.physicalConnection.setReadOnly(false);
                }
                catch (Throwable throwable) {
                    if (!logger.isLoggable(MLevel.FINE)) break block8;
                    logger.log(MLevel.FINE, "A Throwable occurred while trying to reset the readOnly property of our Connection to false!", throwable);
                }
            }
            try {
                if (this.supports_setTypeMap) {
                    this.physicalConnection.setTypeMap(Collections.EMPTY_MAP);
                }
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(MLevel.FINE)) break block9;
                logger.log(MLevel.FINE, "A Throwable occurred while trying to reset the typeMap property of our Connection to Collections.EMPTY_MAP!", throwable);
            }
        }
    }

    synchronized boolean isStatementCaching() {
        return this.scache != null;
    }

    synchronized SQLException handleThrowable(Throwable throwable) {
        if (logger.isLoggable(MLevel.FINER)) {
            logger.log(MLevel.FINER, this + " handling a throwable.", throwable);
        }
        SQLException sQLException = SqlUtils.toSQLException(throwable);
        int n = this.connectionTester.statusOnException(this.physicalConnection, sQLException);
        this.updateConnectionStatus(n);
        if (n != 0) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, this + " invalidated by Exception.", throwable);
            }
            if (!this.connection_error_signaled) {
                this.ces.fireConnectionErrorOccurred(sQLException);
                this.connection_error_signaled = true;
            } else if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "[c3p0] A PooledConnection that has already signalled a Connection error is still in use!");
                logger.log(MLevel.WARNING, "[c3p0] Another error has occurred [ " + throwable + " ] which will not be reported to listeners!", throwable);
            }
        }
        return sQLException;
    }

    private void fireConnectionClosed() {
        this.exposedProxy = null;
        this.ces.fireConnectionClosed();
    }

    private void fireConnectionErrorOccurred(SQLException sQLException) {
        this.ces.fireConnectionErrorOccurred(sQLException);
    }

    private void close(Throwable throwable) throws SQLException {
        if (this.invalidatingException == null) {
            LinkedList<SQLException> linkedList = new LinkedList<SQLException>();
            this.cleanupResultSets(linkedList);
            this.cleanupUncachedStatements(linkedList);
            try {
                this.closeAllCachedStatements();
            }
            catch (SQLException sQLException) {
                linkedList.add(sQLException);
            }
            try {
                this.physicalConnection.close();
            }
            catch (SQLException sQLException) {
                linkedList.add(sQLException);
            }
            if (this.connection_status == 0) {
                this.connection_status = -1;
            }
            if (throwable == null) {
                this.invalidatingException = new SQLException(this + " explicitly closed!");
                NewPooledConnection.logCloseExceptions(null, linkedList);
                if (linkedList.size() > 0) {
                    throw new SQLException("Some resources failed to close properly while closing " + this);
                }
            } else {
                this.invalidatingException = throwable;
                NewPooledConnection.logCloseExceptions(throwable, linkedList);
            }
        }
    }

    private void cleanupResultSets(List list) {
        this.cleanupAllStatementResultSets(list);
        this.cleanupUnclosedResultSetsSet(this.metaDataResultSets, list);
        if (this.rawConnectionResultSets != null) {
            this.cleanupUnclosedResultSetsSet(this.rawConnectionResultSets, list);
        }
    }

    private void cleanupUnclosedResultSetsSet(Set set, List list) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ResultSet resultSet = (ResultSet)iterator.next();
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                list.add(sQLException);
            }
            iterator.remove();
        }
    }

    private void cleanupStatementResultSets(Statement statement) {
        Set set = this.resultSets(statement, false);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    ((ResultSet)iterator.next()).close();
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(MLevel.INFO)) continue;
                    logger.log(MLevel.INFO, "ResultSet close() failed.", exception);
                }
            }
        }
        this.resultSetsForStatements.remove(statement);
    }

    private void cleanupAllStatementResultSets(List list) {
        Iterator iterator = this.resultSetsForStatements.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Set set = (Set)this.resultSetsForStatements.get(k);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                ResultSet resultSet = (ResultSet)iterator2.next();
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    list.add(sQLException);
                }
            }
        }
        this.resultSetsForStatements.clear();
    }

    private void cleanupUncachedStatements(List list) {
        Iterator iterator = this.uncachedActiveStatements.iterator();
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                list.add(sQLException);
            }
            iterator.remove();
        }
    }

    private void checkinAllCachedStatements(List list) {
        try {
            if (this.scache != null) {
                this.scache.checkinAll(this.physicalConnection);
            }
        }
        catch (SQLException sQLException) {
            list.add(sQLException);
        }
    }

    private void closeAllCachedStatements() throws SQLException {
        if (this.scache != null) {
            this.scache.closeAll(this.physicalConnection);
        }
    }

    private void updateConnectionStatus(int n) {
        switch (this.connection_status) {
            case -8: {
                break;
            }
            case -1: {
                if (n != -8) break;
                this.connection_status = n;
                break;
            }
            case 0: {
                if (n == 0) break;
                this.connection_status = n;
                break;
            }
            default: {
                throw new InternalError(this + " -- Illegal Connection Status: " + this.connection_status);
            }
        }
    }

    private Set resultSets(Statement statement, boolean bl) {
        HashSet hashSet = (HashSet)this.resultSetsForStatements.get(statement);
        if (hashSet == null && bl) {
            hashSet = new HashSet();
            this.resultSetsForStatements.put(statement, hashSet);
        }
        return hashSet;
    }

    private static void logCloseExceptions(Throwable throwable, Collection collection) {
        if (logger.isLoggable(MLevel.INFO)) {
            if (throwable != null) {
                logger.log(MLevel.INFO, "[c3p0] A PooledConnection died due to the following error!", throwable);
            }
            if (collection != null && collection.size() > 0) {
                if (throwable == null) {
                    logger.info("[c3p0] Exceptions occurred while trying to close a PooledConnection's resources normally.");
                } else {
                    logger.info("[c3p0] Exceptions occurred while trying to close a Broken PooledConnection.");
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Throwable throwable2 = (Throwable)iterator.next();
                    logger.log(MLevel.INFO, "[c3p0] NewPooledConnection close Exception.", throwable2);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

