/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.ThreadPoolAsynchronousRunner;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.stmt.DoubleMaxStatementCache;
import com.mchange.v2.c3p0.stmt.GlobalMaxOnlyStatementCache;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.stmt.PerConnectionMaxOnlyStatementCache;
import com.mchange.v2.coalesce.CoalesceChecker;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPoolManager {
    private static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager = C3P0PooledConnectionPoolManager.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager);
    private static final boolean POOL_EVENT_SUPPORT = false;
    private static final CoalesceChecker COALESCE_CHECKER = new CoalesceChecker(){

        public boolean checkCoalesce(Object object, Object object2) {
            C3P0PooledConnectionPoolManager c3P0PooledConnectionPoolManager = (C3P0PooledConnectionPoolManager)object;
            C3P0PooledConnectionPoolManager c3P0PooledConnectionPoolManager2 = (C3P0PooledConnectionPoolManager)object2;
            return c3P0PooledConnectionPoolManager.poolOwnerIdentityToken.equals(c3P0PooledConnectionPoolManager2.poolOwnerIdentityToken) && (c3P0PooledConnectionPoolManager.preferredTestQuery == null ? c3P0PooledConnectionPoolManager2.preferredTestQuery == null : c3P0PooledConnectionPoolManager.preferredTestQuery.equals(c3P0PooledConnectionPoolManager2.preferredTestQuery)) && (c3P0PooledConnectionPoolManager.automaticTestTable == null ? c3P0PooledConnectionPoolManager2.automaticTestTable == null : c3P0PooledConnectionPoolManager.automaticTestTable.equals(c3P0PooledConnectionPoolManager2.automaticTestTable)) && c3P0PooledConnectionPoolManager.sourceCpdsIdentityToken.equals(c3P0PooledConnectionPoolManager2.sourceCpdsIdentityToken) && c3P0PooledConnectionPoolManager.num_task_threads == c3P0PooledConnectionPoolManager2.num_task_threads && c3P0PooledConnectionPoolManager.maxStatements == c3P0PooledConnectionPoolManager2.maxStatements && c3P0PooledConnectionPoolManager.maxStatementsPerConnection == c3P0PooledConnectionPoolManager2.maxStatementsPerConnection && c3P0PooledConnectionPoolManager.minPoolSize == c3P0PooledConnectionPoolManager2.minPoolSize && c3P0PooledConnectionPoolManager.idleConnectionTestPeriod == c3P0PooledConnectionPoolManager2.idleConnectionTestPeriod && c3P0PooledConnectionPoolManager.maxIdleTime == c3P0PooledConnectionPoolManager2.maxIdleTime && c3P0PooledConnectionPoolManager.checkoutTimeout == c3P0PooledConnectionPoolManager2.checkoutTimeout && c3P0PooledConnectionPoolManager.acquireIncrement == c3P0PooledConnectionPoolManager2.acquireIncrement && c3P0PooledConnectionPoolManager.acquireRetryAttempts == c3P0PooledConnectionPoolManager2.acquireRetryAttempts && c3P0PooledConnectionPoolManager.acquireRetryDelay == c3P0PooledConnectionPoolManager2.acquireRetryDelay && c3P0PooledConnectionPoolManager.breakAfterAcquireFailure == c3P0PooledConnectionPoolManager2.breakAfterAcquireFailure && c3P0PooledConnectionPoolManager.testConnectionOnCheckout == c3P0PooledConnectionPoolManager2.testConnectionOnCheckout && c3P0PooledConnectionPoolManager.testConnectionOnCheckin == c3P0PooledConnectionPoolManager2.testConnectionOnCheckin && c3P0PooledConnectionPoolManager.autoCommitOnClose == c3P0PooledConnectionPoolManager2.autoCommitOnClose && c3P0PooledConnectionPoolManager.forceIgnoreUnresolvedTransactions == c3P0PooledConnectionPoolManager2.forceIgnoreUnresolvedTransactions && c3P0PooledConnectionPoolManager.defaultAuth.equals(c3P0PooledConnectionPoolManager2.defaultAuth) && c3P0PooledConnectionPoolManager.connectionTester.getClass().equals(c3P0PooledConnectionPoolManager2.connectionTester.getClass());
        }

        public int coalesceHash(Object object) {
            C3P0PooledConnectionPoolManager c3P0PooledConnectionPoolManager = (C3P0PooledConnectionPoolManager)object;
            int n = c3P0PooledConnectionPoolManager.poolOwnerIdentityToken.hashCode() ^ (c3P0PooledConnectionPoolManager.preferredTestQuery == null ? 0 : c3P0PooledConnectionPoolManager.preferredTestQuery.hashCode()) ^ (c3P0PooledConnectionPoolManager.automaticTestTable == null ? 0 : c3P0PooledConnectionPoolManager.automaticTestTable.hashCode()) ^ c3P0PooledConnectionPoolManager.sourceCpdsIdentityToken.hashCode() ^ c3P0PooledConnectionPoolManager.num_task_threads ^ c3P0PooledConnectionPoolManager.maxStatements ^ c3P0PooledConnectionPoolManager.maxStatementsPerConnection ^ c3P0PooledConnectionPoolManager.minPoolSize ^ c3P0PooledConnectionPoolManager.idleConnectionTestPeriod ^ c3P0PooledConnectionPoolManager.maxIdleTime ^ c3P0PooledConnectionPoolManager.checkoutTimeout ^ c3P0PooledConnectionPoolManager.acquireIncrement ^ c3P0PooledConnectionPoolManager.acquireRetryAttempts ^ c3P0PooledConnectionPoolManager.acquireRetryDelay ^ (c3P0PooledConnectionPoolManager.testConnectionOnCheckout ? 1 : 0) ^ (c3P0PooledConnectionPoolManager.testConnectionOnCheckin ? 2 : 0) ^ (c3P0PooledConnectionPoolManager.autoCommitOnClose ? 4 : 0) ^ (c3P0PooledConnectionPoolManager.forceIgnoreUnresolvedTransactions ? 8 : 0) ^ (c3P0PooledConnectionPoolManager.breakAfterAcquireFailure ? 16 : 0) ^ c3P0PooledConnectionPoolManager.defaultAuth.hashCode() ^ c3P0PooledConnectionPoolManager.connectionTester.getClass().hashCode();
            return n;
        }
    };
    static final Coalescer COALESCER = CoalescerFactory.createCoalescer(COALESCE_CHECKER, true, false);
    static final int DFLT_NUM_TASK_THREADS_PER_DATA_SOURCE = 3;
    Set activeClients = new HashSet();
    ThreadPoolAsynchronousRunner taskRunner;
    Timer timer;
    ResourcePoolFactory rpfact;
    GooGooStatementCache scache;
    Map authsToPools;
    boolean is_first_pool = true;
    String realTestQuery;
    String poolOwnerIdentityToken = null;
    final ConnectionPoolDataSource cpds;
    final String sourceCpdsIdentityToken;
    int num_task_threads = 3;
    int maxStatements = PoolConfig.defaultMaxStatements();
    int maxStatementsPerConnection = PoolConfig.defaultMaxStatementsPerConnection();
    int minPoolSize = PoolConfig.defaultMinPoolSize();
    int maxPoolSize = PoolConfig.defaultMaxPoolSize();
    int idleConnectionTestPeriod = PoolConfig.defaultIdleConnectionTestPeriod();
    int maxIdleTime = PoolConfig.defaultMaxIdleTime();
    int checkoutTimeout = PoolConfig.defaultCheckoutTimeout();
    int acquireIncrement = PoolConfig.defaultAcquireIncrement();
    int acquireRetryAttempts = PoolConfig.defaultAcquireRetryAttempts();
    int acquireRetryDelay = PoolConfig.defaultAcquireRetryDelay();
    boolean breakAfterAcquireFailure = PoolConfig.defaultBreakAfterAcquireFailure();
    boolean testConnectionOnCheckout = PoolConfig.defaultTestConnectionOnCheckout();
    boolean testConnectionOnCheckin = PoolConfig.defaultTestConnectionOnCheckin();
    boolean autoCommitOnClose = PoolConfig.defaultAutoCommitOnClose();
    boolean forceIgnoreUnresolvedTransactions = PoolConfig.defaultForceIgnoreUnresolvedTransactions();
    String preferredTestQuery = PoolConfig.defaultPreferredTestQuery();
    String automaticTestTable = PoolConfig.defaultAutomaticTestTable();
    DbAuth defaultAuth = C3P0ImplUtils.NULL_AUTH;
    ConnectionTester connectionTester = C3P0ImplUtils.defaultConnectionTester();
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager;
    static /* synthetic */ Class class$java$lang$String;

    private synchronized void poolsInit() {
        this.timer = new Timer(true);
        this.taskRunner = new ThreadPoolAsynchronousRunner(this.num_task_threads, true, this.timer);
        this.rpfact = BasicResourcePoolFactory.createNoEventSupportInstance(this.taskRunner, this.timer);
        this.scache = this.maxStatements > 0 && this.maxStatementsPerConnection > 0 ? new DoubleMaxStatementCache(this.taskRunner, this.maxStatements, this.maxStatementsPerConnection) : (this.maxStatementsPerConnection > 0 ? new PerConnectionMaxOnlyStatementCache(this.taskRunner, this.maxStatementsPerConnection) : (this.maxStatements > 0 ? new GlobalMaxOnlyStatementCache(this.taskRunner, this.maxStatements) : null));
        this.authsToPools = new HashMap();
    }

    private synchronized void poolsDestroy() {
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((C3P0PooledConnectionPool)iterator.next()).close();
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to clean up a pool!", exception);
            }
        }
        this.taskRunner.close(true);
        this.timer.cancel();
        try {
            if (this.scache != null) {
                this.scache.close();
            }
        }
        catch (SQLException sQLException) {
            logger.log(MLevel.WARNING, "An Exception occurred while trying to clean up a Statement cache!", sQLException);
        }
        this.scache = null;
        this.taskRunner = null;
        this.timer = null;
        this.rpfact = null;
        this.authsToPools = null;
    }

    public static synchronized C3P0PooledConnectionPoolManager find(String string, ConnectionPoolDataSource connectionPoolDataSource, String string2, int n) throws SQLException {
        C3P0PooledConnectionPoolManager c3P0PooledConnectionPoolManager = new C3P0PooledConnectionPoolManager(string, connectionPoolDataSource, string2, n);
        C3P0PooledConnectionPoolManager c3P0PooledConnectionPoolManager2 = (C3P0PooledConnectionPoolManager)COALESCER.coalesce(c3P0PooledConnectionPoolManager);
        if (c3P0PooledConnectionPoolManager2 == c3P0PooledConnectionPoolManager) {
            c3P0PooledConnectionPoolManager2.poolsInit();
        }
        return c3P0PooledConnectionPoolManager2;
    }

    private C3P0PooledConnectionPoolManager(String string, ConnectionPoolDataSource connectionPoolDataSource, String string2, int n) throws SQLException {
        try {
            this.poolOwnerIdentityToken = string;
            this.cpds = connectionPoolDataSource;
            this.sourceCpdsIdentityToken = string2;
            this.num_task_threads = n;
            this.defaultAuth = C3P0ImplUtils.findAuth(connectionPoolDataSource);
            BeanInfo beanInfo = Introspector.getBeanInfo(connectionPoolDataSource.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n2 = propertyDescriptorArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3;
                Object object;
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                Class<?> clazz = propertyDescriptor.getPropertyType();
                String string3 = propertyDescriptor.getName();
                Method method = propertyDescriptor.getReadMethod();
                if (clazz == Integer.TYPE) {
                    object = method.invoke((Object)connectionPoolDataSource, C3P0ImplUtils.NOARGS);
                    n3 = (Integer)object;
                    if ("maxStatements".equals(string3)) {
                        this.maxStatements = n3;
                        continue;
                    }
                    if ("maxStatementsPerConnection".equals(string3)) {
                        this.maxStatementsPerConnection = n3;
                        continue;
                    }
                    if ("minPoolSize".equals(string3)) {
                        this.minPoolSize = n3;
                        continue;
                    }
                    if ("maxPoolSize".equals(string3)) {
                        this.maxPoolSize = n3;
                        continue;
                    }
                    if ("idleConnectionTestPeriod".equals(string3)) {
                        this.idleConnectionTestPeriod = n3;
                        continue;
                    }
                    if ("maxIdleTime".equals(string3)) {
                        this.maxIdleTime = n3;
                        continue;
                    }
                    if ("checkoutTimeout".equals(string3)) {
                        this.checkoutTimeout = n3;
                        continue;
                    }
                    if ("acquireIncrement".equals(string3)) {
                        this.acquireIncrement = n3;
                        continue;
                    }
                    if ("acquireRetryAttempts".equals(string3)) {
                        this.acquireRetryAttempts = n3;
                        continue;
                    }
                    if (!"acquireRetryDelay".equals(string3)) continue;
                    this.acquireRetryDelay = n3;
                    continue;
                }
                if (clazz == (class$java$lang$String == null ? C3P0PooledConnectionPoolManager.class$("java.lang.String") : class$java$lang$String)) {
                    object = method.invoke((Object)connectionPoolDataSource, C3P0ImplUtils.NOARGS);
                    String string4 = (String)object;
                    if ("connectionTesterClassName".equals(string3)) {
                        this.connectionTester = (ConnectionTester)Class.forName(string4).newInstance();
                        continue;
                    }
                    if ("preferredTestQuery".equals(string3)) {
                        this.preferredTestQuery = string4;
                        continue;
                    }
                    if (!"automaticTestTable".equals(string3)) continue;
                    this.automaticTestTable = string4;
                    continue;
                }
                if (clazz != Boolean.TYPE) continue;
                object = method.invoke((Object)connectionPoolDataSource, C3P0ImplUtils.NOARGS);
                n3 = ((Boolean)object).booleanValue() ? 1 : 0;
                if ("testConnectionOnCheckout".equals(string3)) {
                    this.testConnectionOnCheckout = n3;
                    continue;
                }
                if ("testConnectionOnCheckin".equals(string3)) {
                    this.testConnectionOnCheckin = n3;
                    continue;
                }
                if ("autoCommitOnClose".equals(string3)) {
                    this.autoCommitOnClose = n3;
                    continue;
                }
                if ("forceIgnoreUnresolvedTransactions".equals(string3)) {
                    this.forceIgnoreUnresolvedTransactions = n3;
                    continue;
                }
                if (!"breakAfterAcquireFailure".equals(string3)) continue;
                this.breakAfterAcquireFailure = n3;
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.FINE, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public synchronized C3P0PooledConnectionPool getPool(String string, String string2) throws SQLException {
        return this.getPool(new DbAuth(string, string2));
    }

    public synchronized C3P0PooledConnectionPool getPool(DbAuth dbAuth) throws SQLException {
        C3P0PooledConnectionPool c3P0PooledConnectionPool = (C3P0PooledConnectionPool)this.authsToPools.get(dbAuth);
        if (c3P0PooledConnectionPool == null) {
            c3P0PooledConnectionPool = this.createPooledConnectionPool(dbAuth);
            this.authsToPools.put(dbAuth, c3P0PooledConnectionPool);
        }
        return c3P0PooledConnectionPool;
    }

    public synchronized int getNumManagedAuths() {
        return this.authsToPools.size();
    }

    public C3P0PooledConnectionPool getPool() throws SQLException {
        return this.getPool(this.defaultAuth);
    }

    public synchronized int getNumIdleConnectionsAllAuths() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getNumIdleConnections();
        }
        return n;
    }

    public synchronized int getNumBusyConnectionsAllAuths() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getNumBusyConnections();
        }
        return n;
    }

    public synchronized int getNumConnectionsAllAuths() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getNumConnections();
        }
        return n;
    }

    public synchronized int getNumUnclosedOrphanedConnectionsAllAuths() throws SQLException {
        int n = 0;
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            n += ((C3P0PooledConnectionPool)iterator.next()).getNumUnclosedOrphanedConnections();
        }
        return n;
    }

    public synchronized void softResetAllAuths() throws SQLException {
        Iterator iterator = this.authsToPools.values().iterator();
        while (iterator.hasNext()) {
            ((C3P0PooledConnectionPool)iterator.next()).reset();
        }
    }

    public synchronized void close() {
        if (this.authsToPools != null) {
            this.poolsDestroy();
        }
    }

    protected synchronized void finalize() {
        this.close();
    }

    private C3P0PooledConnectionPool createPooledConnectionPool(DbAuth dbAuth) throws SQLException {
        if (this.is_first_pool) {
            if (this.automaticTestTable != null) {
                this.realTestQuery = this.initializeAutomaticTestTable();
                if (this.preferredTestQuery != null && logger.isLoggable(MLevel.WARNING)) {
                    logger.logp(MLevel.WARNING, (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager = C3P0PooledConnectionPoolManager.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPoolManager).getName(), "createPooledConnectionPool", "[c3p0] Both automaticTestTable and preferredTestQuery have been set! Using automaticTestTable, and ignoring preferredTestQuery. Real test query is ''{0}''.", this.realTestQuery);
                }
            } else {
                this.realTestQuery = this.preferredTestQuery;
            }
        }
        C3P0PooledConnectionPool c3P0PooledConnectionPool = new C3P0PooledConnectionPool(this.cpds, dbAuth, this.minPoolSize, this.maxPoolSize, this.acquireIncrement, this.acquireRetryAttempts, this.acquireRetryDelay, this.breakAfterAcquireFailure, this.checkoutTimeout, this.idleConnectionTestPeriod, this.maxIdleTime, this.testConnectionOnCheckout, this.testConnectionOnCheckin, this.scache, this.connectionTester, this.realTestQuery, this.rpfact);
        this.is_first_pool = false;
        return c3P0PooledConnectionPool;
    }

    public synchronized void registerActiveClient(Object object) {
        this.activeClients.add(object);
        if (this.authsToPools == null) {
            this.poolsInit();
        }
    }

    public synchronized void unregisterActiveClient(Object object) {
        this.activeClients.remove(object);
        if (this.activeClients.size() == 0) {
            this.close();
        }
    }

    public synchronized void forceDestroy() {
        if (this.activeClients.size() > 0) {
            this.activeClients.clear();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String initializeAutomaticTestTable() throws SQLException {
        String string;
        PooledConnection pooledConnection = this.cpds.getPooledConnection();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement preparedStatement2 = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        try {
            connection = pooledConnection.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string2 = databaseMetaData.getIdentifierQuoteString();
            String string3 = string2 + this.automaticTestTable + string2;
            String string4 = "SELECT * FROM " + string3;
            resultSet = databaseMetaData.getTables(null, null, this.automaticTestTable, new String[]{"TABLE"});
            boolean bl = resultSet.next();
            if (bl) {
                preparedStatement = connection.prepareStatement(string4);
                resultSet2 = preparedStatement.executeQuery();
                boolean bl2 = resultSet2.next();
                if (bl2) {
                    throw new SQLException("automatic test table '" + this.automaticTestTable + "' contains rows, and it should not! Please set this " + "parameter to the name of a table c3p0 can create on its own, " + "that is not used elsewhere in the database!");
                }
            } else {
                preparedStatement2 = connection.prepareStatement("CREATE TABLE " + string3 + " ( a CHAR(1) )");
                preparedStatement2.executeUpdate();
            }
            string = string4;
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            ResultSetUtils.attemptClose(resultSet);
            ResultSetUtils.attemptClose(resultSet2);
            StatementUtils.attemptClose(preparedStatement);
            StatementUtils.attemptClose(preparedStatement2);
            ConnectionUtils.attemptClose(connection);
            try {
                if (pooledConnection != null) {
                    pooledConnection.close();
                }
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "A PooledConnection failed to close.", exception);
            }
            throw throwable;
        }
        ResultSetUtils.attemptClose(resultSet);
        ResultSetUtils.attemptClose(resultSet2);
        StatementUtils.attemptClose(preparedStatement);
        StatementUtils.attemptClose(preparedStatement2);
        ConnectionUtils.attemptClose(connection);
        try {
            if (pooledConnection != null) {
                pooledConnection.close();
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, "A PooledConnection failed to close.", exception);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

