/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.QueryConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolFactory;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class C3P0PooledConnectionPool {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool = C3P0PooledConnectionPool.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnectionPool")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool);
    ResourcePool rp;
    ConnectionEventListener cl = new ConnectionEventListenerImpl();
    ConnectionTester connectionTester;
    GooGooStatementCache scache;
    int checkoutTimeout;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnectionPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C3P0PooledConnectionPool(final ConnectionPoolDataSource connectionPoolDataSource, final DbAuth dbAuth, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7, int n8, final boolean bl2, final boolean bl3, GooGooStatementCache gooGooStatementCache, final ConnectionTester connectionTester, final String string, ResourcePoolFactory resourcePoolFactory) throws SQLException {
        try {
            this.scache = gooGooStatementCache;
            this.connectionTester = connectionTester;
            this.checkoutTimeout = n6;
            ResourcePool.Manager manager = new ResourcePool.Manager(){

                public Object acquireResource() throws Exception {
                    PooledConnection pooledConnection;
                    PooledConnection pooledConnection2 = pooledConnection = dbAuth.equals(C3P0ImplUtils.NULL_AUTH) ? connectionPoolDataSource.getPooledConnection() : connectionPoolDataSource.getPooledConnection(dbAuth.getUser(), dbAuth.getPassword());
                    if (C3P0PooledConnectionPool.this.scache != null) {
                        if (pooledConnection instanceof C3P0PooledConnection) {
                            ((C3P0PooledConnection)pooledConnection).initStatementCache(C3P0PooledConnectionPool.this.scache);
                        } else if (pooledConnection instanceof NewPooledConnection) {
                            ((NewPooledConnection)pooledConnection).initStatementCache(C3P0PooledConnectionPool.this.scache);
                        } else {
                            logger.warning("StatementPooling not implemented for external (non-c3p0) ConnectionPoolDataSources.");
                        }
                    }
                    pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    return pooledConnection;
                }

                public void refurbishResourceOnCheckout(Object object) throws Exception {
                    if (bl2) {
                        this.testPooledConnection(object);
                    }
                }

                public void refurbishResourceOnCheckin(Object object) throws Exception {
                    if (bl3) {
                        this.testPooledConnection(object);
                    }
                }

                public void refurbishIdleResource(Object object) throws Exception {
                    this.testPooledConnection(object);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void testPooledConnection(Object object) throws Exception {
                    int n;
                    SQLException sQLException;
                    Connection connection;
                    PooledConnection pooledConnection;
                    block11: {
                        pooledConnection = (PooledConnection)object;
                        connection = null;
                        sQLException = null;
                        try {
                            pooledConnection.removeConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                            connection = pooledConnection.getConnection();
                            if (string == null) {
                                n = connectionTester.activeCheckConnection(connection);
                                break block11;
                            }
                            if (connectionTester instanceof QueryConnectionTester) {
                                n = ((QueryConnectionTester)connectionTester).activeCheckConnection(connection, string);
                                break block11;
                            }
                            logger.warning("[c3p0] testQuery '" + string + "' ignored. Please set a ConnectionTester that implements " + "com.mchange.v2.c3p0.advanced.QueryConnectionTester, or use the " + "DefaultConnectionTester, to test with the testQuery.");
                            n = connectionTester.activeCheckConnection(connection);
                        }
                        catch (SQLException sQLException2) {
                            try {
                                logger.log(MLevel.FINE, "A Connection test failed with an Exception.", sQLException2);
                                n = -1;
                                sQLException = sQLException2;
                            }
                            catch (Throwable throwable) {
                                ConnectionUtils.attemptClose(connection);
                                pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                                throw throwable;
                            }
                            ConnectionUtils.attemptClose(connection);
                            pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                        }
                    }
                    ConnectionUtils.attemptClose(connection);
                    pooledConnection.addConnectionEventListener(C3P0PooledConnectionPool.this.cl);
                    switch (n) {
                        case 0: {
                            break;
                        }
                        case -8: {
                            C3P0PooledConnectionPool.this.rp.resetPool();
                        }
                        case -1: {
                            SQLException sQLException3 = sQLException == null ? new SQLException("Connection is invalid") : SqlUtils.toSQLException("Connection is invalid", sQLException);
                            throw sQLException3;
                        }
                        default: {
                            throw new Error("Bad Connection Tester (" + connectionTester + ") " + "returned invalid status (" + n + ").");
                        }
                    }
                }

                public void destroyResource(Object object) throws Exception {
                    ((PooledConnection)object).close();
                }
            };
            ResourcePoolFactory resourcePoolFactory2 = resourcePoolFactory;
            synchronized (resourcePoolFactory2) {
                resourcePoolFactory.setMin(n);
                resourcePoolFactory.setMax(n2);
                resourcePoolFactory.setIncrement(n3);
                resourcePoolFactory.setIdleResourceTestPeriod(n7 * 1000);
                resourcePoolFactory.setResourceMaxAge(n8 * 1000);
                resourcePoolFactory.setAcquisitionRetryAttempts(n4);
                resourcePoolFactory.setAcquisitionRetryDelay(n5);
                resourcePoolFactory.setBreakOnAcquisitionFailure(bl);
                resourcePoolFactory.setAgeIsAbsolute(false);
                this.rp = resourcePoolFactory.createPool(manager);
            }
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public PooledConnection checkoutPooledConnection() throws SQLException {
        try {
            return (PooledConnection)this.rp.checkoutResource(this.checkoutTimeout);
        }
        catch (TimeoutException timeoutException) {
            throw SqlUtils.toSQLException("An attempt by a client to checkout a Connection has timed out.", timeoutException);
        }
        catch (CannotAcquireResourceException cannotAcquireResourceException) {
            throw SqlUtils.toSQLException("Connections could not be acquired from the underlying database!", "08001", cannotAcquireResourceException);
        }
        catch (Exception exception) {
            throw SqlUtils.toSQLException(exception);
        }
    }

    public void checkinPooledConnection(PooledConnection pooledConnection) throws SQLException {
        try {
            this.rp.checkinResource(pooledConnection);
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public void close() throws SQLException {
        try {
            this.rp.close();
        }
        catch (ResourcePoolException resourcePoolException) {
            throw SqlUtils.toSQLException(resourcePoolException);
        }
    }

    public int getNumConnections() throws SQLException {
        try {
            return this.rp.getPoolSize();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumIdleConnections() throws SQLException {
        try {
            return this.rp.getAvailableCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumBusyConnections() throws SQLException {
        try {
            ResourcePool resourcePool = this.rp;
            synchronized (resourcePool) {
                return this.rp.getAwaitingCheckinCount() - this.rp.getExcludedCount();
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        try {
            return this.rp.getExcludedCount();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    public void reset() throws SQLException {
        try {
            this.rp.resetPool();
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, null, exception);
            throw SqlUtils.toSQLException(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConnectionEventListenerImpl
    implements ConnectionEventListener {
        ConnectionEventListenerImpl() {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            try {
                C3P0PooledConnectionPool.this.rp.checkinResource(connectionEvent.getSource());
            }
            catch (Exception exception) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to check a PooledConection into a ResourcePool.", exception);
            }
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("CONNECTION ERROR OCCURRED!");
            }
            try {
                PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
                int n = pooledConnection instanceof C3P0PooledConnection ? ((C3P0PooledConnection)pooledConnection).getConnectionStatus() : (pooledConnection instanceof NewPooledConnection ? ((NewPooledConnection)pooledConnection).getConnectionStatus() : -1);
                switch (n) {
                    case 0: {
                        throw new InternalError("connectionErrorOcccurred() should only be called for errors fatal to the Connection.");
                    }
                    case -1: {
                        C3P0PooledConnectionPool.this.rp.markBroken(pooledConnection);
                        break;
                    }
                    case -8: {
                        C3P0PooledConnectionPool.this.rp.resetPool();
                        break;
                    }
                    default: {
                        throw new InternalError("Bad Connection Tester (" + C3P0PooledConnectionPool.this.connectionTester + ") " + "returned invalid status (" + n + ").");
                    }
                }
            }
            catch (ResourcePoolException resourcePoolException) {
                logger.log(MLevel.WARNING, "Uh oh... our resource pool is probably broken!", resourcePoolException);
            }
        }
    }
}

