/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.util.ClosableResource;
import com.mchange.v2.c3p0.C3P0ProxyConnection;
import com.mchange.v2.c3p0.C3P0ProxyStatement;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.NullStatementSetManagedResultSet;
import com.mchange.v2.c3p0.impl.SetManagedDatabaseMetaData;
import com.mchange.v2.c3p0.impl.SetManagedResultSet;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.util.ConnectionEventSupport;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.sql.filter.FilterCallableStatement;
import com.mchange.v2.sql.filter.FilterPreparedStatement;
import com.mchange.v2.sql.filter.FilterStatement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class C3P0PooledConnection
implements PooledConnection,
ClosableResource {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$impl$C3P0PooledConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection);
    static final ClassLoader CL = (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection).getClassLoader();
    static final Class[] PROXY_CTOR_ARGS = new Class[]{class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = C3P0PooledConnection.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler};
    static final Constructor CON_PROXY_CTOR;
    static final Method RS_CLOSE_METHOD;
    static final Method STMT_CLOSE_METHOD;
    static final Object[] CLOSE_ARGS;
    static final Set OBJECT_METHODS;
    final ConnectionTester connectionTester;
    final boolean autoCommitOnClose;
    final boolean forceIgnoreUnresolvedTransactions;
    final boolean supports_setTypeMap;
    final boolean supports_setHoldability;
    final int dflt_txn_isolation;
    final String dflt_catalog;
    final int dflt_holdability;
    final ConnectionEventSupport ces = new ConnectionEventSupport(this);
    volatile Connection physicalConnection;
    volatile Exception invalidatingException = null;
    ProxyConnection exposedProxy;
    int connection_status = 0;
    final Set uncachedActiveStatements = Collections.synchronizedSet(new HashSet());
    volatile GooGooStatementCache scache;
    volatile boolean isolation_lvl_nondefault = false;
    volatile boolean catalog_nondefault = false;
    volatile boolean holdability_nondefault = false;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnection;
    static /* synthetic */ Class class$java$lang$reflect$InvocationHandler;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    private static Constructor createProxyConstructor(Class clazz) throws NoSuchMethodException {
        Class[] classArray = new Class[]{clazz};
        Class<?> clazz2 = Proxy.getProxyClass(CL, classArray);
        return clazz2.getConstructor(PROXY_CTOR_ARGS);
    }

    public C3P0PooledConnection(Connection connection, ConnectionTester connectionTester, boolean bl, boolean bl2) throws SQLException {
        this.physicalConnection = connection;
        this.connectionTester = connectionTester;
        this.autoCommitOnClose = bl;
        this.forceIgnoreUnresolvedTransactions = bl2;
        this.supports_setTypeMap = C3P0ImplUtils.supportsMethod(connection, "setTypeMap", new Class[]{class$java$util$Map == null ? (class$java$util$Map = C3P0PooledConnection.class$("java.util.Map")) : class$java$util$Map});
        this.supports_setHoldability = C3P0ImplUtils.supportsMethod(connection, "setHoldability", new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = C3P0PooledConnection.class$("java.lang.Integer")) : class$java$lang$Integer});
        this.dflt_txn_isolation = connection.getTransactionIsolation();
        this.dflt_catalog = connection.getCatalog();
        this.dflt_holdability = this.supports_setHoldability ? connection.getHoldability() : 2;
    }

    Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    boolean isClosed() throws SQLException {
        return this.physicalConnection == null;
    }

    void initStatementCache(GooGooStatementCache gooGooStatementCache) {
        this.scache = gooGooStatementCache;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.exposedProxy != null) {
            logger.warning("c3p0 -- Uh oh... getConnection() was called on a PooledConnection when it had already provided a client with a Connection that has not yet been closed. This probably indicates a bug in the connection pool!!!");
            return this.exposedProxy;
        }
        return this.getCreateNewConnection();
    }

    private Connection getCreateNewConnection() throws SQLException {
        try {
            this.ensureOkay();
            this.exposedProxy = this.createProxyConnection();
            return this.exposedProxy;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            logger.log(MLevel.WARNING, "Failed to acquire connection!", exception);
            throw new SQLException("Failed to acquire connection!");
        }
    }

    public void closeAll() throws SQLException {
        if (this.scache != null) {
            this.scache.closeAll(this.physicalConnection);
        }
    }

    public void close() throws SQLException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close(boolean bl) throws SQLException {
        if (this.physicalConnection != null) {
            try {
                Exception exception;
                StringBuffer stringBuffer = null;
                if (bl) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("[ exceptions: ");
                }
                if ((exception = this.cleanupUncachedActiveStatements()) != null) {
                    if (bl) {
                        stringBuffer.append(exception.toString() + ' ');
                    } else {
                        logger.log(MLevel.WARNING, "An exception occurred while cleaning up uncached active Statements.", exception);
                    }
                }
                try {
                    if (this.exposedProxy != null) {
                        this.exposedProxy.silentClose(bl);
                    }
                }
                catch (Exception exception2) {
                    if (bl) {
                        stringBuffer.append(exception2.toString() + ' ');
                    } else {
                        logger.log(MLevel.WARNING, "An exception occurred.", exception);
                    }
                    exception = exception2;
                }
                try {
                    this.closeAll();
                }
                catch (Exception exception3) {
                    if (bl) {
                        stringBuffer.append(exception3.toString() + ' ');
                    } else {
                        logger.log(MLevel.WARNING, "An exception occurred.", exception);
                    }
                    exception = exception3;
                }
                try {
                    this.physicalConnection.close();
                }
                catch (Exception exception4) {
                    if (bl) {
                        stringBuffer.append(exception4.toString() + ' ');
                    } else {
                        logger.log(MLevel.WARNING, "An exception occurred.", exception);
                    }
                    exception4.printStackTrace();
                    exception = exception4;
                }
                if (exception != null) {
                    if (bl) {
                        stringBuffer.append(" ]");
                        logger.fine(this + ": while closing a PooledConnection known to be invalid, " + "  some exceptions occurred. This is probably not a problem: " + stringBuffer.toString());
                    } else {
                        throw new SQLException("At least one error occurred while attempting to close() the PooledConnection: " + exception);
                    }
                }
                logger.fine("C3P0PooledConnection closed. [" + this + ']');
            }
            finally {
                this.physicalConnection = null;
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.ces.addConnectionEventListener(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.ces.removeConnectionEventListener(connectionEventListener);
    }

    private void reset() throws SQLException {
        this.reset(false);
    }

    private void reset(boolean bl) throws SQLException {
        block9: {
            block8: {
                this.ensureOkay();
                C3P0ImplUtils.resetTxnState(this.physicalConnection, this.forceIgnoreUnresolvedTransactions, this.autoCommitOnClose, bl);
                if (this.isolation_lvl_nondefault) {
                    this.physicalConnection.setTransactionIsolation(this.dflt_txn_isolation);
                    this.isolation_lvl_nondefault = false;
                }
                if (this.catalog_nondefault) {
                    this.physicalConnection.setCatalog(this.dflt_catalog);
                    this.catalog_nondefault = false;
                }
                if (this.holdability_nondefault) {
                    this.physicalConnection.setHoldability(this.dflt_holdability);
                    this.holdability_nondefault = false;
                }
                try {
                    this.physicalConnection.setReadOnly(false);
                }
                catch (Throwable throwable) {
                    if (!logger.isLoggable(MLevel.FINE)) break block8;
                    logger.log(MLevel.FINE, "A Throwable occurred while trying to reset the readOnly property of our Connection to false!", throwable);
                }
            }
            try {
                if (this.supports_setTypeMap) {
                    this.physicalConnection.setTypeMap(Collections.EMPTY_MAP);
                }
            }
            catch (Throwable throwable) {
                if (!logger.isLoggable(MLevel.FINE)) break block9;
                logger.log(MLevel.FINE, "A Throwable occurred while trying to reset the typeMap property of our Connection to Collections.EMPTY_MAP!", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeAndRemoveResultSets(Set set) {
        boolean bl = true;
        Set set2 = set;
        synchronized (set2) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ResultSet resultSet = (ResultSet)iterator.next();
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    logger.log(MLevel.WARNING, "An exception occurred while cleaning up a ResultSet.", sQLException);
                    bl = false;
                }
                finally {
                    iterator.remove();
                }
            }
        }
        return bl;
    }

    void ensureOkay() throws SQLException {
        if (this.physicalConnection == null) {
            throw new SQLException(this.invalidatingException == null ? "Connection is closed or broken." : "Connection is broken. Invalidating Exception: " + this.invalidatingException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeAndRemoveResourcesInSet(Set set, Method method) {
        HashSet hashSet;
        boolean bl = true;
        Object object = set;
        synchronized (object) {
            hashSet = new HashSet(set);
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            try {
                method.invoke(e, CLOSE_ARGS);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)exception).getTargetException();
                }
                logger.log(MLevel.WARNING, "An exception occurred while cleaning up a resource.", throwable);
                bl = false;
            }
            finally {
                set.remove(e);
            }
        }
        return bl;
    }

    private SQLException cleanupUncachedActiveStatements() {
        boolean bl = this.closeAndRemoveResourcesInSet(this.uncachedActiveStatements, STMT_CLOSE_METHOD);
        if (bl) {
            return null;
        }
        return new SQLException("An exception occurred while trying to clean up orphaned resources.");
    }

    ProxyConnection createProxyConnection() throws Exception {
        ProxyConnectionInvocationHandler proxyConnectionInvocationHandler = new ProxyConnectionInvocationHandler();
        return (ProxyConnection)CON_PROXY_CTOR.newInstance(proxyConnectionInvocationHandler);
    }

    Statement createProxyStatement(Statement statement) throws Exception {
        return this.createProxyStatement(false, statement);
    }

    Statement createProxyStatement(boolean bl, Statement statement) throws Exception {
        Set set = Collections.synchronizedSet(new HashSet());
        ProxyConnection proxyConnection = this.exposedProxy;
        if (proxyConnection == null) {
            logger.warning("PROBABLE C3P0 BUG -- " + this + ": created a proxy Statement when there is no active, exposed proxy Connection???");
        }
        StatementProxyingSetManagedResultSet statementProxyingSetManagedResultSet = new StatementProxyingSetManagedResultSet(set);
        if (statement instanceof CallableStatement) {
            class ProxyCallableStatement
            extends FilterCallableStatement
            implements C3P0ProxyStatement {
                1WrapperStatementHelper wsh;
                private final /* synthetic */ Statement val$innerStmt;
                private final /* synthetic */ StatementProxyingSetManagedResultSet val$mainResultSet;
                private final /* synthetic */ Set val$activeResultSets;
                private final /* synthetic */ boolean val$inner_is_cached;
                private final /* synthetic */ Connection val$parentConnection;

                ProxyCallableStatement(CallableStatement callableStatement, Statement statement, StatementProxyingSetManagedResultSet statementProxyingSetManagedResultSet, Set set, boolean bl, Connection connection) {
                    super(callableStatement);
                    this.val$innerStmt = statement;
                    this.val$mainResultSet = statementProxyingSetManagedResultSet;
                    this.val$activeResultSets = set;
                    this.val$inner_is_cached = bl;
                    this.val$parentConnection = connection;
                    class WrapperStatementHelper {
                        Statement wrapperStmt;
                        Statement nakedInner;
                        private final /* synthetic */ boolean val$inner_is_cached;
                        private final /* synthetic */ Set val$activeResultSets;
                        private final /* synthetic */ StatementProxyingSetManagedResultSet val$mainResultSet;
                        private final /* synthetic */ Statement val$innerStmt;
                        private final /* synthetic */ C3P0PooledConnection this$0;

                        public WrapperStatementHelper(C3P0PooledConnection c3P0PooledConnection, Statement statement, Statement statement2, boolean bl, Set set, StatementProxyingSetManagedResultSet statementProxyingSetManagedResultSet, Statement statement3) {
                            this.this$0 = c3P0PooledConnection;
                            this.val$inner_is_cached = bl;
                            this.val$activeResultSets = set;
                            this.val$mainResultSet = statementProxyingSetManagedResultSet;
                            this.val$innerStmt = statement3;
                            this.wrapperStmt = statement;
                            this.nakedInner = statement2;
                            if (!this.val$inner_is_cached) {
                                c3P0PooledConnection.uncachedActiveStatements.add(statement);
                            }
                        }

                        private boolean closeAndRemoveActiveResultSets() {
                            return this.this$0.closeAndRemoveResultSets(this.val$activeResultSets);
                        }

                        public ResultSet wrap(ResultSet resultSet) {
                            if (this.val$mainResultSet.getInner() == null) {
                                this.val$mainResultSet.setInner(resultSet);
                                this.val$mainResultSet.setProxyStatement(this.wrapperStmt);
                                return this.val$mainResultSet;
                            }
                            StatementProxyingSetManagedResultSet statementProxyingSetManagedResultSet = new StatementProxyingSetManagedResultSet(this.val$activeResultSets);
                            statementProxyingSetManagedResultSet.setInner(resultSet);
                            statementProxyingSetManagedResultSet.setProxyStatement(this.wrapperStmt);
                            return statementProxyingSetManagedResultSet;
                        }

                        public void doClose() throws SQLException {
                            boolean bl = this.closeAndRemoveActiveResultSets();
                            if (this.val$inner_is_cached) {
                                this.this$0.scache.checkinStatement(this.val$innerStmt);
                            } else {
                                this.val$innerStmt.close();
                                this.this$0.uncachedActiveStatements.remove(this.wrapperStmt);
                            }
                            if (!bl) {
                                throw new SQLException("Failed to close an orphaned ResultSet properly.");
                            }
                        }

                        public Object doRawStatementOperation(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, SQLException {
                            if (object == C3P0ProxyStatement.RAW_STATEMENT) {
                                object = this.nakedInner;
                            }
                            int n = objectArray.length;
                            for (int i = 0; i < n; ++i) {
                                if (objectArray[i] != C3P0ProxyStatement.RAW_STATEMENT) continue;
                                objectArray[i] = this.nakedInner;
                            }
                            Object object2 = method.invoke(object, objectArray);
                            if (object2 instanceof ResultSet) {
                                object2 = this.wrap((ResultSet)object2);
                            }
                            return object2;
                        }
                    }
                    this.wsh = new WrapperStatementHelper(C3P0PooledConnection.this, this, callableStatement, this.val$inner_is_cached, this.val$activeResultSets, this.val$mainResultSet, this.val$innerStmt);
                }

                public Connection getConnection() {
                    return this.val$parentConnection;
                }

                public ResultSet getResultSet() throws SQLException {
                    return this.wsh.wrap(super.getResultSet());
                }

                public ResultSet getGeneratedKeys() throws SQLException {
                    return this.wsh.wrap(super.getGeneratedKeys());
                }

                public ResultSet executeQuery(String string) throws SQLException {
                    return this.wsh.wrap(super.executeQuery(string));
                }

                public ResultSet executeQuery() throws SQLException {
                    return this.wsh.wrap(super.executeQuery());
                }

                public Object rawStatementOperation(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, SQLException {
                    return this.wsh.doRawStatementOperation(method, object, objectArray);
                }

                public void close() throws SQLException {
                    this.wsh.doClose();
                }
            }
            return new ProxyCallableStatement((CallableStatement)statement, statement, statementProxyingSetManagedResultSet, set, bl, proxyConnection);
        }
        if (statement instanceof PreparedStatement) {
            class ProxyPreparedStatement
            extends FilterPreparedStatement
            implements C3P0ProxyStatement {
                1WrapperStatementHelper wsh;
                private final /* synthetic */ Statement val$innerStmt;
                private final /* synthetic */ StatementProxyingSetManagedResultSet val$mainResultSet;
                private final /* synthetic */ Set val$activeResultSets;
                private final /* synthetic */ boolean val$inner_is_cached;
                private final /* synthetic */ Connection val$parentConnection;

                ProxyPreparedStatement(PreparedStatement preparedStatement, Statement statement, StatementProxyingSetManagedResultSet statementProxyingSetManagedResultSet, Set set, boolean bl, Connection connection) {
                    super(preparedStatement);
                    this.val$innerStmt = statement;
                    this.val$mainResultSet = statementProxyingSetManagedResultSet;
                    this.val$activeResultSets = set;
                    this.val$inner_is_cached = bl;
                    this.val$parentConnection = connection;
                    this.wsh = new WrapperStatementHelper(C3P0PooledConnection.this, this, preparedStatement, this.val$inner_is_cached, this.val$activeResultSets, this.val$mainResultSet, this.val$innerStmt);
                }

                public Connection getConnection() {
                    return this.val$parentConnection;
                }

                public ResultSet getResultSet() throws SQLException {
                    return this.wsh.wrap(super.getResultSet());
                }

                public ResultSet getGeneratedKeys() throws SQLException {
                    return this.wsh.wrap(super.getGeneratedKeys());
                }

                public ResultSet executeQuery(String string) throws SQLException {
                    return this.wsh.wrap(super.executeQuery(string));
                }

                public ResultSet executeQuery() throws SQLException {
                    return this.wsh.wrap(super.executeQuery());
                }

                public Object rawStatementOperation(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, SQLException {
                    return this.wsh.doRawStatementOperation(method, object, objectArray);
                }

                public void close() throws SQLException {
                    this.wsh.doClose();
                }
            }
            return new ProxyPreparedStatement((PreparedStatement)statement, statement, statementProxyingSetManagedResultSet, set, bl, proxyConnection);
        }
        class ProxyStatement
        extends FilterStatement
        implements C3P0ProxyStatement {
            1WrapperStatementHelper wsh;
            private final /* synthetic */ Statement val$innerStmt;
            private final /* synthetic */ StatementProxyingSetManagedResultSet val$mainResultSet;
            private final /* synthetic */ Set val$activeResultSets;
            private final /* synthetic */ boolean val$inner_is_cached;
            private final /* synthetic */ Connection val$parentConnection;

            ProxyStatement(Statement statement, Statement statement2, StatementProxyingSetManagedResultSet statementProxyingSetManagedResultSet, Set set, boolean bl, Connection connection) {
                super(statement);
                this.val$innerStmt = statement2;
                this.val$mainResultSet = statementProxyingSetManagedResultSet;
                this.val$activeResultSets = set;
                this.val$inner_is_cached = bl;
                this.val$parentConnection = connection;
                this.wsh = new WrapperStatementHelper(C3P0PooledConnection.this, this, statement, this.val$inner_is_cached, this.val$activeResultSets, this.val$mainResultSet, this.val$innerStmt);
            }

            public Connection getConnection() {
                return this.val$parentConnection;
            }

            public ResultSet getResultSet() throws SQLException {
                return this.wsh.wrap(super.getResultSet());
            }

            public ResultSet getGeneratedKeys() throws SQLException {
                return this.wsh.wrap(super.getGeneratedKeys());
            }

            public ResultSet executeQuery(String string) throws SQLException {
                return this.wsh.wrap(super.executeQuery(string));
            }

            public Object rawStatementOperation(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, SQLException {
                return this.wsh.doRawStatementOperation(method, object, objectArray);
            }

            public void close() throws SQLException {
                this.wsh.doClose();
            }
        }
        return new ProxyStatement(statement, statement, statementProxyingSetManagedResultSet, set, bl, proxyConnection);
    }

    public synchronized int getConnectionStatus() {
        return this.connection_status;
    }

    private synchronized void updateConnectionStatus(int n) {
        switch (this.connection_status) {
            case -8: {
                break;
            }
            case -1: {
                if (n != -8) break;
                this.doBadUpdate(n);
                break;
            }
            case 0: {
                if (n == 0) break;
                this.doBadUpdate(n);
                break;
            }
            default: {
                throw new InternalError(this + " -- Illegal Connection Status: " + this.connection_status);
            }
        }
    }

    private void doBadUpdate(int n) {
        this.connection_status = n;
        try {
            this.close(true);
        }
        catch (SQLException sQLException) {
            logger.log(MLevel.WARNING, "Broken Connection Close Error. ", sQLException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            CON_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection$ProxyConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection);
            Class[] classArray = new Class[]{};
            RS_CLOSE_METHOD = (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = C3P0PooledConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getMethod("close", classArray);
            STMT_CLOSE_METHOD = (class$java$sql$Statement == null ? (class$java$sql$Statement = C3P0PooledConnection.class$("java.sql.Statement")) : class$java$sql$Statement).getMethod("close", classArray);
            CLOSE_ARGS = new Object[0];
            OBJECT_METHODS = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList((class$java$lang$Object == null ? (class$java$lang$Object = C3P0PooledConnection.class$("java.lang.Object")) : class$java$lang$Object).getMethods())));
        }
        catch (Exception exception) {
            logger.log(MLevel.SEVERE, "An Exception occurred in static initializer of" + (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection).getName(), exception);
            throw new InternalError("Something is very wrong, or this is a pre 1.3 JVM.We cannot set up dynamic proxies and/or methods!");
        }
    }

    static interface ProxyConnection
    extends C3P0ProxyConnection {
        public void silentClose(boolean var1) throws SQLException;
    }

    final class ProxyConnectionInvocationHandler
    implements InvocationHandler {
        Connection activeConnection;
        DatabaseMetaData metaData;
        boolean connection_error_signaled;
        final Set activeMetaDataResultSets;
        Set doRawResultSets;
        boolean txn_known_resolved;

        ProxyConnectionInvocationHandler() {
            this.activeConnection = C3P0PooledConnection.this.physicalConnection;
            this.metaData = null;
            this.connection_error_signaled = false;
            this.activeMetaDataResultSets = new HashSet();
            this.doRawResultSets = null;
            this.txn_known_resolved = true;
        }

        public String toString() {
            return "C3P0ProxyConnection [Invocation Handler: " + super.toString() + ']';
        }

        private Object doRawConnectionOperation(Method method, Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, SQLException, Exception {
            if (this.activeConnection == null) {
                throw new SQLException("Connection previously closed. You cannot operate on a closed Connection.");
            }
            if (object == C3P0ProxyConnection.RAW_CONNECTION) {
                object = this.activeConnection;
            }
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] != C3P0ProxyConnection.RAW_CONNECTION) continue;
                objectArray[i] = this.activeConnection;
            }
            Object object2 = method.invoke(object, objectArray);
            if (object2 instanceof Statement) {
                object2 = C3P0PooledConnection.this.createProxyStatement(false, (Statement)object2);
            } else if (object2 instanceof ResultSet) {
                if (this.doRawResultSets == null) {
                    this.doRawResultSets = new HashSet();
                }
                object2 = new NullStatementSetManagedResultSet((ResultSet)object2, this.doRawResultSets);
            }
            return object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (OBJECT_METHODS.contains(method)) {
                return method.invoke((Object)this, objectArray);
            }
            try {
                String string = method.getName();
                if (this.activeConnection != null) {
                    if (string.equals("rawConnectionOperation")) {
                        C3P0PooledConnection.this.ensureOkay();
                        this.txn_known_resolved = false;
                        return this.doRawConnectionOperation((Method)objectArray[0], objectArray[1], (Object[])objectArray[2]);
                    }
                    if (string.equals("setTransactionIsolation")) {
                        C3P0PooledConnection.this.ensureOkay();
                        method.invoke((Object)this.activeConnection, objectArray);
                        int n = (Integer)objectArray[0];
                        C3P0PooledConnection.this.isolation_lvl_nondefault = n != C3P0PooledConnection.this.dflt_txn_isolation;
                        return null;
                    }
                    if (string.equals("setCatalog")) {
                        C3P0PooledConnection.this.ensureOkay();
                        method.invoke((Object)this.activeConnection, objectArray);
                        String string2 = (String)objectArray[0];
                        C3P0PooledConnection.this.catalog_nondefault = ObjectUtils.eqOrBothNull(string2, C3P0PooledConnection.this.dflt_catalog);
                        return null;
                    }
                    if (string.equals("setHoldability")) {
                        C3P0PooledConnection.this.ensureOkay();
                        method.invoke((Object)this.activeConnection, objectArray);
                        int n = (Integer)objectArray[0];
                        C3P0PooledConnection.this.holdability_nondefault = n != C3P0PooledConnection.this.dflt_holdability;
                        return null;
                    }
                    if (string.equals("createStatement")) {
                        C3P0PooledConnection.this.ensureOkay();
                        this.txn_known_resolved = false;
                        Object object2 = method.invoke((Object)this.activeConnection, objectArray);
                        return C3P0PooledConnection.this.createProxyStatement((Statement)object2);
                    }
                    if (string.equals("prepareStatement")) {
                        C3P0PooledConnection.this.ensureOkay();
                        this.txn_known_resolved = false;
                        if (C3P0PooledConnection.this.scache == null) {
                            Object object3 = method.invoke((Object)this.activeConnection, objectArray);
                            return C3P0PooledConnection.this.createProxyStatement((Statement)object3);
                        }
                        Object object4 = C3P0PooledConnection.this.scache.checkoutStatement(C3P0PooledConnection.this.physicalConnection, method, objectArray);
                        return C3P0PooledConnection.this.createProxyStatement(true, (Statement)object4);
                    }
                    if (string.equals("prepareCall")) {
                        C3P0PooledConnection.this.ensureOkay();
                        this.txn_known_resolved = false;
                        if (C3P0PooledConnection.this.scache == null) {
                            Object object5 = method.invoke((Object)this.activeConnection, objectArray);
                            return C3P0PooledConnection.this.createProxyStatement((Statement)object5);
                        }
                        Object object6 = C3P0PooledConnection.this.scache.checkoutStatement(C3P0PooledConnection.this.physicalConnection, method, objectArray);
                        return C3P0PooledConnection.this.createProxyStatement(true, (Statement)object6);
                    }
                    if (string.equals("getMetaData")) {
                        C3P0PooledConnection.this.ensureOkay();
                        this.txn_known_resolved = false;
                        DatabaseMetaData databaseMetaData = this.activeConnection.getMetaData();
                        if (this.metaData == null) {
                            C3P0PooledConnection c3P0PooledConnection = C3P0PooledConnection.this;
                            synchronized (c3P0PooledConnection) {
                                this.metaData = new SetManagedDatabaseMetaData(databaseMetaData, this.activeMetaDataResultSets, C3P0PooledConnection.this.exposedProxy);
                            }
                        }
                        return this.metaData;
                    }
                    if (string.equals("silentClose")) {
                        this.doSilentClose(object, (Boolean)objectArray[0], this.txn_known_resolved);
                        return null;
                    }
                    if (string.equals("close")) {
                        Exception exception = this.doSilentClose(object, false, this.txn_known_resolved);
                        if (!this.connection_error_signaled) {
                            C3P0PooledConnection.this.ces.fireConnectionClosed();
                        }
                        if (exception != null) {
                            throw exception;
                        }
                        return null;
                    }
                    C3P0PooledConnection.this.ensureOkay();
                    this.txn_known_resolved = false;
                    return method.invoke((Object)this.activeConnection, objectArray);
                }
                if (string.equals("close") || string.equals("silentClose")) {
                    return null;
                }
                if (string.equals("isClosed")) {
                    return new Boolean(true);
                }
                throw new SQLException("You can't operate on a closed connection!!!");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                SQLException sQLException = this.handleMaybeFatalToPooledConnection(throwable, object, false);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }

        private Exception doSilentClose(Object object, boolean bl) {
            return this.doSilentClose(object, bl, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Exception doSilentClose(Object object, boolean bl, boolean bl2) {
            if (this.activeConnection != null) {
                String string;
                Object object2 = C3P0PooledConnection.this;
                synchronized (object2) {
                    if (C3P0PooledConnection.this.exposedProxy == object) {
                        C3P0PooledConnection.this.exposedProxy = null;
                    } else {
                        logger.warning("(c3p0 issue) doSilentClose( ... ) called on a proxyConnection other than the current exposed proxy for its PooledConnection. [exposedProxy: " + C3P0PooledConnection.this.exposedProxy + ", proxyConnection: " + object);
                    }
                }
                object2 = null;
                Exception exception = null;
                SQLException sQLException = null;
                SQLException sQLException2 = null;
                Exception exception2 = null;
                try {
                    if (!bl) {
                        C3P0PooledConnection.this.reset(bl2);
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                }
                sQLException = C3P0PooledConnection.this.cleanupUncachedActiveStatements();
                if (this.doRawResultSets != null) {
                    this.activeMetaDataResultSets.addAll(this.doRawResultSets);
                    string = "DataBaseMetaData or raw Connection operation";
                } else {
                    string = "DataBaseMetaData";
                }
                if (!C3P0PooledConnection.this.closeAndRemoveResultSets(this.activeMetaDataResultSets)) {
                    sQLException2 = new SQLException("Failed to close some " + string + " Result Sets.");
                }
                if (C3P0PooledConnection.this.scache != null) {
                    try {
                        C3P0PooledConnection.this.scache.checkinAll(C3P0PooledConnection.this.physicalConnection);
                    }
                    catch (Exception exception4) {
                        exception2 = exception4;
                    }
                }
                if (exception != null) {
                    this.handleMaybeFatalToPooledConnection(exception, object, true);
                    object2 = exception;
                } else if (sQLException != null) {
                    this.handleMaybeFatalToPooledConnection(sQLException, object, true);
                    object2 = sQLException;
                } else if (sQLException2 != null) {
                    this.handleMaybeFatalToPooledConnection(sQLException2, object, true);
                    object2 = sQLException2;
                } else if (exception2 != null) {
                    this.handleMaybeFatalToPooledConnection(exception2, object, true);
                    object2 = exception2;
                }
                this.activeConnection = null;
                return object2;
            }
            return null;
        }

        private SQLException handleMaybeFatalToPooledConnection(Throwable throwable, Object object, boolean bl) {
            SQLException sQLException = SqlUtils.toSQLException(throwable);
            int n = C3P0PooledConnection.this.connectionTester.statusOnException(C3P0PooledConnection.this.physicalConnection, sQLException);
            C3P0PooledConnection.this.updateConnectionStatus(n);
            if (n != 0) {
                logger.log(MLevel.INFO, C3P0PooledConnection.this + " will no longer be pooled because it has been marked invalid by an Exception.", throwable);
                C3P0PooledConnection.this.invalidatingException = sQLException;
                if (!this.connection_error_signaled) {
                    C3P0PooledConnection.this.ces.fireConnectionErrorOccurred(sQLException);
                    this.connection_error_signaled = true;
                }
            }
            return sQLException;
        }
    }

    private static class StatementProxyingSetManagedResultSet
    extends SetManagedResultSet {
        private Statement proxyStatement;

        StatementProxyingSetManagedResultSet(Set set) {
            super(set);
        }

        public void setProxyStatement(Statement statement) {
            this.proxyStatement = statement;
        }

        public Statement getStatement() throws SQLException {
            return this.proxyStatement == null ? super.getStatement() : this.proxyStatement;
        }
    }
}

