/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class WrapperConnectionPoolDataSource
extends WrapperConnectionPoolDataSourceBase
implements ConnectionPoolDataSource {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource == null ? (class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource = WrapperConnectionPoolDataSource.class$("com.mchange.v2.c3p0.WrapperConnectionPoolDataSource")) : class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource);
    ConnectionTester connectionTester = C3P0ImplUtils.defaultConnectionTester();
    static /* synthetic */ Class class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource;

    public WrapperConnectionPoolDataSource() {
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                Object object = propertyChangeEvent.getNewValue();
                try {
                    if ("connectionTesterClassName".equals(propertyChangeEvent.getPropertyName())) {
                        WrapperConnectionPoolDataSource.this.recreateConnectionTester((String)object);
                    }
                }
                catch (Exception exception) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "Failed to create ConnectionTester of class " + object, exception);
                    }
                    throw new PropertyVetoException("Could not instantiate connection tester class with name '" + object + "'.", propertyChangeEvent);
                }
            }
        };
        this.addVetoableChangeListener(vetoableChangeListener);
        C3P0Registry.register(this);
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        Connection connection = this.getNestedDataSource().getConnection();
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(connection, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
        }
        return new NewPooledConnection(connection, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public synchronized PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        Connection connection = this.getNestedDataSource().getConnection(string, string2);
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(connection, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
        }
        return new NewPooledConnection(connection, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public synchronized PrintWriter getLogWriter() throws SQLException {
        return this.getNestedDataSource().getLogWriter();
    }

    public synchronized void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.getNestedDataSource().setLogWriter(printWriter);
    }

    public synchronized void setLoginTimeout(int n) throws SQLException {
        this.getNestedDataSource().setLoginTimeout(n);
    }

    public synchronized int getLoginTimeout() throws SQLException {
        return this.getNestedDataSource().getLoginTimeout();
    }

    public synchronized String getUser() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getUser();
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'user' property from our nested DataSource. Defaulting to no specified username.", sQLException);
            }
            return null;
        }
    }

    public synchronized String getPassword() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getPassword();
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'password' property from our nested DataSource. Defaulting to no specified password.", sQLException);
            }
            return null;
        }
    }

    private synchronized void recreateConnectionTester(String string) throws Exception {
        ConnectionTester connectionTester;
        this.connectionTester = string != null ? (connectionTester = (ConnectionTester)Class.forName(string).newInstance()) : C3P0ImplUtils.defaultConnectionTester();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

