/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class PoolConfig {
    static final MLogger logger;
    public static final String INITIAL_POOL_SIZE = "c3p0.initialPoolSize";
    public static final String MIN_POOL_SIZE = "c3p0.minPoolSize";
    public static final String MAX_POOL_SIZE = "c3p0.maxPoolSize";
    public static final String IDLE_CONNECTION_TEST_PERIOD = "c3p0.idleConnectionTestPeriod";
    public static final String MAX_IDLE_TIME = "c3p0.maxIdleTime";
    public static final String PROPERTY_CYCLE = "c3p0.propertyCycle";
    public static final String MAX_STATEMENTS = "c3p0.maxStatements";
    public static final String MAX_STATEMENTS_PER_CONNECTION = "c3p0.maxStatementsPerConnection";
    public static final String CHECKOUT_TIMEOUT = "c3p0.checkoutTimeout";
    public static final String ACQUIRE_INCREMENT = "c3p0.acquireIncrement";
    public static final String ACQUIRE_RETRY_ATTEMPTS = "c3p0.acquireRetryAttempts";
    public static final String ACQUIRE_RETRY_DELAY = "c3p0.acquireRetryDelay";
    public static final String BREAK_AFTER_ACQUIRE_FAILURE = "c3p0.breakAfterAcquireFailure";
    public static final String USES_TRADITIONAL_REFLECTIVE_PROXIES = "c3p0.usesTraditionalReflectiveProxies";
    public static final String TEST_CONNECTION_ON_CHECKOUT = "c3p0.testConnectionOnCheckout";
    public static final String TEST_CONNECTION_ON_CHECKIN = "c3p0.testConnectionOnCheckin";
    public static final String CONNECTION_TESTER_CLASS_NAME = "c3p0.connectionTesterClassName";
    public static final String AUTOMATIC_TEST_TABLE = "c3p0.automaticTestTable";
    public static final String AUTO_COMMIT_ON_CLOSE = "c3p0.autoCommitOnClose";
    public static final String FORCE_IGNORE_UNRESOLVED_TRANSACTIONS = "c3p0.forceIgnoreUnresolvedTransactions";
    public static final String NUM_HELPER_THREADS = "c3p0.numHelperThreads";
    public static final String PREFERRED_TEST_QUERY = "c3p0.preferredTestQuery";
    public static final String FACTORY_CLASS_LOCATION = "c3p0.factoryClassLocation";
    public static final String DEFAULT_CONFIG_RSRC_PATH = "/c3p0.properties";
    static final PoolConfig DEFAULTS;
    int maxStatements;
    int maxStatementsPerConnection;
    int initialPoolSize;
    int minPoolSize;
    int maxPoolSize;
    int idleConnectionTestPeriod;
    int maxIdleTime;
    int propertyCycle;
    int checkoutTimeout;
    int acquireIncrement;
    int acquireRetryAttempts;
    int acquireRetryDelay;
    boolean breakAfterAcquireFailure;
    boolean testConnectionOnCheckout;
    boolean testConnectionOnCheckin;
    boolean autoCommitOnClose;
    boolean forceIgnoreUnresolvedTransactions;
    boolean usesTraditionalReflectiveProxies;
    String connectionTesterClassName;
    String automaticTestTable;
    int numHelperThreads;
    String preferredTestQuery;
    String factoryClassLocation;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$PoolConfig;

    public static int defaultNumHelperThreads() {
        return DEFAULTS.getNumHelperThreads();
    }

    public static String defaultPreferredTestQuery() {
        return DEFAULTS.getPreferredTestQuery();
    }

    public static String defaultFactoryClassLocation() {
        return DEFAULTS.getFactoryClassLocation();
    }

    public static int defaultMaxStatements() {
        return DEFAULTS.getMaxStatements();
    }

    public static int defaultMaxStatementsPerConnection() {
        return DEFAULTS.getMaxStatementsPerConnection();
    }

    public static int defaultInitialPoolSize() {
        return DEFAULTS.getInitialPoolSize();
    }

    public static int defaultMinPoolSize() {
        return DEFAULTS.getMinPoolSize();
    }

    public static int defaultMaxPoolSize() {
        return DEFAULTS.getMaxPoolSize();
    }

    public static int defaultIdleConnectionTestPeriod() {
        return DEFAULTS.getIdleConnectionTestPeriod();
    }

    public static int defaultMaxIdleTime() {
        return DEFAULTS.getMaxIdleTime();
    }

    public static int defaultPropertyCycle() {
        return DEFAULTS.getPropertyCycle();
    }

    public static int defaultCheckoutTimeout() {
        return DEFAULTS.getCheckoutTimeout();
    }

    public static int defaultAcquireIncrement() {
        return DEFAULTS.getAcquireIncrement();
    }

    public static int defaultAcquireRetryAttempts() {
        return DEFAULTS.getAcquireRetryAttempts();
    }

    public static int defaultAcquireRetryDelay() {
        return DEFAULTS.getAcquireRetryDelay();
    }

    public static boolean defaultBreakAfterAcquireFailure() {
        return DEFAULTS.isBreakAfterAcquireFailure();
    }

    public static String defaultConnectionTesterClassName() {
        return DEFAULTS.getConnectionTesterClassName();
    }

    public static String defaultAutomaticTestTable() {
        return DEFAULTS.getAutomaticTestTable();
    }

    public static boolean defaultTestConnectionOnCheckout() {
        return DEFAULTS.isTestConnectionOnCheckout();
    }

    public static boolean defaultTestConnectionOnCheckin() {
        return DEFAULTS.isTestConnectionOnCheckin();
    }

    public static boolean defaultAutoCommitOnClose() {
        return DEFAULTS.isAutoCommitOnClose();
    }

    public static boolean defaultForceIgnoreUnresolvedTransactions() {
        return DEFAULTS.isAutoCommitOnClose();
    }

    public static boolean defaultUsesTraditionalReflectiveProxies() {
        return DEFAULTS.isUsesTraditionalReflectiveProxies();
    }

    private PoolConfig(Properties properties, boolean bl) throws NumberFormatException {
        if (bl) {
            PoolConfig.extractConfig(this, properties, DEFAULTS);
        }
    }

    public PoolConfig(Properties properties) throws NumberFormatException {
        this(properties, true);
    }

    public PoolConfig() throws NumberFormatException {
        this(null, true);
    }

    public int getNumHelperThreads() {
        return this.numHelperThreads;
    }

    public String getPreferredTestQuery() {
        return this.preferredTestQuery;
    }

    public String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public int getMaxStatementsPerConnection() {
        return this.maxStatementsPerConnection;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getIdleConnectionTestPeriod() {
        return this.idleConnectionTestPeriod;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    public int getCheckoutTimeout() {
        return this.checkoutTimeout;
    }

    public int getAcquireRetryAttempts() {
        return this.acquireRetryAttempts;
    }

    public int getAcquireRetryDelay() {
        return this.acquireRetryDelay;
    }

    public boolean isBreakAfterAcquireFailure() {
        return this.breakAfterAcquireFailure;
    }

    public boolean isUsesTraditionalReflectiveProxies() {
        return this.usesTraditionalReflectiveProxies;
    }

    public String getConnectionTesterClassName() {
        return this.connectionTesterClassName;
    }

    public String getAutomaticTestTable() {
        return this.automaticTestTable;
    }

    public boolean getTestConnectionOnCheckout() {
        return this.testConnectionOnCheckout;
    }

    public boolean isTestConnectionOnCheckout() {
        return this.getTestConnectionOnCheckout();
    }

    public boolean isTestConnectionOnCheckin() {
        return this.testConnectionOnCheckin;
    }

    public boolean isAutoCommitOnClose() {
        return this.autoCommitOnClose;
    }

    public boolean isForceIgnoreUnresolvedTransactions() {
        return this.forceIgnoreUnresolvedTransactions;
    }

    public void setNumHelperThreads(int n) {
        this.numHelperThreads = n;
    }

    public void setPreferredTestQuery(String string) {
        this.preferredTestQuery = string;
    }

    public void setFactoryClassLocation(String string) {
        this.factoryClassLocation = string;
    }

    public void setMaxStatements(int n) {
        this.maxStatements = n;
    }

    public void setMaxStatementsPerConnection(int n) {
        this.maxStatementsPerConnection = n;
    }

    public void setInitialPoolSize(int n) {
        this.initialPoolSize = n;
    }

    public void setMinPoolSize(int n) {
        this.minPoolSize = n;
    }

    public void setMaxPoolSize(int n) {
        this.maxPoolSize = n;
    }

    public void setIdleConnectionTestPeriod(int n) {
        this.idleConnectionTestPeriod = n;
    }

    public void setMaxIdleTime(int n) {
        this.maxIdleTime = n;
    }

    public void setPropertyCycle(int n) {
        this.propertyCycle = n;
    }

    public void setCheckoutTimeout(int n) {
        this.checkoutTimeout = n;
    }

    public void setAcquireIncrement(int n) {
        this.acquireIncrement = n;
    }

    public void setAcquireRetryAttempts(int n) {
        this.acquireRetryAttempts = n;
    }

    public void setAcquireRetryDelay(int n) {
        this.acquireRetryDelay = n;
    }

    public void setConnectionTesterClassName(String string) {
        this.connectionTesterClassName = string;
    }

    public void setAutomaticTestTable(String string) {
        this.automaticTestTable = string;
    }

    public void setBreakAfterAcquireFailure(boolean bl) {
        this.breakAfterAcquireFailure = bl;
    }

    public void setUsesTraditionalReflectiveProxies(boolean bl) {
        this.usesTraditionalReflectiveProxies = bl;
    }

    public void setTestConnectionOnCheckout(boolean bl) {
        this.testConnectionOnCheckout = bl;
    }

    public void setTestConnectionOnCheckin(boolean bl) {
        this.testConnectionOnCheckin = bl;
    }

    public void setAutoCommitOnClose(boolean bl) {
        this.autoCommitOnClose = bl;
    }

    public void setForceIgnoreUnresolvedTransactions(boolean bl) {
        this.forceIgnoreUnresolvedTransactions = bl;
    }

    private static PoolConfig extractConfig(Properties properties, PoolConfig poolConfig) throws NumberFormatException {
        PoolConfig poolConfig2 = new PoolConfig(null, false);
        PoolConfig.extractConfig(poolConfig2, properties, poolConfig);
        return poolConfig2;
    }

    private static void extractConfig(PoolConfig poolConfig, Properties properties, PoolConfig poolConfig2) throws NumberFormatException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        String string18 = null;
        String string19 = null;
        String string20 = null;
        String string21 = null;
        String string22 = null;
        String string23 = null;
        if (properties != null) {
            string = properties.getProperty(MAX_STATEMENTS);
            string2 = properties.getProperty(MAX_STATEMENTS_PER_CONNECTION);
            string3 = properties.getProperty(INITIAL_POOL_SIZE);
            string4 = properties.getProperty(MIN_POOL_SIZE);
            string5 = properties.getProperty(MAX_POOL_SIZE);
            string6 = properties.getProperty(IDLE_CONNECTION_TEST_PERIOD);
            string7 = properties.getProperty(MAX_IDLE_TIME);
            string8 = properties.getProperty(PROPERTY_CYCLE);
            string9 = properties.getProperty(CHECKOUT_TIMEOUT);
            string10 = properties.getProperty(ACQUIRE_INCREMENT);
            string11 = properties.getProperty(ACQUIRE_RETRY_ATTEMPTS);
            string12 = properties.getProperty(ACQUIRE_RETRY_DELAY);
            string13 = properties.getProperty(BREAK_AFTER_ACQUIRE_FAILURE);
            string14 = properties.getProperty(USES_TRADITIONAL_REFLECTIVE_PROXIES);
            string15 = properties.getProperty(TEST_CONNECTION_ON_CHECKOUT);
            string16 = properties.getProperty(TEST_CONNECTION_ON_CHECKIN);
            string17 = properties.getProperty(AUTO_COMMIT_ON_CLOSE);
            string18 = properties.getProperty(FORCE_IGNORE_UNRESOLVED_TRANSACTIONS);
            string19 = properties.getProperty(CONNECTION_TESTER_CLASS_NAME);
            string20 = properties.getProperty(AUTOMATIC_TEST_TABLE);
            string21 = properties.getProperty(NUM_HELPER_THREADS);
            string22 = properties.getProperty(PREFERRED_TEST_QUERY);
            string23 = properties.getProperty(FACTORY_CLASS_LOCATION);
        }
        if (string != null) {
            poolConfig.setMaxStatements(Integer.parseInt(string.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setMaxStatements(poolConfig2.getMaxStatements());
        } else {
            poolConfig.setMaxStatements(C3P0Defaults.maxStatements());
        }
        if (string2 != null) {
            poolConfig.setMaxStatementsPerConnection(Integer.parseInt(string2.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setMaxStatementsPerConnection(poolConfig2.getMaxStatementsPerConnection());
        } else {
            poolConfig.setMaxStatementsPerConnection(C3P0Defaults.maxStatementsPerConnection());
        }
        if (string3 != null) {
            poolConfig.setInitialPoolSize(Integer.parseInt(string3.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setInitialPoolSize(poolConfig2.getInitialPoolSize());
        } else {
            poolConfig.setInitialPoolSize(C3P0Defaults.initialPoolSize());
        }
        if (string4 != null) {
            poolConfig.setMinPoolSize(Integer.parseInt(string4.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setMinPoolSize(poolConfig2.getMinPoolSize());
        } else {
            poolConfig.setMinPoolSize(C3P0Defaults.minPoolSize());
        }
        if (string5 != null) {
            poolConfig.setMaxPoolSize(Integer.parseInt(string5.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setMaxPoolSize(poolConfig2.getMaxPoolSize());
        } else {
            poolConfig.setMaxPoolSize(C3P0Defaults.maxPoolSize());
        }
        if (string6 != null) {
            poolConfig.setIdleConnectionTestPeriod(Integer.parseInt(string6.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setIdleConnectionTestPeriod(poolConfig2.getIdleConnectionTestPeriod());
        } else {
            poolConfig.setIdleConnectionTestPeriod(C3P0Defaults.idleConnectionTestPeriod());
        }
        if (string7 != null) {
            poolConfig.setMaxIdleTime(Integer.parseInt(string7.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setMaxIdleTime(poolConfig2.getMaxIdleTime());
        } else {
            poolConfig.setMaxIdleTime(C3P0Defaults.maxIdleTime());
        }
        if (string8 != null) {
            poolConfig.setPropertyCycle(Integer.parseInt(string8.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setPropertyCycle(poolConfig2.getPropertyCycle());
        } else {
            poolConfig.setPropertyCycle(C3P0Defaults.propertyCycle());
        }
        if (string9 != null) {
            poolConfig.setCheckoutTimeout(Integer.parseInt(string9.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setCheckoutTimeout(poolConfig2.getCheckoutTimeout());
        } else {
            poolConfig.setCheckoutTimeout(C3P0Defaults.checkoutTimeout());
        }
        if (string10 != null) {
            poolConfig.setAcquireIncrement(Integer.parseInt(string10.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setAcquireIncrement(poolConfig2.getAcquireIncrement());
        } else {
            poolConfig.setAcquireIncrement(C3P0Defaults.acquireIncrement());
        }
        if (string11 != null) {
            poolConfig.setAcquireRetryAttempts(Integer.parseInt(string11.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setAcquireRetryAttempts(poolConfig2.getAcquireRetryAttempts());
        } else {
            poolConfig.setAcquireRetryAttempts(C3P0Defaults.acquireRetryAttempts());
        }
        if (string12 != null) {
            poolConfig.setAcquireRetryDelay(Integer.parseInt(string12.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setAcquireRetryDelay(poolConfig2.getAcquireRetryDelay());
        } else {
            poolConfig.setAcquireRetryDelay(C3P0Defaults.acquireRetryDelay());
        }
        if (string13 != null) {
            poolConfig.setBreakAfterAcquireFailure(Boolean.valueOf(string13.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setBreakAfterAcquireFailure(poolConfig2.isBreakAfterAcquireFailure());
        } else {
            poolConfig.setBreakAfterAcquireFailure(C3P0Defaults.breakAfterAcquireFailure());
        }
        if (string14 != null) {
            poolConfig.setUsesTraditionalReflectiveProxies(Boolean.valueOf(string14.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setUsesTraditionalReflectiveProxies(poolConfig2.isUsesTraditionalReflectiveProxies());
        } else {
            poolConfig.setUsesTraditionalReflectiveProxies(C3P0Defaults.usesTraditionalReflectiveProxies());
        }
        if (string15 != null) {
            poolConfig.setTestConnectionOnCheckout(Boolean.valueOf(string15.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setTestConnectionOnCheckout(poolConfig2.isTestConnectionOnCheckout());
        } else {
            poolConfig.setTestConnectionOnCheckout(C3P0Defaults.testConnectionOnCheckout());
        }
        if (string16 != null) {
            poolConfig.setTestConnectionOnCheckin(Boolean.valueOf(string16.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setTestConnectionOnCheckin(poolConfig2.isTestConnectionOnCheckin());
        } else {
            poolConfig.setTestConnectionOnCheckin(C3P0Defaults.testConnectionOnCheckin());
        }
        if (string17 != null) {
            poolConfig.setAutoCommitOnClose(Boolean.valueOf(string17.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setAutoCommitOnClose(poolConfig2.isAutoCommitOnClose());
        } else {
            poolConfig.setAutoCommitOnClose(C3P0Defaults.autoCommitOnClose());
        }
        if (string18 != null) {
            poolConfig.setForceIgnoreUnresolvedTransactions(Boolean.valueOf(string18.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setForceIgnoreUnresolvedTransactions(poolConfig2.isForceIgnoreUnresolvedTransactions());
        } else {
            poolConfig.setForceIgnoreUnresolvedTransactions(C3P0Defaults.forceIgnoreUnresolvedTransactions());
        }
        if (string19 != null) {
            poolConfig.setConnectionTesterClassName(string19.trim());
        } else if (poolConfig2 != null) {
            poolConfig.setConnectionTesterClassName(poolConfig2.getConnectionTesterClassName());
        } else {
            poolConfig.setConnectionTesterClassName(C3P0Defaults.connectionTesterClassName());
        }
        if (string20 != null) {
            poolConfig.setAutomaticTestTable(string20.trim());
        } else if (poolConfig2 != null) {
            poolConfig.setAutomaticTestTable(poolConfig2.getAutomaticTestTable());
        } else {
            poolConfig.setAutomaticTestTable(C3P0Defaults.automaticTestTable());
        }
        if (string21 != null) {
            poolConfig.setNumHelperThreads(Integer.parseInt(string21.trim()));
        } else if (poolConfig2 != null) {
            poolConfig.setNumHelperThreads(poolConfig2.getNumHelperThreads());
        } else {
            poolConfig.setNumHelperThreads(C3P0Defaults.numHelperThreads());
        }
        if (string22 != null) {
            poolConfig.setPreferredTestQuery(string22.trim());
        } else if (poolConfig2 != null) {
            poolConfig.setPreferredTestQuery(poolConfig2.getPreferredTestQuery());
        } else {
            poolConfig.setPreferredTestQuery(C3P0Defaults.preferredTestQuery());
        }
        if (string23 != null) {
            poolConfig.setFactoryClassLocation(string23.trim());
        } else if (poolConfig2 != null) {
            poolConfig.setFactoryClassLocation(poolConfig2.getFactoryClassLocation());
        } else {
            poolConfig.setFactoryClassLocation(C3P0Defaults.factoryClassLocation());
        }
    }

    private static Properties findResourceProperties() {
        return MultiPropertiesConfig.readVmConfig().getPropertiesByResourcePath(DEFAULT_CONFIG_RSRC_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties origFindResourceProperties() {
        InputStream inputStream;
        Properties properties;
        block5: {
            properties = new Properties();
            inputStream = null;
            try {
                inputStream = (class$com$mchange$v2$c3p0$PoolConfig == null ? (class$com$mchange$v2$c3p0$PoolConfig = PoolConfig.class$("com.mchange.v2.c3p0.PoolConfig")) : class$com$mchange$v2$c3p0$PoolConfig).getResourceAsStream(DEFAULT_CONFIG_RSRC_PATH);
                if (inputStream == null) break block5;
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                try {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "An IOException occurred while trying to read Pool properties!", iOException);
                    }
                    properties = new Properties();
                }
                catch (Throwable throwable) {
                    InputStreamUtils.attemptClose(inputStream);
                    throw throwable;
                }
                InputStreamUtils.attemptClose(inputStream);
            }
        }
        InputStreamUtils.attemptClose(inputStream);
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Properties properties;
        logger = MLog.getLogger(class$com$mchange$v2$c3p0$PoolConfig == null ? (class$com$mchange$v2$c3p0$PoolConfig = PoolConfig.class$("com.mchange.v2.c3p0.PoolConfig")) : class$com$mchange$v2$c3p0$PoolConfig);
        Properties properties2 = PoolConfig.findResourceProperties();
        PoolConfig poolConfig = PoolConfig.extractConfig(properties2, null);
        try {
            properties = System.getProperties();
        }
        catch (SecurityException securityException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Read of system Properties blocked -- ignoring any c3p0 configuration via System properties! (But any configuration via a c3p0.properties file is still okay!)", securityException);
            }
            properties = new Properties();
        }
        DEFAULTS = PoolConfig.extractConfig(properties, poolConfig);
    }
}

