/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.IdentityTokenized;
import com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class PoolBackedDataSource
extends PoolBackedDataSourceBase
implements PooledDataSource {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$PoolBackedDataSource == null ? (class$com$mchange$v2$c3p0$PoolBackedDataSource = PoolBackedDataSource.class$("com.mchange.v2.c3p0.PoolBackedDataSource")) : class$com$mchange$v2$c3p0$PoolBackedDataSource);
    static final String NO_CPDS_ERR_MSG = "Attempted to use an uninitialized PoolBackedDataSource. Please call setConnectionPoolDataSource( ... ) to initialize.";
    ComboPooledDataSource parent;
    transient C3P0PooledConnectionPoolManager poolManager;
    transient boolean is_closed = false;
    private static final long serialVersionUID = 1L;
    private static final short VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$PoolBackedDataSource;

    public PoolBackedDataSource() {
        this(null);
    }

    PoolBackedDataSource(ComboPooledDataSource comboPooledDataSource) {
        this.parent = comboPooledDataSource;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PoolBackedDataSource.this.resetPoolManager();
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
        C3P0Registry.register(this);
    }

    ComboPooledDataSource owner() {
        return this.parent;
    }

    public Connection getConnection() throws SQLException {
        PooledConnection pooledConnection = this.getPoolManager().getPool().checkoutPooledConnection();
        return pooledConnection.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        PooledConnection pooledConnection = this.getPoolManager().getPool(string, string2).checkoutPooledConnection();
        return pooledConnection.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.assertCpds().getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.assertCpds().setLogWriter(printWriter);
    }

    public int getLoginTimeout() throws SQLException {
        return this.assertCpds().getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.assertCpds().setLoginTimeout(n);
    }

    public int getNumConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumConnections();
    }

    public int getNumIdleConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumIdleConnections();
    }

    public int getNumBusyConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumUnclosedOrphanedConnections();
    }

    public int getNumConnectionsDefaultUser() throws SQLException {
        return this.getNumConnections();
    }

    public int getNumIdleConnectionsDefaultUser() throws SQLException {
        return this.getNumIdleConnections();
    }

    public int getNumBusyConnectionsDefaultUser() throws SQLException {
        return this.getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnectionsDefaultUser() throws SQLException {
        return this.getNumUnclosedOrphanedConnections();
    }

    public void softResetDefaultUser() throws SQLException {
        this.getPoolManager().getPool().reset();
    }

    public int getNumConnections(String string, String string2) throws SQLException {
        return this.getPoolManager().getPool(string, string2).getNumConnections();
    }

    public int getNumIdleConnections(String string, String string2) throws SQLException {
        return this.getPoolManager().getPool(string, string2).getNumIdleConnections();
    }

    public int getNumBusyConnections(String string, String string2) throws SQLException {
        return this.getPoolManager().getPool(string, string2).getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections(String string, String string2) throws SQLException {
        return this.getPoolManager().getPool(string, string2).getNumUnclosedOrphanedConnections();
    }

    public void softReset(String string, String string2) throws SQLException {
        this.getPoolManager().getPool(string, string2).reset();
    }

    public int getNumBusyConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumBusyConnectionsAllAuths();
    }

    public int getNumIdleConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumIdleConnectionsAllAuths();
    }

    public int getNumConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumConnectionsAllAuths();
    }

    public int getNumUnclosedOrphanedConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumUnclosedOrphanedConnectionsAllAuths();
    }

    public void softResetAllUsers() throws SQLException {
        this.getPoolManager().softResetAllAuths();
    }

    public int getNumUserPools() throws SQLException {
        return this.getPoolManager().getNumManagedAuths();
    }

    public synchronized void hardReset() {
        C3P0PooledConnectionPoolManager c3P0PooledConnectionPoolManager = this.poolManager;
        this.resetPoolManager();
        c3P0PooledConnectionPoolManager.forceDestroy();
    }

    public void close() {
        this.close(false);
    }

    public synchronized void close(boolean bl) {
        C3P0PooledConnectionPoolManager c3P0PooledConnectionPoolManager = bl ? this.poolManager : null;
        this.resetPoolManager();
        if (bl) {
            c3P0PooledConnectionPoolManager.forceDestroy();
        }
        this.is_closed = true;
        logger.log(MLevel.FINEST, this.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(this)) + " has been closed. force_destroy == " + bl, new Exception("Debug -- PoolBackedDataSource.close() stack trace."));
    }

    public synchronized void resetPoolManager() {
        if (this.poolManager != null) {
            this.poolManager.unregisterActiveClient(this);
            this.poolManager = null;
        }
    }

    private synchronized ConnectionPoolDataSource assertCpds() throws SQLException {
        if (this.is_closed) {
            throw new SQLException(this + " has been closed() -- you can no longer use it.");
        }
        ConnectionPoolDataSource connectionPoolDataSource = this.getConnectionPoolDataSource();
        if (connectionPoolDataSource == null) {
            throw new SQLException(NO_CPDS_ERR_MSG);
        }
        return connectionPoolDataSource;
    }

    private synchronized C3P0PooledConnectionPoolManager getPoolManager() throws SQLException {
        if (this.poolManager == null) {
            ConnectionPoolDataSource connectionPoolDataSource = this.assertCpds();
            String string = connectionPoolDataSource instanceof IdentityTokenized ? ((IdentityTokenized)((Object)connectionPoolDataSource)).getIdentityToken() : C3P0ImplUtils.identityToken(connectionPoolDataSource);
            this.poolManager = C3P0PooledConnectionPoolManager.find(this.getIdentityToken(), connectionPoolDataSource, string, this.getNumHelperThreads());
            this.poolManager.registerActiveClient(this);
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info("Initializing c3p0 pool... " + (this.parent == null ? this.toString() : this.parent.toString()));
            }
        }
        return this.poolManager;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.parent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        short s = objectInputStream.readShort();
        switch (s) {
            case 1: {
                this.parent = (ComboPooledDataSource)objectInputStream.readObject();
                break;
            }
            default: {
                throw new IOException("Unsupported Serialized Version: " + s);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

