/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.impl.JndiRefDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.sql.DataSource;

final class JndiRefForwardingDataSource
extends JndiRefDataSourceBase
implements DataSource {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$JndiRefForwardingDataSource == null ? (class$com$mchange$v2$c3p0$JndiRefForwardingDataSource = JndiRefForwardingDataSource.class$("com.mchange.v2.c3p0.JndiRefForwardingDataSource")) : class$com$mchange$v2$c3p0$JndiRefForwardingDataSource);
    transient DataSource cachedInner;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$JndiRefForwardingDataSource;

    JndiRefForwardingDataSource() {
        VetoableChangeListener vetoableChangeListener = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                Object object = propertyChangeEvent.getNewValue();
                if ("jndiName".equals(propertyChangeEvent.getPropertyName()) && !(object instanceof Name) && !(object instanceof String)) {
                    throw new PropertyVetoException("jndiName must be a String or a javax.naming.Name", propertyChangeEvent);
                }
            }
        };
        this.addVetoableChangeListener(vetoableChangeListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JndiRefForwardingDataSource.this.cachedInner = null;
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
        C3P0Registry.register(this);
    }

    private DataSource dereference() throws SQLException {
        Object object = this.getJndiName();
        Hashtable hashtable = this.getJndiEnv();
        try {
            InitialContext initialContext = hashtable != null ? new InitialContext(hashtable) : new InitialContext();
            if (object instanceof String) {
                return (DataSource)initialContext.lookup((String)object);
            }
            if (object instanceof Name) {
                return (DataSource)initialContext.lookup((Name)object);
            }
            throw new SQLException("Could not find ConnectionPoolDataSource with JNDI name: " + object);
        }
        catch (NamingException namingException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to look up a target DataSource via JNDI!", namingException);
            }
            throw SqlUtils.toSQLException(namingException);
        }
    }

    private synchronized DataSource inner() throws SQLException {
        if (this.cachedInner != null) {
            return this.cachedInner;
        }
        DataSource dataSource = this.dereference();
        if (this.isCaching()) {
            this.cachedInner = dataSource;
        }
        return dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.inner().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.inner().getConnection(string, string2);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.inner().getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.inner().setLogWriter(printWriter);
    }

    public int getLoginTimeout() throws SQLException {
        return this.inner().getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.inner().setLoginTimeout(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

