/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPerTaskAsynchronousRunner;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.ResourceClosedException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class ThreadPoolAsynchronousRunner
implements AsynchronousRunner {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$async$ThreadPoolAsynchronousRunner == null ? (class$com$mchange$v2$async$ThreadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.class$("com.mchange.v2.async.ThreadPoolAsynchronousRunner")) : class$com$mchange$v2$async$ThreadPoolAsynchronousRunner);
    static final int POLL_FOR_STOP_INTERVAL = 5000;
    static final int DFLT_DEADLOCK_DETECTOR_INTERVAL = 10000;
    static final int DFLT_INTERRUPT_DELAY_AFTER_APPARENT_DEADLOCK = 60000;
    static final int DFLT_MAX_INDIVIDUAL_TASK_TIME = 0;
    static final int DFLT_MAX_EMERGENCY_THREADS = 10;
    int deadlock_detector_interval;
    int interrupt_delay_after_apparent_deadlock;
    int max_individual_task_time;
    int num_threads;
    boolean daemon;
    HashSet managed;
    HashSet available;
    LinkedList pendingTasks;
    Timer myTimer;
    boolean should_cancel_timer;
    TimerTask deadlockDetector = new DeadlockDetector();
    TimerTask replacedThreadInterruptor = new ReplacedThreadInterruptor();
    Map stoppedThreadsToStopDates = new HashMap();
    static /* synthetic */ Class class$com$mchange$v2$async$ThreadPoolAsynchronousRunner;

    private ThreadPoolAsynchronousRunner(int n, boolean bl, int n2, int n3, int n4, Timer timer, boolean bl2) {
        this.num_threads = n;
        this.daemon = bl;
        this.max_individual_task_time = n2;
        this.deadlock_detector_interval = n3;
        this.interrupt_delay_after_apparent_deadlock = n4;
        this.myTimer = timer;
        this.should_cancel_timer = bl2;
        this.recreateThreadsAndTasks();
        timer.schedule(this.deadlockDetector, n3, (long)n3);
        int n5 = n4 / 4;
        timer.schedule(this.replacedThreadInterruptor, n5, (long)n5);
    }

    public ThreadPoolAsynchronousRunner(int n, boolean bl, int n2, int n3, int n4, Timer timer) {
        this(n, bl, n2, n3, n4, timer, false);
    }

    public ThreadPoolAsynchronousRunner(int n, boolean bl, int n2, int n3, int n4) {
        this(n, bl, n2, n3, n4, new Timer(true), true);
    }

    public ThreadPoolAsynchronousRunner(int n, boolean bl, Timer timer) {
        this(n, bl, 0, 10000, 60000, timer, false);
    }

    public ThreadPoolAsynchronousRunner(int n, boolean bl) {
        this(n, bl, 0, 10000, 60000, new Timer(true), true);
    }

    public synchronized void postRunnable(Runnable runnable) {
        try {
            this.pendingTasks.add(runnable);
            this.notifyAll();
        }
        catch (NullPointerException nullPointerException) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "NullPointerException while posting Runnable -- Probably we're closed.", nullPointerException);
            }
            throw new ResourceClosedException("Attempted to use a ThreadPoolAsynchronousRunner in a closed or broken state.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) {
        ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = this;
        synchronized (threadPoolAsynchronousRunner) {
            Runnable runnable;
            if (this.managed == null) {
                return;
            }
            this.deadlockDetector.cancel();
            this.replacedThreadInterruptor.cancel();
            if (this.should_cancel_timer) {
                this.myTimer.cancel();
            }
            this.myTimer = null;
            Iterator iterator = this.managed.iterator();
            while (iterator.hasNext()) {
                runnable = (PoolThread)iterator.next();
                runnable.gentleStop();
                if (!bl) continue;
                runnable.interrupt();
            }
            this.managed = null;
            if (!bl) {
                iterator = this.pendingTasks.iterator();
                while (iterator.hasNext()) {
                    runnable = (Runnable)iterator.next();
                    new Thread(runnable).start();
                    iterator.remove();
                }
            }
            this.available = null;
            this.pendingTasks = null;
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized String getStatus() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(this.toString());
        stringBuffer.append(' ');
        this.appendStatusString(stringBuffer);
        return stringBuffer.toString();
    }

    private void appendStatusString(StringBuffer stringBuffer) {
        if (this.managed == null) {
            stringBuffer.append("[closed]");
        } else {
            HashSet hashSet = (HashSet)this.managed.clone();
            hashSet.removeAll(this.available);
            stringBuffer.append("[num_managed_threads: ");
            stringBuffer.append(this.managed.size());
            stringBuffer.append(", num_active: ");
            stringBuffer.append(hashSet.size());
            stringBuffer.append("; activeTasks: ");
            boolean bl = true;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                PoolThread poolThread = (PoolThread)iterator.next();
                stringBuffer.append(poolThread.getCurrentTask());
                stringBuffer.append(" (");
                stringBuffer.append(poolThread.getName());
                stringBuffer.append(')');
            }
            stringBuffer.append("; pendingTasks: ");
            int n = this.pendingTasks.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.pendingTasks.get(i));
            }
            stringBuffer.append(']');
        }
    }

    private void recreateThreadsAndTasks() {
        Object object;
        if (this.managed != null) {
            Date date = new Date();
            object = this.managed.iterator();
            while (object.hasNext()) {
                PoolThread poolThread = (PoolThread)object.next();
                poolThread.gentleStop();
                this.stoppedThreadsToStopDates.put(poolThread, date);
            }
        }
        this.managed = new HashSet();
        this.available = new HashSet();
        this.pendingTasks = new LinkedList();
        for (int i = 0; i < this.num_threads; ++i) {
            object = new PoolThread(i, this.daemon);
            this.managed.add(object);
            this.available.add(object);
            ((Thread)object).start();
        }
    }

    private void processReplacedThreads() {
        long l = System.currentTimeMillis();
        Iterator iterator = this.stoppedThreadsToStopDates.keySet().iterator();
        while (iterator.hasNext()) {
            PoolThread poolThread = (PoolThread)iterator.next();
            if (!poolThread.isAlive()) {
                iterator.remove();
                continue;
            }
            Date date = (Date)this.stoppedThreadsToStopDates.get(poolThread);
            if (l - date.getTime() <= (long)this.interrupt_delay_after_apparent_deadlock) continue;
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Task " + poolThread.getCurrentTask() + " (in deadlocked PoolThread) failed to complete in maximum time " + this.interrupt_delay_after_apparent_deadlock + "ms. Trying interrupt().");
            }
            poolThread.interrupt();
            iterator.remove();
        }
    }

    private void shuttingDown(PoolThread poolThread) {
        if (this.managed != null && this.managed.contains(poolThread)) {
            this.managed.remove(poolThread);
            this.available.remove(poolThread);
            PoolThread poolThread2 = new PoolThread(poolThread.getIndex(), this.daemon);
            this.managed.add(poolThread2);
            this.available.add(poolThread2);
            poolThread2.start();
        }
    }

    private void runInEmergencyThread(Runnable runnable) {
        final Thread thread = new Thread(runnable);
        thread.start();
        if (this.max_individual_task_time > 0) {
            TimerTask timerTask = new TimerTask(){

                public void run() {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "Task " + thread + " (in one-off task Thread created after deadlock) failed to complete in maximum time " + ThreadPoolAsynchronousRunner.this.max_individual_task_time + " ms. Trying interrupt().");
                    }
                    thread.interrupt();
                }
            };
            this.myTimer.schedule(timerTask, this.max_individual_task_time);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$000(ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner, PoolThread poolThread) {
        threadPoolAsynchronousRunner.shuttingDown(poolThread);
    }

    class DeadlockDetector
    extends TimerTask {
        LinkedList last = null;
        LinkedList current = null;

        DeadlockDetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            boolean bl = false;
            AsynchronousRunner asynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (asynchronousRunner) {
                if (ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                    this.last = null;
                    return;
                }
                this.current = (LinkedList)ThreadPoolAsynchronousRunner.this.pendingTasks.clone();
                if (this.current.equals(this.last)) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.warning(this + " -- APPARENT DEADLOCK!!! Creating emergency threads for unassigned pending tasks!");
                        object = new StringBuffer(512);
                        ((StringBuffer)object).append(this);
                        ((StringBuffer)object).append(" -- APPARENT DEADLOCK!!! Complete Status: ");
                        ThreadPoolAsynchronousRunner.this.appendStatusString((StringBuffer)object);
                        logger.warning(((StringBuffer)object).toString());
                    }
                    ThreadPoolAsynchronousRunner.this.recreateThreadsAndTasks();
                    bl = true;
                }
            }
            if (bl) {
                asynchronousRunner = new ThreadPerTaskAsynchronousRunner(10, ThreadPoolAsynchronousRunner.this.max_individual_task_time);
                object = this.current.iterator();
                while (object.hasNext()) {
                    asynchronousRunner.postRunnable((Runnable)object.next());
                }
                asynchronousRunner.close(false);
                this.last = null;
            } else {
                this.last = this.current;
            }
            this.current = null;
        }
    }

    class PoolThread
    extends Thread {
        Runnable currentTask;
        boolean should_stop;
        int index;
        TimerTask maxIndividualTaskTimeEnforcer;

        PoolThread(int n, boolean bl) {
            this.setName(this.getClass().getName() + "-#" + n);
            this.setDaemon(bl);
            this.index = n;
            if (ThreadPoolAsynchronousRunner.this.max_individual_task_time > 0) {
                this.maxIndividualTaskTimeEnforcer = new TimerTask(this){
                    private final /* synthetic */ PoolThread this$1;
                    {
                        this.this$1 = poolThread;
                    }

                    public void run() {
                        this.this$1.interrupt();
                    }
                };
            }
        }

        public int getIndex() {
            return this.index;
        }

        void gentleStop() {
            this.should_stop = true;
        }

        Runnable getCurrentTask() {
            return this.currentTask;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    class ReplacedThreadInterruptor
    extends TimerTask {
        ReplacedThreadInterruptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                ThreadPoolAsynchronousRunner.this.processReplacedThreads();
            }
        }
    }
}

