/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.util.Properties;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfigurator
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$configuration$XMLConfigurator == null ? (class$org$logicalcobwebs$proxool$configuration$XMLConfigurator = XMLConfigurator.class$("org.logicalcobwebs.proxool.configuration.XMLConfigurator")) : class$org$logicalcobwebs$proxool$configuration$XMLConfigurator);
    private StringBuffer content = new StringBuffer();
    private String poolName;
    private String driverClass;
    private String driverUrl;
    private Properties properties = new Properties();
    private static final String PROXOOL = "proxool";
    private static final String DRIVER_PROPERTIES = "driver-properties";
    private static final String PROPERTY = "property";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private boolean insideDelegateProperties;
    private boolean insideProxool;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$configuration$XMLConfigurator;

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.content.setLength(0);
        if (!this.namespaceOk(string)) {
            return;
        }
        String string4 = this.getElementName(string, string2, string3);
        if (string4.equals(PROXOOL)) {
            if (this.insideProxool) {
                throw new SAXException("A <proxool> element can't contain another <proxool> element.");
            }
            this.insideProxool = true;
            this.properties.clear();
            this.driverClass = null;
            this.driverUrl = null;
        }
        if (this.insideProxool) {
            if (string4.equals(DRIVER_PROPERTIES)) {
                this.insideDelegateProperties = true;
            } else if (this.insideDelegateProperties && string4.equals(PROPERTY)) {
                this.setDriverProperty(attributes);
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.insideProxool) {
            this.content.append(cArray, n, n2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!this.namespaceOk(string)) {
            return;
        }
        String string4 = this.getElementName(string, string2, string3);
        if (string4.equals(PROXOOL)) {
            if (this.driverClass == null || this.driverUrl == null) {
                throw new SAXException("You must define the driver-class and the driver-url.");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PROXOOL);
            if (this.poolName != null) {
                stringBuffer.append(".");
                stringBuffer.append(this.poolName);
            }
            stringBuffer.append(":");
            stringBuffer.append(this.driverClass);
            stringBuffer.append(":");
            stringBuffer.append(this.driverUrl);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created url: " + stringBuffer);
            }
            try {
                ProxoolFacade.registerConnectionPool(stringBuffer.toString(), this.properties);
            }
            catch (ProxoolException proxoolException) {
                throw new SAXException(proxoolException);
            }
            this.insideProxool = false;
        }
        if (this.insideProxool && !string4.equals(PROXOOL)) {
            if (string4.equals(DRIVER_PROPERTIES)) {
                this.insideDelegateProperties = false;
            } else if (!this.insideDelegateProperties) {
                this.setProxoolProperty(string4, this.content.toString().trim());
            }
        }
    }

    private void setProxoolProperty(String string, String string2) {
        if (string.equals("alias")) {
            this.poolName = string2;
        } else if (string.equals("driver-class")) {
            this.driverClass = string2;
        } else if (string.equals("driver-url")) {
            this.driverUrl = string2;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting property 'proxool." + string + "' to value '" + string2 + "'.");
            }
            this.properties.put("proxool." + string, string2);
        }
    }

    private void setDriverProperty(Attributes attributes) throws SAXException {
        String string = attributes.getValue(NAME);
        String string2 = attributes.getValue(VALUE);
        if (string == null || string.length() < 1 || string2 == null) {
            throw new SAXException("Name or value attribute missing from property element.Name: '" + string + "' Value: '" + string2 + "'.");
        }
        if (LOG.isDebugEnabled()) {
            if (string.toLowerCase().indexOf("password") > -1) {
                LOG.debug("Adding driver property: " + string + "=" + "*******");
            } else {
                LOG.debug("Adding driver property: " + string + "=" + string2);
            }
        }
        this.properties.put(string, string2);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        LOG.debug("The saxparser reported a warning.", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private String getElementName(String string, String string2, String string3) {
        if (string == null || "".equals(string)) {
            return string3;
        }
        return string2;
    }

    private boolean namespaceOk(String string) {
        return string == null || string.length() == 0 || string.equals("The latest version is available at http://proxool.sourceforge.net/xml-namespace");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

