/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ServletConfigurator
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$configuration$ServletConfigurator == null ? (class$org$logicalcobwebs$proxool$configuration$ServletConfigurator = ServletConfigurator.class$("org.logicalcobwebs.proxool.configuration.ServletConfigurator")) : class$org$logicalcobwebs$proxool$configuration$ServletConfigurator);
    private static final String XML_FILE_PROPERTY = "xmlFile";
    private static final String PROPERTY_FILE_PROPERTY = "propertyFile";
    private static final String AUTO_SHUTDOWN_PROPERTY = "autoShutdown";
    private boolean autoShutdown = true;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$configuration$ServletConfigurator;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = servletConfig.getServletContext().getRealPath("/");
        Properties properties = new Properties();
        Enumeration enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            File file;
            String string2 = (String)enumeration.nextElement();
            String string3 = servletConfig.getInitParameter(string2);
            if (string2.equals(XML_FILE_PROPERTY)) {
                try {
                    file = new File(string3);
                    if (file.isAbsolute()) {
                        JAXPConfigurator.configure(string3, false);
                        continue;
                    }
                    JAXPConfigurator.configure(string + File.separator + string3, false);
                }
                catch (ProxoolException proxoolException) {
                    LOG.error("Problem configuring " + string3, proxoolException);
                }
                continue;
            }
            if (string2.equals(PROPERTY_FILE_PROPERTY)) {
                try {
                    file = new File(string3);
                    if (file.isAbsolute()) {
                        PropertyConfigurator.configure(string3);
                        continue;
                    }
                    PropertyConfigurator.configure(string + File.separator + string3);
                }
                catch (ProxoolException proxoolException) {
                    LOG.error("Problem configuring " + string3, proxoolException);
                }
                continue;
            }
            if (string2.equals(AUTO_SHUTDOWN_PROPERTY)) {
                this.autoShutdown = Boolean.valueOf(string3);
                continue;
            }
            if (!string2.startsWith("jdbc")) continue;
            properties.setProperty(string2, string3);
        }
        if (properties.size() > 0) {
            try {
                PropertyConfigurator.configure(properties);
            }
            catch (ProxoolException proxoolException) {
                LOG.error("Problem configuring using init properties", proxoolException);
            }
        }
    }

    public void destroy() {
        if (this.autoShutdown) {
            ProxoolFacade.shutdown(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

