/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.configuration.XMLConfigurator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JAXPConfigurator {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$configuration$JAXPConfigurator == null ? (class$org$logicalcobwebs$proxool$configuration$JAXPConfigurator = JAXPConfigurator.class$("org.logicalcobwebs.proxool.configuration.JAXPConfigurator")) : class$org$logicalcobwebs$proxool$configuration$JAXPConfigurator);
    private static final boolean NAMESPACE_AWARE = true;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$configuration$JAXPConfigurator;

    public static void configure(String string, boolean bl) throws ProxoolException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring from xml file: " + string);
            }
            JAXPConfigurator.configure(new InputSource(new FileReader(string)), bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ProxoolException(fileNotFoundException);
        }
    }

    public static void configure(InputSource inputSource, boolean bl) throws ProxoolException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            if (LOG.isDebugEnabled()) {
                LOG.debug("SAXParserFactory class: " + sAXParserFactory.getClass().getName());
            }
            sAXParserFactory.setValidating(bl);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (LOG.isDebugEnabled()) {
                LOG.debug("sax parser class" + sAXParser.getClass().getName());
            }
            XMLReader xMLReader = sAXParser.getXMLReader();
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML reader class: " + xMLReader.getClass().getName());
            }
            XMLConfigurator xMLConfigurator = new XMLConfigurator();
            xMLReader.setErrorHandler(xMLConfigurator);
            JAXPConfigurator.setSAXFeauture(xMLReader, "http://xml.org/sax/features/namespaces", true);
            JAXPConfigurator.setSAXFeauture(xMLReader, "http://xml.org/sax/features/namespace-prefixes", false);
            sAXParser.parse(inputSource, (DefaultHandler)xMLConfigurator);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ProxoolException("Parser configuration failed", parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new ProxoolException("Parsing failed.", sAXException);
        }
        catch (IOException iOException) {
            throw new ProxoolException("Parsing failed.", iOException);
        }
    }

    public static void configure(Reader reader, boolean bl) throws ProxoolException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring from reader: " + reader);
        }
        JAXPConfigurator.configure(new InputSource(reader), bl);
    }

    private static void setSAXFeauture(XMLReader xMLReader, String string, boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting sax feature: '" + string + "'. State: " + bl + ".");
        }
        try {
            xMLReader.setFeature(string, bl);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            LOG.warn("Feature: '" + string + "' not recognised by xml reader " + xMLReader + ".", sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            LOG.warn("Feature: '" + string + "' not supported by xml reader " + xMLReader + ".", sAXNotSupportedException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

