/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.XMLConfigurator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AvalonConfigurator
implements Component,
Configurable,
ThreadSafe,
Disposable {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$configuration$AvalonConfigurator == null ? (class$org$logicalcobwebs$proxool$configuration$AvalonConfigurator = AvalonConfigurator.class$("org.logicalcobwebs.proxool.configuration.AvalonConfigurator")) : class$org$logicalcobwebs$proxool$configuration$AvalonConfigurator);
    public static final String ROLE = (class$org$logicalcobwebs$proxool$configuration$AvalonConfigurator == null ? (class$org$logicalcobwebs$proxool$configuration$AvalonConfigurator = AvalonConfigurator.class$("org.logicalcobwebs.proxool.configuration.AvalonConfigurator")) : class$org$logicalcobwebs$proxool$configuration$AvalonConfigurator).getName();
    public static final String CLOSE_ON_DISPOSE_ATTRIBUTE = "close-on-dispose";
    private boolean closeOnDispose = true;
    private final List configuredPools = new ArrayList(3);
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$configuration$AvalonConfigurator;

    public void configure(Configuration configuration) throws ConfigurationException {
        XMLConfigurator xMLConfigurator = new XMLConfigurator();
        this.closeOnDispose = configuration.getAttributeAsBoolean(CLOSE_ON_DISPOSE_ATTRIBUTE, true);
        Configuration[] configurationArray = configuration.getChildren();
        for (int i = 0; i < configurationArray.length; ++i) {
            if (configurationArray[i].getName().equals("proxool")) continue;
            throw new ConfigurationException("Found element named " + configurationArray[i].getName() + ". Only " + "proxool" + " top level elements are alowed.");
        }
        try {
            xMLConfigurator.startDocument();
            this.reportProperties(xMLConfigurator, configuration.getChildren());
            xMLConfigurator.endDocument();
        }
        catch (SAXException sAXException) {
            throw new ConfigurationException("", (Throwable)sAXException);
        }
    }

    public void dispose() {
        LOG.info("Disposing.");
        if (this.closeOnDispose) {
            Iterator iterator = this.configuredPools.iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                LOG.info("Closing connection pool '" + string + "'.");
                try {
                    ProxoolFacade.removeConnectionPool(string);
                }
                catch (ProxoolException proxoolException) {
                    LOG.error("Closing of connection pool '" + string + "' failed.", proxoolException);
                }
            }
        } else {
            LOG.info("close-on-dispose attribute is not set, so configured pools will not be closed.");
        }
        LOG.info("Disposed.");
    }

    private void reportProperties(XMLConfigurator xMLConfigurator, Configuration[] configurationArray) throws ConfigurationException, SAXException {
        Configuration[] configurationArray2 = null;
        String string = null;
        String string2 = null;
        for (int i = 0; i < configurationArray.length; ++i) {
            Configuration configuration = configurationArray[i];
            string2 = configuration.getNamespace();
            if (string2 == null) {
                string2 = "";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reporting element start for " + configuration.getName());
            }
            String string3 = string2.length() == 0 ? "" : configuration.getName();
            String string4 = string2.length() == 0 ? configuration.getName() : "";
            xMLConfigurator.startElement(string2, string3, string4, this.getAttributes(configuration));
            configurationArray2 = configuration.getChildren();
            if (configurationArray2 == null || configurationArray2.length < 1) {
                string = configuration.getValue(null);
                if (string != null) {
                    xMLConfigurator.characters(string.toCharArray(), 0, string.length());
                }
            } else {
                this.reportProperties(xMLConfigurator, configurationArray2);
            }
            xMLConfigurator.endElement(string2, string3, string4);
            if (!string3.equals("proxool") && !string4.equals("proxool")) continue;
            Configuration configuration2 = configuration.getChild("alias", false);
            if (configuration2 != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding to configured pools: " + configuration2.getValue());
                }
                this.configuredPools.add(configuration2.getValue());
                continue;
            }
            LOG.error("proxool element was missing required element 'alias'");
        }
    }

    private Attributes getAttributes(Configuration configuration) throws ConfigurationException {
        AttributesImpl attributesImpl = new AttributesImpl();
        String[] stringArray = configuration.getAttributeNames();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding attribute " + stringArray[i] + " with value " + configuration.getAttribute(stringArray[i]));
                }
                attributesImpl.addAttribute("", stringArray[i], stringArray[i], "CDATA", configuration.getAttribute(stringArray[i]));
                LOG.debug("In attributes: " + stringArray[i] + " with value " + attributesImpl.getValue(stringArray[i]));
            }
        }
        return attributesImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

