/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin.servlet;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionInfoIF;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.Version;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.logicalcobwebs.proxool.admin.StatisticsIF;

public class AdminServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$admin$servlet$AdminServlet == null ? (class$org$logicalcobwebs$proxool$admin$servlet$AdminServlet = AdminServlet.class$("org.logicalcobwebs.proxool.admin.servlet.AdminServlet")) : class$org$logicalcobwebs$proxool$admin$servlet$AdminServlet);
    protected static final String ACTION_LIST = "list";
    private static final String ACTION_STATS = "stats";
    protected static final String ACTION_CHART = "chart";
    protected static final String TYPE = "type";
    protected static final String TYPE_CONNECTIONS = "1";
    protected static final String TYPE_ACTIVITY_LEVEL = "2";
    private static final String STYLE_CAPTION = "text-align: right; color: #333333;";
    private static final String STYLE_DATA = "background: white;";
    private static final String STYLE_NO_DATA = "color: #666666;";
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String LEVEL = "level";
    private static final String LEVEL_MORE = "more";
    private static final String LEVEL_LESS = "less";
    private static final String ACTION = "action";
    private static final String ALIAS = "alias";
    private static final String CONNECTION_ID = "id";
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$admin$servlet$AdminServlet;

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setHeader("Pragma", "no-cache");
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getParameter(ACTION);
        if (string2 == null) {
            string2 = ACTION_STATS;
        }
        String string3 = httpServletRequest.getParameter(LEVEL);
        String string4 = httpServletRequest.getParameter(CONNECTION_ID);
        String string5 = httpServletRequest.getParameter(ALIAS);
        String[] stringArray = ProxoolFacade.getAliases();
        if (string5 == null) {
            if (stringArray.length == 1) {
                string5 = stringArray[0];
            } else {
                string2 = ACTION_LIST;
            }
        }
        if (string5 != null) {
            try {
                ProxoolFacade.getConnectionPoolDefinition(string5);
            }
            catch (ProxoolException proxoolException) {
                string2 = ACTION_LIST;
            }
        }
        this.openHtml(httpServletResponse.getOutputStream());
        try {
            if (string2.equals(ACTION_LIST)) {
                httpServletResponse.setContentType("text/html");
                this.doList(httpServletResponse.getOutputStream(), string5, string, string3);
            } else if (string2.equals(ACTION_STATS)) {
                httpServletResponse.setContentType("text/html");
                this.doStats(httpServletResponse.getOutputStream(), string5, string, string3, string4);
            } else {
                LOG.error("Unrecognised action '" + string2 + "'");
            }
        }
        catch (ProxoolException proxoolException) {
            LOG.error("Problem", proxoolException);
        }
        httpServletResponse.getOutputStream().println("<div style=\"text-align: right; width: 550px; color: #333333;\">Proxool " + Version.getVersion() + "</div>");
        this.closeHtml(httpServletResponse.getOutputStream());
    }

    private void doStats(ServletOutputStream servletOutputStream, String string, String string2, String string3, String string4) throws ProxoolException, IOException {
        this.doList(servletOutputStream, string, string2, string3);
        this.doDefinition(servletOutputStream, string, string2);
        this.doSnapshot(servletOutputStream, string, string2, string3, string4);
        this.doStatistics(servletOutputStream, string, string2);
    }

    private void doStatistics(ServletOutputStream servletOutputStream, String string, String string2) throws ProxoolException, IOException {
        StatisticsIF[] statisticsIFArray = ProxoolFacade.getStatistics(string);
        ConnectionPoolDefinitionIF connectionPoolDefinitionIF = ProxoolFacade.getConnectionPoolDefinition(string);
        for (int i = 0; i < statisticsIFArray.length; ++i) {
            StatisticsIF statisticsIF = statisticsIFArray[i];
            servletOutputStream.print("<b>Statistics</b> from ");
            servletOutputStream.print(TIME_FORMAT.format(statisticsIF.getStartDate()));
            servletOutputStream.print(" to ");
            servletOutputStream.print(TIME_FORMAT.format(statisticsIF.getStopDate()));
            this.openTable(servletOutputStream);
            this.printDefinitionEntry(servletOutputStream, "Served", statisticsIF.getServedCount() + " (" + DECIMAL_FORMAT.format(statisticsIF.getServedPerSecond()) + "/s)");
            this.printDefinitionEntry(servletOutputStream, "Refused", statisticsIF.getRefusedCount() + " (" + DECIMAL_FORMAT.format(statisticsIF.getRefusedPerSecond()) + "/s)");
            this.printDefinitionEntry(servletOutputStream, "Average active time", DECIMAL_FORMAT.format(statisticsIF.getAverageActiveTime() / 1000.0) + "s");
            StringBuffer stringBuffer = new StringBuffer();
            int n = (int)(100.0 * statisticsIF.getAverageActiveCount() / (double)connectionPoolDefinitionIF.getMaximumConnectionCount());
            stringBuffer.append(n);
            stringBuffer.append("%<br/>");
            String[] stringArray = new String[]{"0000ff", "eeeeee"};
            int[] nArray = new int[]{n, 100 - n};
            this.drawBarChart(stringBuffer, stringArray, nArray);
            this.printDefinitionEntry(servletOutputStream, "Activity level", stringBuffer.toString());
            this.closeTable(servletOutputStream);
        }
    }

    private void drawBarChart(StringBuffer stringBuffer, String[] stringArray, int[] nArray) {
        int n;
        stringBuffer.append("<table style=\"margin: 8px; font-size: 50%;\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            n2 += nArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            int n3 = nArray[n];
            if (n3 <= 0) continue;
            stringBuffer.append("<td bgcolor=\"#");
            stringBuffer.append(string);
            stringBuffer.append("\" width=\"");
            stringBuffer.append(100 * n3 / n2);
            stringBuffer.append("%\">&nbsp;</td>");
        }
        stringBuffer.append("</tr></table>");
    }

    private void doDefinition(ServletOutputStream servletOutputStream, String string, String string2) throws ProxoolException, IOException {
        ConnectionPoolDefinitionIF connectionPoolDefinitionIF = ProxoolFacade.getConnectionPoolDefinition(string);
        servletOutputStream.print("<b>Defintition</b> for ");
        servletOutputStream.println(string);
        this.openTable(servletOutputStream);
        this.printDefinitionEntry(servletOutputStream, "URL", connectionPoolDefinitionIF.getUrl());
        this.printDefinitionEntry(servletOutputStream, "Driver", connectionPoolDefinitionIF.getDriver());
        this.printDefinitionEntry(servletOutputStream, "Connections", connectionPoolDefinitionIF.getMinimumConnectionCount() + " (min), " + connectionPoolDefinitionIF.getMaximumConnectionCount() + " (max)");
        this.printDefinitionEntry(servletOutputStream, "Prototyping", connectionPoolDefinitionIF.getPrototypeCount() > 0 ? String.valueOf(connectionPoolDefinitionIF.getPrototypeCount()) : null);
        this.printDefinitionEntry(servletOutputStream, "Connection Lifetime", this.formatMilliseconds(connectionPoolDefinitionIF.getMaximumConnectionLifetime()));
        this.printDefinitionEntry(servletOutputStream, "Maximum active time", this.formatMilliseconds(connectionPoolDefinitionIF.getMaximumActiveTime()));
        this.printDefinitionEntry(servletOutputStream, "House keeping sleep time", connectionPoolDefinitionIF.getHouseKeepingSleepTime() / 1000 + "s");
        this.printDefinitionEntry(servletOutputStream, "House keeping test SQL", connectionPoolDefinitionIF.getHouseKeepingTestSql());
        String string3 = null;
        if (connectionPoolDefinitionIF.getFatalSqlExceptions() != null && connectionPoolDefinitionIF.getFatalSqlExceptions().size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = connectionPoolDefinitionIF.getFatalSqlExceptions().iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                stringBuffer.append(string4);
                stringBuffer.append(iterator.hasNext() ? ", " : "");
            }
            string3 = stringBuffer.toString();
        }
        this.printDefinitionEntry(servletOutputStream, "Fatal SQL exceptions", string3);
        this.printDefinitionEntry(servletOutputStream, "Wrapper", connectionPoolDefinitionIF.getFatalSqlExceptionWrapper());
        this.printDefinitionEntry(servletOutputStream, "Statistics", connectionPoolDefinitionIF.getStatistics());
        this.closeTable(servletOutputStream);
    }

    private void doSnapshot(ServletOutputStream servletOutputStream, String string, String string2, String string3, String string4) throws IOException, ProxoolException {
        boolean bl = string3 != null && string3.equals(LEVEL_MORE);
        SnapshotIF snapshotIF = ProxoolFacade.getSnapshot(string, bl);
        if (snapshotIF != null) {
            servletOutputStream.print("<b>Snapshot</b> at ");
            servletOutputStream.println(TIME_FORMAT.format(snapshotIF.getSnapshotDate()));
            this.openTable(servletOutputStream);
            this.printDefinitionEntry(servletOutputStream, "Start date", DATE_FORMAT.format(snapshotIF.getDateStarted()));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(snapshotIF.getActiveConnectionCount());
            stringBuffer.append(" (active), ");
            stringBuffer.append(snapshotIF.getAvailableConnectionCount());
            stringBuffer.append(" (available), ");
            if (snapshotIF.getOfflineConnectionCount() > 0) {
                stringBuffer.append(snapshotIF.getOfflineConnectionCount());
                stringBuffer.append(" (offline), ");
            }
            stringBuffer.append(snapshotIF.getMaximumConnectionCount());
            stringBuffer.append(" (max)<br/>");
            String[] stringArray = new String[]{"ff9999", "66cc66", "cccccc"};
            int[] nArray = new int[]{snapshotIF.getActiveConnectionCount(), snapshotIF.getAvailableConnectionCount(), snapshotIF.getMaximumConnectionCount() - snapshotIF.getActiveConnectionCount() - snapshotIF.getAvailableConnectionCount()};
            this.drawBarChart(stringBuffer, stringArray, nArray);
            this.printDefinitionEntry(servletOutputStream, "Connections", stringBuffer.toString());
            this.printDefinitionEntry(servletOutputStream, "Served", String.valueOf(snapshotIF.getServedCount()));
            this.printDefinitionEntry(servletOutputStream, "Refused", String.valueOf(snapshotIF.getRefusedCount()));
            if (!bl) {
                servletOutputStream.println("    <tr>");
                servletOutputStream.print("<td colspan=\"2\" align=\"right\"><a href=\"");
                servletOutputStream.print(string2);
                servletOutputStream.print("?");
                servletOutputStream.print(ALIAS);
                servletOutputStream.print("=");
                servletOutputStream.print(string);
                servletOutputStream.print("&");
                servletOutputStream.print(LEVEL);
                servletOutputStream.print("=");
                servletOutputStream.print(LEVEL_MORE);
                servletOutputStream.println("\">more information</a></td>");
                servletOutputStream.println("    </tr>");
            } else {
                ConnectionInfoIF connectionInfoIF;
                servletOutputStream.println("    <tr>");
                servletOutputStream.print("      <td width=\"200\" valign=\"top\" style=\"text-align: right; color: #333333;\">");
                servletOutputStream.print("Details");
                servletOutputStream.println("</td>");
                servletOutputStream.print("      <td style=\"color: #666666;\">");
                this.doSnapshotDetails(servletOutputStream, string, snapshotIF, string2, string4);
                servletOutputStream.println("</td>");
                servletOutputStream.println("    </tr>");
                long l = 0L;
                if (string4 != null && (connectionInfoIF = snapshotIF.getConnectionInfo(l = Long.valueOf(string4).longValue())) != null) {
                    servletOutputStream.println("    <tr>");
                    servletOutputStream.print("      <td width=\"200\" valign=\"top\" style=\"text-align: right; color: #333333;\">");
                    servletOutputStream.print("Connection #" + string4);
                    servletOutputStream.println("</td>");
                    servletOutputStream.print("      <td style=\"color: #666666;\">");
                    this.doDrillDownConnection(servletOutputStream, connectionInfoIF, string2);
                    servletOutputStream.println("</td>");
                    servletOutputStream.println("    </tr>");
                }
                servletOutputStream.println("    <tr>");
                servletOutputStream.print("<td colspan=\"2\" align=\"right\"><a href=\"");
                servletOutputStream.print(string2);
                servletOutputStream.print("?");
                servletOutputStream.print(ALIAS);
                servletOutputStream.print("=");
                servletOutputStream.print(string);
                servletOutputStream.print("&");
                servletOutputStream.print(LEVEL);
                servletOutputStream.print("=");
                servletOutputStream.print(LEVEL_LESS);
                servletOutputStream.println("\">less information</a></td>");
                servletOutputStream.println("    </tr>");
            }
            this.closeTable(servletOutputStream);
        }
    }

    private void doSnapshotDetails(ServletOutputStream servletOutputStream, String string, SnapshotIF snapshotIF, String string2, String string3) throws IOException {
        long l = 0L;
        if (string3 != null) {
            l = Long.valueOf(string3);
        }
        if (snapshotIF.getConnectionInfos() != null && snapshotIF.getConnectionInfos().length > 0) {
            servletOutputStream.println("<table cellpadding=\"2\" border=\"0\">");
            servletOutputStream.println("  <tbody>");
            servletOutputStream.print("<tr>");
            servletOutputStream.print("<td style=\"font-size: 90%\">#</td>");
            servletOutputStream.print("<td style=\"font-size: 90%\" align=\"center\">born</td>");
            servletOutputStream.print("<td style=\"font-size: 90%\" align=\"center\">last<br>start</td>");
            servletOutputStream.print("<td style=\"font-size: 90%\" align=\"center\">lap<br>(ms)</td>");
            servletOutputStream.print("<td style=\"font-size: 90%\" width=\"90%\">&nbsp;thread</td>");
            servletOutputStream.print("</tr>");
            ConnectionInfoIF[] connectionInfoIFArray = snapshotIF.getConnectionInfos();
            for (int i = 0; i < connectionInfoIFArray.length; ++i) {
                ConnectionInfoIF connectionInfoIF = connectionInfoIFArray[i];
                if (connectionInfoIF.getStatus() == 0) continue;
                servletOutputStream.print("<tr>");
                servletOutputStream.print("<td bgcolor=\"#");
                if (connectionInfoIF.getStatus() == 2) {
                    servletOutputStream.print("ffcccc");
                } else if (connectionInfoIF.getStatus() == 1) {
                    servletOutputStream.print("ccffcc");
                } else if (connectionInfoIF.getStatus() == 3) {
                    servletOutputStream.print("ccccff");
                }
                servletOutputStream.print("\" style=\"");
                if (l == connectionInfoIF.getId()) {
                    servletOutputStream.print("border: 1px solid black;");
                    servletOutputStream.print("\">");
                    servletOutputStream.print(connectionInfoIF.getId());
                } else {
                    servletOutputStream.print("border: 1px solid transparent;");
                    servletOutputStream.print("\"><a href=\"");
                    servletOutputStream.print(string2);
                    servletOutputStream.print("?");
                    servletOutputStream.print(ALIAS);
                    servletOutputStream.print("=");
                    servletOutputStream.print(string);
                    servletOutputStream.print("&");
                    servletOutputStream.print(LEVEL);
                    servletOutputStream.print("=");
                    servletOutputStream.print(LEVEL_MORE);
                    servletOutputStream.print("&");
                    servletOutputStream.print(CONNECTION_ID);
                    servletOutputStream.print("=");
                    servletOutputStream.print(connectionInfoIF.getId());
                    servletOutputStream.print("\">");
                    servletOutputStream.print(connectionInfoIF.getId());
                    servletOutputStream.print("</a>");
                }
                servletOutputStream.print("</td>");
                servletOutputStream.print("<td>&nbsp;");
                servletOutputStream.print(TIME_FORMAT.format(connectionInfoIF.getBirthDate()));
                servletOutputStream.print("</td>");
                servletOutputStream.print("<td>&nbsp;");
                servletOutputStream.print(connectionInfoIF.getTimeLastStartActive() > 0L ? TIME_FORMAT.format(new Date(connectionInfoIF.getTimeLastStartActive())) : "-");
                servletOutputStream.print("</td>");
                servletOutputStream.print("<td align=\"right\">");
                if (connectionInfoIF.getTimeLastStopActive() > 0L) {
                    servletOutputStream.print((int)(connectionInfoIF.getTimeLastStopActive() - connectionInfoIF.getTimeLastStartActive()));
                } else if (connectionInfoIF.getTimeLastStartActive() > 0L) {
                    servletOutputStream.print("<font color=\"red\">");
                    servletOutputStream.print((int)(snapshotIF.getSnapshotDate().getTime() - connectionInfoIF.getTimeLastStartActive()));
                    servletOutputStream.print("</font>");
                } else {
                    servletOutputStream.print("&nbsp;");
                }
                servletOutputStream.print("&nbsp;&nbsp;</td>");
                servletOutputStream.print("<td>&nbsp;");
                servletOutputStream.print(connectionInfoIF.getRequester() != null ? connectionInfoIF.getRequester() : "-");
                servletOutputStream.print("</td>");
                servletOutputStream.println("</tr>");
            }
            servletOutputStream.println("  </tbody>");
            servletOutputStream.println("</table>");
        } else {
            servletOutputStream.println("No connections yet");
        }
    }

    private void doDrillDownConnection(ServletOutputStream servletOutputStream, ConnectionInfoIF connectionInfoIF, String string) throws IOException {
        servletOutputStream.print("<div style=\"font-size: 90%\">");
        servletOutputStream.print("proxy = ");
        servletOutputStream.print(connectionInfoIF.getProxyHashcode());
        servletOutputStream.print("</div>");
        servletOutputStream.print("<div style=\"font-size: 90%\">");
        servletOutputStream.print("delegate = ");
        servletOutputStream.print(connectionInfoIF.getDelegateHashcode());
        servletOutputStream.print("</div>");
        servletOutputStream.print("<div style=\"font-size: 90%\">");
        servletOutputStream.print("url = ");
        servletOutputStream.print(connectionInfoIF.getDelegateUrl());
        servletOutputStream.print("</div>");
    }

    private void openHtml(ServletOutputStream servletOutputStream) throws IOException {
        servletOutputStream.println("<html><header><title>Proxool Admin</title></header><body BGCOLOR=\"#eeeeee\">");
    }

    private void closeHtml(ServletOutputStream servletOutputStream) throws IOException {
        servletOutputStream.println("</body></html>");
    }

    private void openTable(ServletOutputStream servletOutputStream) throws IOException {
        servletOutputStream.println("<table width=\"550\" cellpadding=\"2\" cellspacing=\"2\" border=\"0\" bgcolor=\"#EEEEEE\" style=\"border: 1px solid black\">");
        servletOutputStream.println("  <tbody>");
    }

    private void closeTable(ServletOutputStream servletOutputStream) throws IOException {
        servletOutputStream.println("  </tbody>");
        servletOutputStream.println("</table>");
        servletOutputStream.println("<br/>");
    }

    private void printDefinitionEntry(ServletOutputStream servletOutputStream, String string, String string2) throws IOException {
        servletOutputStream.println("    <tr>");
        servletOutputStream.print("      <td width=\"200\" valign=\"top\" style=\"text-align: right; color: #333333;\">");
        servletOutputStream.print(string);
        servletOutputStream.println("</td>");
        if (string2 != null) {
            servletOutputStream.print("      <td style=\"background: white;\">");
            servletOutputStream.print(string2);
        } else {
            servletOutputStream.print("      <td style=\"color: #666666;\">off");
        }
        servletOutputStream.print("</td>");
        servletOutputStream.println("    </tr>");
    }

    private void doList(ServletOutputStream servletOutputStream, String string, String string2, String string3) throws IOException, ProxoolException {
        servletOutputStream.print("<b>Pools</b>");
        this.openTable(servletOutputStream);
        String[] stringArray = ProxoolFacade.getAliases();
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            String string5 = "";
            if (string4.equals(string)) {
                string5 = STYLE_DATA;
            }
            ConnectionPoolDefinitionIF connectionPoolDefinitionIF = ProxoolFacade.getConnectionPoolDefinition(string4);
            servletOutputStream.println("    <tr style=\"" + string5 + "\">");
            servletOutputStream.print("      <td width=\"200\" style=\"text-align: right; color: #333333;\">");
            servletOutputStream.print(string4.equals(string) ? ">" : "&nbsp;");
            servletOutputStream.println("</td>");
            servletOutputStream.print("      <td><a href=\"" + string2 + "?" + ALIAS + "=" + string4 + "&" + LEVEL + "=" + string3 + "\">");
            servletOutputStream.print(string4);
            servletOutputStream.println("</a> -> ");
            servletOutputStream.print(connectionPoolDefinitionIF.getUrl());
            servletOutputStream.println("</td>");
            servletOutputStream.println("    </tr>");
        }
        this.closeTable(servletOutputStream);
    }

    private String formatMilliseconds(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.add(14, n);
        return TIME_FORMAT.format(calendar.getTime());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

