/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin.jmx;

import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.admin.jmx.ConnectionPoolMBean;

public class ProxoolJMXHelper {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$admin$jmx$ProxoolJMXHelper == null ? (class$org$logicalcobwebs$proxool$admin$jmx$ProxoolJMXHelper = ProxoolJMXHelper.class$("org.logicalcobwebs.proxool.admin.jmx.ProxoolJMXHelper")) : class$org$logicalcobwebs$proxool$admin$jmx$ProxoolJMXHelper);
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$admin$jmx$ProxoolJMXHelper;

    private ProxoolJMXHelper() {
    }

    public static void registerPool(String string, Properties properties) throws ProxoolException {
        ConnectionPoolDefinitionIF connectionPoolDefinitionIF = ProxoolFacade.getConnectionPoolDefinition(string);
        String[] stringArray = ProxoolJMXHelper.getAgentIds(properties);
        ArrayList<MBeanServer> arrayList = null;
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList = MBeanServerFactory.findMBeanServer(stringArray[i]);
            if (arrayList == null || arrayList.size() < 1) {
                LOG.error("Could not register pool " + connectionPoolDefinitionIF.getAlias() + " for JMX instrumentation" + " because lookup of MBeanServer using agent id " + stringArray[i] + " failed.");
                continue;
            }
            MBeanServer mBeanServer = arrayList.get(0);
            ConnectionPoolMBean connectionPoolMBean = new ConnectionPoolMBean(string, properties);
            try {
                mBeanServer.registerMBean(connectionPoolMBean, ProxoolJMXHelper.getObjectName(connectionPoolDefinitionIF.getAlias()));
                LOG.info("Registered JMX MBean for pool " + connectionPoolDefinitionIF.getAlias() + " in agent " + stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                LOG.error("Registration of JMX MBean for pool " + connectionPoolDefinitionIF.getAlias() + "in agent " + stringArray[i] + " failed.", exception);
            }
        }
    }

    public static void unregisterPool(String string, Properties properties) {
        String[] stringArray = ProxoolJMXHelper.getAgentIds(properties);
        ArrayList<MBeanServer> arrayList = null;
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList = MBeanServerFactory.findMBeanServer(stringArray[i]);
            if (arrayList == null || arrayList.size() < 1) {
                LOG.error("Could not unregister MBean for pool " + string + " because lookup of MBeanServer using agent id " + stringArray[i] + " failed.");
                continue;
            }
            MBeanServer mBeanServer = arrayList.get(0);
            try {
                mBeanServer.unregisterMBean(ProxoolJMXHelper.getObjectName(string));
                LOG.info("Unregistered JMX MBean for pool " + string + " in agent " + stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                LOG.error("Unregistration of JMX MBean for pool " + string + "in agent " + stringArray[i] + " failed.", exception);
            }
        }
    }

    public static ObjectName getObjectName(String string) throws MalformedObjectNameException {
        return new ObjectName("Proxool:type=Pool, name=" + string);
    }

    private static String[] getAgentIds(Properties properties) {
        String string = properties.getProperty("proxool.jmx-agent-id");
        if (string == null || string.trim().equals("")) {
            return new String[]{null};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> arrayList = new ArrayList<String>(3);
        while (stringTokenizer.hasMoreElements()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getValidIdentifier(String string) {
        if (string.indexOf("-") == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        while ((n = stringBuffer.toString().indexOf("-")) > -1) {
            stringBuffer.deleteCharAt(n);
            stringBuffer.setCharAt(n, Character.toUpperCase(stringBuffer.charAt(n)));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

