/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin;

import java.util.Calendar;
import org.logicalcobwebs.concurrent.WriterPreferenceReadWriteLock;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.admin.CompositeStatisticsListener;
import org.logicalcobwebs.proxool.admin.Statistics;

class StatsRoller {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$admin$StatsRoller == null ? (class$org$logicalcobwebs$proxool$admin$StatsRoller = StatsRoller.class$("org.logicalcobwebs.proxool.admin.StatsRoller")) : class$org$logicalcobwebs$proxool$admin$StatsRoller);
    private WriterPreferenceReadWriteLock readWriteLock = new WriterPreferenceReadWriteLock();
    private Statistics completeStatistics;
    private Statistics currentStatistics;
    private Calendar nextRollDate;
    private int period;
    private int units;
    private boolean running = true;
    private CompositeStatisticsListener compositeStatisticsListener;
    private String alias;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$admin$StatsRoller;

    public StatsRoller(String string, CompositeStatisticsListener compositeStatisticsListener, String string2) throws ProxoolException {
        this.alias = string;
        this.compositeStatisticsListener = compositeStatisticsListener;
        this.nextRollDate = Calendar.getInstance();
        if (string2.endsWith("s")) {
            this.units = 13;
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else if (string2.endsWith("m")) {
            this.units = 12;
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else if (string2.endsWith("h")) {
            this.nextRollDate.clear(11);
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
            this.units = 11;
        } else if (string2.endsWith("d")) {
            this.units = 5;
            this.nextRollDate.clear(11);
            this.nextRollDate.clear(12);
            this.nextRollDate.clear(13);
            this.nextRollDate.clear(14);
        } else {
            throw new ProxoolException("Unrecognised suffix in statistics: " + string2);
        }
        this.period = Integer.parseInt(string2.substring(0, string2.length() - 1));
        Calendar calendar = Calendar.getInstance();
        while (this.nextRollDate.before(calendar)) {
            this.nextRollDate.add(this.units, this.period);
        }
        LOG.debug("Collecting first statistics for '" + string2 + "' at " + this.nextRollDate.getTime());
        this.currentStatistics = new Statistics(calendar.getTime());
        Thread thread = new Thread(){

            public void run() {
                while (StatsRoller.this.running) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.debug("Interruption", interruptedException);
                    }
                    StatsRoller.this.roll();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected void cancel() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void roll() {
        if (!this.isCurrent()) {
            try {
                this.readWriteLock.writeLock().acquire();
                if (!this.isCurrent()) {
                    this.currentStatistics.setStopDate(this.nextRollDate.getTime());
                    this.completeStatistics = this.currentStatistics;
                    this.currentStatistics = new Statistics(this.nextRollDate.getTime());
                    this.nextRollDate.add(this.units, this.period);
                    this.compositeStatisticsListener.statistics(this.alias, this.completeStatistics);
                }
            }
            catch (Throwable throwable) {
                LOG.error("Unable to roll statistics log", throwable);
            }
            finally {
                this.readWriteLock.writeLock().release();
            }
        }
    }

    private boolean isCurrent() {
        return System.currentTimeMillis() < this.nextRollDate.getTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionReturned(long l) {
        this.roll();
        try {
            this.readWriteLock.readLock().acquire();
            this.currentStatistics.connectionReturned(l);
        }
        catch (InterruptedException interruptedException) {
            LOG.error("Unable to log connectionReturned", interruptedException);
        }
        finally {
            this.readWriteLock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionRefused() {
        this.roll();
        try {
            this.readWriteLock.readLock().acquire();
            this.currentStatistics.connectionRefused();
        }
        catch (InterruptedException interruptedException) {
            LOG.error("Unable to log connectionRefused", interruptedException);
        }
        finally {
            this.readWriteLock.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getCompleteStatistics() {
        try {
            this.readWriteLock.readLock().acquire();
            Statistics statistics = this.completeStatistics;
            return statistics;
        }
        catch (InterruptedException interruptedException) {
            LOG.error("Couldn't read statistics", interruptedException);
            Statistics statistics = null;
            return statistics;
        }
        finally {
            this.readWriteLock.readLock().release();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

