/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.proxool.admin.StatisticsIF;
import org.logicalcobwebs.proxool.admin.StatisticsListenerIF;

public class StatisticsLogger
implements StatisticsListenerIF {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final DateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private Log log;
    private String logLevel;

    public StatisticsLogger(Log log, String string) {
        this.log = log;
        this.logLevel = string;
    }

    public void statistics(String string, StatisticsIF statisticsIF) {
        if (statisticsIF != null && this.logLevel != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(TIME_FORMAT.format(statisticsIF.getStartDate()));
            stringBuffer.append(" - ");
            stringBuffer.append(TIME_FORMAT.format(statisticsIF.getStopDate()));
            stringBuffer.append(", s:");
            stringBuffer.append(statisticsIF.getServedCount());
            stringBuffer.append(":");
            stringBuffer.append(DECIMAL_FORMAT.format(statisticsIF.getServedPerSecond()));
            stringBuffer.append("/s, r:");
            stringBuffer.append(statisticsIF.getRefusedCount());
            stringBuffer.append(":");
            stringBuffer.append(DECIMAL_FORMAT.format(statisticsIF.getRefusedPerSecond()));
            stringBuffer.append("/s, a:");
            stringBuffer.append(DECIMAL_FORMAT.format(statisticsIF.getAverageActiveTime()));
            stringBuffer.append("ms/");
            stringBuffer.append(DECIMAL_FORMAT.format(statisticsIF.getAverageActiveCount()));
            if (this.logLevel.equals("TRACE")) {
                this.log.trace(stringBuffer.toString());
            } else if (this.logLevel.equals("DEBUG")) {
                this.log.debug(stringBuffer.toString());
            } else if (this.logLevel.equals("INFO")) {
                this.log.info(stringBuffer.toString());
            }
        }
    }
}

