/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin;

import java.util.Date;
import org.logicalcobwebs.proxool.admin.StatisticsIF;

class Statistics
implements StatisticsIF {
    private Date startDate;
    private Date stopDate;
    private long servedCount;
    private long refusedCount;
    private long totalActiveTime;

    protected Statistics(Date date) {
        this.startDate = date;
    }

    protected void connectionReturned(long l) {
        this.totalActiveTime += l;
        ++this.servedCount;
    }

    protected void connectionRefused() {
        ++this.refusedCount;
    }

    protected void setStopDate(Date date) {
        this.stopDate = date;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getStopDate() {
        return this.stopDate;
    }

    public long getPeriod() {
        if (this.stopDate != null) {
            return this.stopDate.getTime() - this.startDate.getTime();
        }
        return System.currentTimeMillis() - this.startDate.getTime();
    }

    public double getAverageActiveTime() {
        if (this.servedCount > 0L) {
            return (double)this.totalActiveTime / (double)this.servedCount;
        }
        return 0.0;
    }

    public double getAverageActiveCount() {
        return (double)this.totalActiveTime / (double)this.getPeriod();
    }

    public double getServedPerSecond() {
        return (double)this.servedCount / ((double)this.getPeriod() / 1000.0);
    }

    public double getRefusedPerSecond() {
        return (double)this.refusedCount / ((double)this.getPeriod() / 1000.0);
    }

    public long getServedCount() {
        return this.servedCount;
    }

    public long getRefusedCount() {
        return this.refusedCount;
    }
}

