/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool.admin;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.ConnectionPoolStatisticsIF;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.admin.CompositeStatisticsListener;
import org.logicalcobwebs.proxool.admin.Snapshot;
import org.logicalcobwebs.proxool.admin.SnapshotIF;
import org.logicalcobwebs.proxool.admin.Statistics;
import org.logicalcobwebs.proxool.admin.StatisticsIF;
import org.logicalcobwebs.proxool.admin.StatisticsListenerIF;
import org.logicalcobwebs.proxool.admin.StatisticsLogger;
import org.logicalcobwebs.proxool.admin.StatsRoller;

public class Admin {
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$admin$Admin == null ? (class$org$logicalcobwebs$proxool$admin$Admin = Admin.class$("org.logicalcobwebs.proxool.admin.Admin")) : class$org$logicalcobwebs$proxool$admin$Admin);
    private Log log;
    private Map statsRollers = new HashMap();
    private CompositeStatisticsListener compositeStatisticsListener = new CompositeStatisticsListener();
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$admin$Admin;

    public Admin(ConnectionPoolDefinitionIF connectionPoolDefinitionIF) throws ProxoolException {
        this.log = LogFactory.getLog("org.logicalcobwebs.proxool.stats." + connectionPoolDefinitionIF.getAlias());
        StringTokenizer stringTokenizer = new StringTokenizer(connectionPoolDefinitionIF.getStatistics(), ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            this.statsRollers.put(string, new StatsRoller(connectionPoolDefinitionIF.getAlias(), this.compositeStatisticsListener, string));
        }
        if (connectionPoolDefinitionIF.getStatisticsLogLevel() != null) {
            this.compositeStatisticsListener.addListener(new StatisticsLogger(this.log, connectionPoolDefinitionIF.getStatisticsLogLevel()));
        }
    }

    public void addStatisticsListener(StatisticsListenerIF statisticsListenerIF) {
        this.compositeStatisticsListener.addListener(statisticsListenerIF);
    }

    public void connectionReturned(long l) {
        try {
            Iterator iterator = this.statsRollers.values().iterator();
            while (iterator.hasNext()) {
                StatsRoller statsRoller = (StatsRoller)iterator.next();
                statsRoller.connectionReturned(l);
            }
        }
        catch (Throwable throwable) {
            LOG.error("Stats connectionReturned call failed. Ignoring.", throwable);
        }
    }

    public void connectionRefused() {
        try {
            Iterator iterator = this.statsRollers.values().iterator();
            while (iterator.hasNext()) {
                StatsRoller statsRoller = (StatsRoller)iterator.next();
                statsRoller.connectionRefused();
            }
        }
        catch (Exception exception) {
            LOG.error("Stats connectionRefused call failed. Ignoring.", exception);
        }
    }

    public StatisticsIF getStatistics(String string) {
        try {
            return ((StatsRoller)this.statsRollers.get(string)).getCompleteStatistics();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void cancelAll() {
        Iterator iterator = this.statsRollers.values().iterator();
        while (iterator.hasNext()) {
            StatsRoller statsRoller = (StatsRoller)iterator.next();
            statsRoller.cancel();
        }
    }

    public StatisticsIF[] getStatistics() {
        Vector<Statistics> vector = new Vector<Statistics>();
        Iterator iterator = this.statsRollers.values().iterator();
        while (iterator.hasNext()) {
            StatsRoller statsRoller = (StatsRoller)iterator.next();
            Statistics statistics = statsRoller.getCompleteStatistics();
            if (statistics == null) continue;
            vector.add(statistics);
        }
        return vector.toArray(new StatisticsIF[vector.size()]);
    }

    public static SnapshotIF getSnapshot(ConnectionPoolStatisticsIF connectionPoolStatisticsIF, ConnectionPoolDefinitionIF connectionPoolDefinitionIF, Collection collection) {
        Snapshot snapshot = new Snapshot(new Date());
        snapshot.setDateStarted(connectionPoolStatisticsIF.getDateStarted());
        snapshot.setActiveConnectionCount(connectionPoolStatisticsIF.getActiveConnectionCount());
        snapshot.setAvailableConnectionCount(connectionPoolStatisticsIF.getAvailableConnectionCount());
        snapshot.setOfflineConnectionCount(connectionPoolStatisticsIF.getOfflineConnectionCount());
        snapshot.setMaximumConnectionCount(connectionPoolDefinitionIF.getMaximumConnectionCount());
        snapshot.setServedCount(connectionPoolStatisticsIF.getConnectionsServedCount());
        snapshot.setRefusedCount(connectionPoolStatisticsIF.getConnectionsRefusedCount());
        snapshot.setConnectionInfos(collection);
        return snapshot;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

